---
generated_at: 2026-01-21 00:00:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に対して根拠が確認されました。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00002.sql`
- E-02: `src/apex/f141/application/pages/page_00004.sql`
- E-03: `src/apex/f141/application/pages/page_00005.sql`
- E-04: `src/apex/f141/application/pages/page_00006.sql`
- E-05: `src/apex/f141/application/pages/page_00007.sql`
- E-06: `src/apex/f141/application/pages/page_00008.sql`
- E-07: `src/apex/f141/application/pages/page_00009.sql`
- E-08: `src/apex/f141/application/pages/page_00011.sql`
- E-09: `src/apex/f141/application/pages/page_09999.sql`
- E-10: `src/apex/f141/application/shared_components/user_interface/templates/region/alert.sql`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイルアップロード成功通知「File uploaded.」 | E-03 (line 271: process_success_message) | ○ |
| C-02 | ユニットテスト作成成功通知「Unit Tests created.」 | E-01 (line 272: process_success_message) | ○ |
| C-03 | ユニットテスト削除成功通知「Unit Tests deleted.」 | E-01 (line 285: process_success_message) | ○ |
| C-04 | ルール保存成功通知「Changes saved.」 | E-05 (line 554: process_success_message) | ○ |
| C-05 | ファイルインポート成功通知「File imported.」 | E-06 (line 233: process_success_message) | ○ |
| C-06 | スケジューラ設定保存成功通知「Saved.」 | E-07 (line 419: process_success_message) | ○ |
| C-07 | スケジューラジョブ開始通知「Cronjob started.」 | E-07 (line 432: process_success_message) | ○ |
| C-08 | ユニットテストジョブ開始通知「Job started.」 | E-08 (line 376: process_success_message) | ○ |
| C-09 | バリデーションエラー通知（INLINE_IN_NOTIFICATION） | E-01, E-03, E-05, E-06, E-07, E-08, E-09 | ○ |
| C-10 | バリデーションエラー通知（INLINE_WITH_FIELD_AND_NOTIFICATION） | E-01 (line 219), E-05 (line 457, 489, 521) | ○ |
| C-11 | 情報アラート表示（t-Alert--info） | E-01, E-03, E-07, E-08 | ○ |
| C-12 | ルール削除不可通知 | E-05 (line 455-458: validation error_message) | ○ |
| C-13 | ルール重複エラー通知 | E-05 (line 486: validation error_message) | ○ |
| C-14 | ルール名重複エラー通知 | E-05 (line 518: validation error_message) | ○ |
| C-15 | オプション未選択エラー通知 | E-01 (line 216: validation error_message) | ○ |
| C-16 | レポートダウンロード通知（show_notify='Y'） | E-02 (line 89), E-04 (line 86) | ○ |
| C-17 | レポートメール送信機能（enable_mail_download='Y'） | E-02 (line 91), E-03 (line 91), E-04 (line 88), E-06 (line 89) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての通知機能について根拠を確認できました。
- 注意：プロジェクト内にAPEX_MAILやUTL_SMTPを使用した外部メール送信機能は検出されませんでした。通知機能はAPEX標準のアプリ内通知とInteractive Reportのメールダウンロード機能に限定されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての通知がAPEXページ定義から直接抽出されており、根拠が明確です。

## 6) レビュアーチェックリスト（最小）
- [ ] 各成功メッセージの表示タイミングが業務要件と一致しているか確認
- [ ] バリデーションエラーメッセージの内容がユーザーに分かりやすいか確認
- [ ] メールダウンロード機能の利用可否がセキュリティポリシーに適合しているか確認
- [ ] 情報アラート表示の内容が最新の仕様と一致しているか確認
