# 通知設計書 10-バリデーションエラー通知（フィールド付）

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるフォームバリデーションエラー発生時に、該当フィールドとページ上部の通知領域の両方にエラーメッセージを表示するアプリ内通知「バリデーションエラー通知（フィールド付）」の設計を記述する。

### 本通知の処理概要

この通知は、フォーム入力のバリデーションでエラーが検出された際に、エラーメッセージを該当フィールドの近くと、ページ上部の通知領域（INLINE_WITH_FIELD_AND_NOTIFICATION）の両方に同時表示する機能である。ユーザーはエラーが発生したフィールドを即座に特定でき、同時に通知領域でエラーの全体像も把握できる。

**業務上の目的・背景**：フォーム入力時に複数のバリデーションエラーが発生する場合がある。INLINE_WITH_FIELD_AND_NOTIFICATION方式では、エラーが発生した具体的なフィールドが視覚的に強調されるとともに、通知領域にもメッセージが表示されるため、ユーザーは何を修正すべきかを明確に理解できる。

**通知の送信タイミング**：ユーザーがボタンをクリックしてフォームをサブミットし、サーバー側でバリデーションが実行されてエラーが検出された時点でAPEXのバリデーションエラーメッセージ機能により自動的に表示される。

**通知の受信者**：操作を実行した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：バリデーションエラーの内容に応じたメッセージが、該当フィールドの近くとページ上部の通知領域の両方にインライン表示される。

**期待されるアクション**：ユーザーはエラーが発生したフィールドを確認し、入力内容を修正して再度操作を行う。

## 通知種別

アプリ内通知（Oracle APEXのバリデーションエラーメッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 高 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | フィールド近く + ページ上部の通知領域（INLINE_WITH_FIELD_AND_NOTIFICATION） |
| メッセージタイプ | エラー（Error） |
| 自動消去 | 無（ユーザーが閉じるまで、または再サブミットまで表示継続） |

### 本文テンプレート

以下は代表的なバリデーションエラーメッセージ：

**オプション未選択エラー（page_00002）**:
```
Please select the Option.
```

**ルール削除不可エラー（page_00007）**:
```
The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead.
```

**ルール番号重複エラー（page_00007）**:
```
Rulenumber already exists for this client.
```

**ルール名重複エラー（page_00007）**:
```
Rulename already exists for this client.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バリデーション | フォームサブミット | p_error_display_location='INLINE_WITH_FIELD_AND_NOTIFICATION'のバリデーションでエラー発生 | 対象ページ: 00002, 00007 |

### バリデーション一覧

| ページ | バリデーション名 | 関連フィールド | エラーメッセージ | 備考 |
|-------|----------------|--------------|----------------|------|
| page_00002 | Validate Option | P2_OPTION | Please select the Option. | CREATEボタン押下時 |
| page_00007 | Validate Deletion | - | The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead. | DELETEボタン押下時 |
| page_00007 | Validate Rulenumber | P7_QARU_RULE_NUMBER | Rulenumber already exists for this client. | CREATEボタン押下時 |
| page_00007 | Validate Rulename | P7_QARU_RULE_NAME | Rulename already exists for this client. | CREATEボタン押下時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| バリデーション成功時 | バリデーションが通過した場合はエラーメッセージは表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ボタンクリック/フォームサブミット] --> B[バリデーション実行]
    B --> C{バリデーション結果}
    C -->|成功| D[プロセス実行]
    C -->|失敗| E{error_display_location}
    E -->|INLINE_WITH_FIELD_AND_NOTIFICATION| F[フィールド＋通知領域にエラー表示]
    F --> G[ユーザーがエラー確認]
    D --> H[成功メッセージ表示]
    G --> I[入力修正]
    I --> A
    H --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

バリデーション時にデータベースを参照してチェックを行う。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| QA_RULES | ルール番号・ルール名の重複チェック | page_00007バリデーション |
| QA_TEST_RUNS | テスト結果存在チェック | page_00007削除バリデーション |

### テーブル別参照項目詳細

#### QA_RULES

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| qaru_rule_number | ルール番号重複チェック | qaru_client_name = :P7_QARU_CLIENT_NAME AND qaru_rule_number = :P7_QARU_RULE_NUMBER |
| qaru_rule_name | ルール名重複チェック | qaru_client_name = :P7_QARU_CLIENT_NAME AND qaru_rule_name = :P7_QARU_RULE_NAME |

#### QA_TEST_RUNS

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| qatr_qaru_id | テスト結果存在確認 | qatr_qaru_id = :P7_QARU_ID |

### 更新テーブル一覧

バリデーション自体はデータベースを更新しない。

#### 送信ログテーブル

通知自体のログはAPEXセッション管理によるもので、個別のログテーブルには保存されない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| オプション未選択 | P2_OPTIONが空 | エラーメッセージ表示、フィールド強調 |
| テスト結果存在 | 削除対象ルールにテスト結果が存在 | エラーメッセージ表示、削除処理中止 |
| ルール番号重複 | 同一クライアントで既存ルール番号 | エラーメッセージ表示、フィールド強調 |
| ルール名重複 | 同一クライアントで既存ルール名 | エラーメッセージ表示、フィールド強調 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（ユーザーが入力修正後に再サブミット） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- バリデーションはサーバー側で実行され、クライアント側でバイパスできない
- エラーメッセージに機密情報は含まない
- 保護レベル: 各ページに依存（多くはC: チェックサム保護）

## 備考

- 本通知はAPEXの標準機能（error_display_location）を利用している
- エラーメッセージは自動消去されず、ユーザーが入力を修正して再サブミットするまで表示される
- フィールドに関連付けられたバリデーションは、p_associated_itemで指定されたフィールドの近くに表示される
- フィールドの近くに表示されるエラーは、CSSスタイルで視覚的に強調される
- 削除バリデーション（Validate Deletion）はフィールド関連付けがないため、通知領域のみに表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: APEXページ定義でバリデーションを確認する

各ページのバリデーション定義でerror_display_locationがINLINE_WITH_FIELD_AND_NOTIFICATIONに設定されている箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | 209-220行のValidate Optionバリデーションを確認 |
| 1-2 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 446-458行のValidate Deletionバリデーションを確認 |
| 1-3 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 459-490行のValidate Rulenumberバリデーションを確認 |
| 1-4 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 491-522行のValidate Rulenameバリデーションを確認 |

**読解のコツ**: p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'の設定がある箇所で、p_associated_itemでフィールドとの関連付けが行われている。

#### Step 2: バリデーション条件を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | 213-214行のvalidation_expression2を確認（:P2_OPTION is not null） |
| 2-2 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 450-453行のvalidation_expression2を確認（f_has_rule_test_results） |
| 2-3 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 467-484行のvalidation_expression2を確認（ルール番号重複チェックSQL） |
| 2-4 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 499-516行のvalidation_expression2を確認（ルール名重複チェックSQL） |

**主要なバリデーション条件**:
- **Validate Option**: `:P2_OPTION is not null`が真の場合に成功
- **Validate Deletion**: `qa_unit_tests_pkg.f_has_rule_test_results(...) = false`が真の場合に成功
- **Validate Rulenumber**: 重複するルール番号が0件の場合に成功
- **Validate Rulename**: 重複するルール名が0件の場合に成功

#### Step 3: 関連するPL/SQL関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_has_rule_test_results関数（1388-1433行）を確認 |

### プログラム呼び出し階層図

```
APEXフォームサブミット
    │
    └─ バリデーション実行
           │
           ├─ Validate Option (page_00002)
           │      │
           │      └─ :P2_OPTION is not null チェック
           │
           ├─ Validate Deletion (page_00007)
           │      │
           │      └─ qa_unit_tests_pkg.f_has_rule_test_results
           │             │
           │             └─ QA_TEST_RUNS (SELECT)
           │
           ├─ Validate Rulenumber (page_00007)
           │      │
           │      └─ QA_RULES (SELECT COUNT)
           │
           └─ Validate Rulename (page_00007)
                  │
                  └─ QA_RULES (SELECT COUNT)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォームサブミット ───▶ バリデーション実行
                              │
                    ┌─────────┴─────────┐
                    │                   │
                    ▼                   ▼
           バリデーション成功    バリデーション失敗
                    │                   │
                    ▼                   ▼
            プロセス実行        error_display_location判定
                                        │
                                        ▼
                    INLINE_WITH_FIELD_AND_NOTIFICATION
                                        │
                    ┌───────────────────┴───────────────────┐
                    │                                       │
                    ▼                                       ▼
          フィールド近くに表示                    通知領域にも表示
          (p_associated_itemで関連付け)            (同一メッセージ)
                    │                                       │
                    └───────────────────┬───────────────────┘
                                        │
                                        ▼
                               ユーザーがエラー確認
                                        │
                                        ▼
                                    入力修正
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | ユニットテスト生成ページ（オプション未選択バリデーション） |
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | ルール編集ページ（削除・重複バリデーション） |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_has_rule_test_results関数 |
