# 通知設計書 11-情報アラート表示

## 概要

本ドキュメントは、QUASTOアプリケーションにおける情報アラート表示通知の設計を記述したものである。この通知はOracle APEXのAlert Regionテンプレートを使用してページ内に情報メッセージを表示する機能である。

### 本通知の処理概要

情報アラート表示は、ユーザーに対して操作に関するガイダンスや注意事項をページ内に視覚的に表示する機能である。

**業務上の目的・背景**：ユーザーがページの機能や操作を正しく理解できるよう、重要な情報や注意事項を目立つ形式で表示する必要がある。特にUnit Test Generation、Test Result Files、Config Scheduler Job、Restart Unit Testなどの複雑な機能を持つページでは、操作前に必要な前提知識をユーザーに提供することが重要である。

**通知の送信タイミング**：ページロード時に静的に表示される。ユーザーがページにアクセスした瞬間から常に表示され、ページを離れるまで継続して表示される。

**通知の受信者**：該当ページにアクセスしたすべてのユーザーが対象である。アプリケーションにログインし、該当機能ページを開いたユーザーに表示される。

**通知内容の概要**：各ページの機能説明、操作手順のガイダンス、注意事項などの静的なテキストメッセージが表示される。例えば、Unit Test Generationページでは「Select the scheme names for which you want to generate or delete the Unit Tests for.」というガイダンスが表示される。

**期待されるアクション**：ユーザーは表示された情報を読んで理解し、適切な操作を行うことが期待される。情報アラートは読み取り専用であり、ユーザーからの直接的なアクションは不要である。

## 通知種別

アプリ内通知（Oracle APEX Alert Region Template使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページレンダリング時） |
| 優先度 | 中 |
| リトライ | なし（静的コンテンツ） |

### 送信先決定ロジック

ページにアクセスしたすべてのユーザーに表示される。特別な権限チェックやロールベースの表示制御は行われない。

## 通知テンプレート

### アラートテンプレート構造

| 項目 | 内容 |
|-----|------|
| テンプレート名 | Alert |
| 内部名 | ALERT |
| テーマID | 42 |
| テンプレートオプション | t-Alert--horizontal:t-Alert--defaultIcons:t-Alert--info:t-Alert--removeHeading js-removeLandmark |

### 本文テンプレート

```html
<div class="t-Alert t-Alert--horizontal t-Alert--defaultIcons t-Alert--info t-Alert--removeHeading js-removeLandmark">
  <div class="t-Alert-wrap">
    <div class="t-Alert-icon">
      <span class="t-Icon" aria-hidden="true"></span>
    </div>
    <div class="t-Alert-content">
      <div class="t-Alert-header">
        <h2 class="t-Alert-title">{TITLE}</h2>
      </div>
      <div class="t-Alert-body">{MESSAGE_CONTENT}</div>
    </div>
  </div>
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| MESSAGE_CONTENT | 表示するメッセージ本文 | page_*.sql: p_plug_source | Yes |
| TITLE | アラートのタイトル（通常は非表示設定） | page_*.sql: p_plug_name | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ページロード | なし（常時表示） | ページレンダリング時にInfo Regionが表示される |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 静的コンテンツのため抑止条件なし |

## 処理フロー

### 表示フロー

```mermaid
flowchart TD
    A[ページアクセス] --> B[APEXページレンダリング開始]
    B --> C[Alert Regionプラグイン呼び出し]
    C --> D[テンプレートオプション適用]
    D --> E[HTMLレンダリング]
    E --> F[CSSスタイル適用]
    F --> G[ページ表示完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 静的コンテンツのためDB参照なし | メッセージはページ定義に直接記述 |

### テーブル別参照項目詳細

該当なし（静的コンテンツ）

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | なし | 表示のみ、データ更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| テンプレートエラー | テンプレートID不正 | アプリケーション開発時に検証 |
| レンダリングエラー | APEXエンジン障害 | アプリケーション再起動 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ページアクセス時に常時表示）

## セキュリティ考慮事項

- 静的テキストコンテンツのみのため、XSS対策としてAPEXのデフォルトエスケープ機能が適用される
- 個人情報は含まれないため、特別なセキュリティ対策は不要
- ページアクセス権限はAPEX認証・認可機能で制御される

## 備考

- 使用ページ: page_00002（Unit Test Generation）, page_00005（Test Result Files）, page_00009（Config Scheduler Job）, page_00011（Restart Unit Test）
- テンプレートID: wwv_flow_imp.id(50721469375675106)
- 情報アラートはInfoスタイル（t-Alert--info）で表示され、青色のアイコンと背景で情報を伝達する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

情報アラートは静的HTMLテンプレートを使用するため、まずAlertテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | alert.sql | `src/apex/f141/application/shared_components/user_interface/templates/region/alert.sql` | Alertテンプレートの HTML構造とCSSクラス |

**読解のコツ**: p_templateパラメータ内のHTML構造がレンダリング時に使用される。t-Alert-*クラスがスタイルを制御する。

#### Step 2: エントリーポイントを理解する

各ページでInfo Regionがどのように定義されているかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | Unit Test GenerationページのInfo Region定義 |
| 2-2 | page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | Test Result FilesページのInfo Region定義 |
| 2-3 | page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | Config Scheduler JobページのInfo Region定義 |
| 2-4 | page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | Restart Unit TestページのInfo Region定義 |

**主要処理フロー**:
1. **行37-51（page_00002.sql）**: wwv_flow_imp_page.create_page_plugでInfo Regionを作成
2. **行39-41**: p_plug_name=>'Info'でリージョン名を設定
3. **行41**: region_template_optionsでt-Alert--infoスタイルを指定
4. **行45-47**: p_plug_sourceでメッセージ本文を設定

### プログラム呼び出し階層図

```
ページレンダリング
    │
    ├─ wwv_flow_imp_page.create_page_plug
    │      │
    │      ├─ plug_template => Alert Template (50721469375675106)
    │      │
    │      ├─ region_template_options => 't-Alert--info'
    │      │
    │      └─ plug_source => メッセージHTML
    │
    └─ APEXレンダリングエンジン
           └─ HTMLテンプレート展開
```

### データフロー図

```
[入力]               [処理]                    [出力]

ページ定義SQL ───▶ APEXメタデータ解析 ───▶ HTML生成
                         │
p_plug_source ─────▶ テンプレート展開 ───▶ ブラウザ表示
                         │
template_options ──▶ CSSクラス適用 ────▶ スタイル表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| alert.sql | `src/apex/f141/application/shared_components/user_interface/templates/region/alert.sql` | テンプレート | Alertリージョンテンプレート定義 |
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | Unit Test GenerationページでのInfo Region使用 |
| page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | ソース | Test Result FilesページでのInfo Region使用 |
| page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | ソース | Config Scheduler JobページでのInfo Region使用 |
| page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | ソース | Restart Unit TestページでのInfo Region使用 |
