# 通知設計書 12-ルール削除不可通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるルール削除不可通知の設計を記述したものである。この通知は、テスト結果が存在するルールを削除しようとした際に表示されるバリデーションエラーメッセージである。

### 本通知の処理概要

ルール削除不可通知は、ユーザーがテスト結果を持つルールを削除しようとした際に、データ整合性を保つために削除操作を拒否し、代替アクション（非活性化）を促すエラーメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOでは各ルールに対してユニットテスト結果が紐づいている。テスト結果が存在するルールを削除すると、過去のテスト履歴やトレーサビリティが失われるため、データ整合性の観点からルールの物理削除を禁止し、代わりに論理削除（非活性化）を推奨する必要がある。

**通知の送信タイミング**：ユーザーがAdd/Edit Ruleページ（page_00007）でDeleteボタンをクリックした際に、サーバーサイドでバリデーションが実行され、テスト結果が存在する場合にこの通知が表示される。

**通知の受信者**：ルール編集ページでDeleteボタンを押下したユーザーが対象である。

**通知内容の概要**：「The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead.」というエラーメッセージが表示され、ルールを削除できない理由と代替手段を明確に伝える。

**期待されるアクション**：ユーザーは削除ではなく、ルールを「Inactive」に設定することで論理的にルールを無効化することが期待される。

## 通知種別

アプリ内通知（バリデーションエラー通知 - INLINE_WITH_FIELD_AND_NOTIFICATION）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（フォームサブミット時） |
| 優先度 | 高 |
| リトライ | なし（即座に表示） |

### 送信先決定ロジック

Deleteボタンを押下したユーザーに対して直接表示される。

## 通知テンプレート

### エラーメッセージテンプレート

| 項目 | 内容 |
|-----|------|
| 表示位置 | INLINE_WITH_FIELD_AND_NOTIFICATION |
| 表示方式 | フィールドおよび通知エリアの両方に表示 |

### 本文テンプレート

```
The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | page_00007.sql: p_error_message | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Deleteボタン押下 | テスト結果が存在する場合 | qa_unit_tests_pkg.f_has_rule_test_resultsがTRUEを返す場合にエラー表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| テスト結果が存在しない | f_has_rule_test_resultsがFALSEを返す場合は削除が許可される |

## 処理フロー

### バリデーションフロー

```mermaid
flowchart TD
    A[Deleteボタン押下] --> B[AFTER_SUBMIT処理開始]
    B --> C[Validate if rule can be deleted実行]
    C --> D{f_has_rule_test_results}
    D -->|TRUE| E[エラーメッセージ表示]
    D -->|FALSE| F[削除処理続行]
    E --> G[処理中断]
    F --> H[DML処理実行]
    G --> I[ユーザーにエラー通知]
    H --> J[削除完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| qa_rules | ルール情報参照 | qaru_rule_number, qaru_client_nameで検索 |
| テスト結果テーブル | テスト結果存在確認 | f_has_rule_test_results内部で参照 |

### テーブル別参照項目詳細

#### qa_rules

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| qaru_rule_number | ルール番号 | :P7_QARU_RULE_NUMBER |
| qaru_client_name | クライアント名 | :P7_QARU_CLIENT_NAME |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | なし | バリデーションエラー時は更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バリデーションエラー | テスト結果存在時の削除試行 | エラーメッセージ表示、操作拒否 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- ルールのRule NumberとClient Nameに基づくチェックにより、不正な削除操作を防止
- APEXのセッション管理により、認証済みユーザーのみが操作可能
- PL/SQL関数を通じたチェックにより、クライアントサイドでの改ざんを防止

## 備考

- 使用ページ: page_00007（Add/Edit Rule）
- バリデーション名: Validate if rule can be deleted
- バリデーションシーケンス: 10
- 関連パッケージ: qa_unit_tests_pkg.f_has_rule_test_results

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バリデーションに使用されるデータ構造とPL/SQL関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | バリデーション定義とエラーメッセージ |

**読解のコツ**: create_page_validationプロシージャでバリデーションロジックを定義。p_validationパラメータ内のPL/SQL式が評価される。

#### Step 2: エントリーポイントを理解する

バリデーションがどのように呼び出されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | Deleteボタンとバリデーションの関連付け |

**主要処理フロー**:
1. **行446-458**: wwv_flow_imp_page.create_page_validationでバリデーション定義
2. **行447**: p_validation_name=>'Validate if rule can be deleted'
3. **行450-452**: p_validationでf_has_rule_test_results関数を呼び出し
4. **行455**: p_error_messageでエラーメッセージを設定
5. **行456**: p_when_button_pressed=>wwv_flow_imp.id(54468111224367589)でDELETEボタンに紐付け
6. **行457**: p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'

#### Step 3: バリデーションロジックを理解する

PL/SQL関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg | （パッケージ仕様/本体） | f_has_rule_test_results関数の実装 |

**主要処理フロー**:
- qa_unit_tests_pkg.f_has_rule_test_results(pi_qaru_rule_number, pi_qaru_client_name)
- ルール番号とクライアント名を受け取り、テスト結果の存在をBOOLEANで返す

### プログラム呼び出し階層図

```
ユーザー操作（Deleteボタン押下）
    │
    ├─ APEXフォームサブミット
    │      │
    │      └─ AFTER_SUBMIT処理
    │             │
    │             ├─ create_page_validation実行
    │             │      │
    │             │      └─ qa_unit_tests_pkg.f_has_rule_test_results
    │             │             │
    │             │             ├─ pi_qaru_rule_number => :P7_QARU_RULE_NUMBER
    │             │             │
    │             │             └─ pi_qaru_client_name => :P7_QARU_CLIENT_NAME
    │             │
    │             └─ バリデーション結果判定
    │                    │
    │                    ├─ FALSE: 削除処理続行
    │                    │
    │                    └─ TRUE: エラーメッセージ表示
    │
    └─ 処理結果をユーザーに表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P7_QARU_RULE_NUMBER ───▶ f_has_rule_test_results ──▶ BOOLEAN
P7_QARU_CLIENT_NAME ───▶        検証              ──▶ (TRUE/FALSE)
                              │
                              │ TRUE の場合
                              ▼
               エラーメッセージ表示 ──▶ 通知エリア + フィールド
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | Add/Edit Ruleページでのバリデーション定義 |
| qa_unit_tests_pkg | （データベース内） | パッケージ | f_has_rule_test_results関数の実装 |
