# 通知設計書 14-ルール名重複エラー通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるルール名重複エラー通知の設計を記述したものである。この通知は、既存のルール名で新しいルールを作成しようとした際に表示されるバリデーションエラーメッセージである。

### 本通知の処理概要

ルール名重複エラー通知は、ユーザーが既に存在するルール名とクライアント名の組み合わせで新しいルールを作成しようとした際に、重複を検出してエラーメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOでは、ルール名はユーザーがルールを識別するための重要な情報である。同一クライアント内で同じルール名が複数存在すると、ユーザーがルールを区別できなくなり、運用上の混乱が生じる。このため、ルール名の重複を事前に防止することでユーザビリティとデータ品質を保つ必要がある。

**通知の送信タイミング**：ユーザーがAdd/Edit Ruleページ（page_00007）でCreateボタンをクリックした際に、サーバーサイドでバリデーションが実行され、同一クライアント内に同じルール名が存在する場合にこの通知が表示される。

**通知の受信者**：ルール作成ページでCreateボタンを押下したユーザーが対象である。

**通知内容の概要**：「Rulename already exists for this client.」というエラーメッセージが表示され、入力されたルール名が既に使用されていることをユーザーに通知する。

**期待されるアクション**：ユーザーは別のルール名を入力することが期待される。

## 通知種別

アプリ内通知（バリデーションエラー通知 - INLINE_WITH_FIELD_AND_NOTIFICATION）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（フォームサブミット時） |
| 優先度 | 高 |
| リトライ | なし（即座に表示） |

### 送信先決定ロジック

Createボタンを押下したユーザーに対して直接表示される。

## 通知テンプレート

### エラーメッセージテンプレート

| 項目 | 内容 |
|-----|------|
| 表示位置 | INLINE_WITH_FIELD_AND_NOTIFICATION |
| 表示方式 | Nameフィールドおよび通知エリアの両方に表示 |
| 関連フィールド | P7_QARU_NAME |

### 本文テンプレート

```
Rulename already exists for this client.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | page_00007.sql: p_error_message | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Createボタン押下 | 同一クライアント内に同一ルール名が存在 | qa_rulesテーブルに同一のqaru_nameとqaru_client_nameの組み合わせが存在する場合にエラー表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ルール名が重複していない | qa_rulesテーブルにレコードが存在しない場合は作成が許可される |

## 処理フロー

### バリデーションフロー

```mermaid
flowchart TD
    A[Createボタン押下] --> B[AFTER_SUBMIT処理開始]
    B --> C[Validate if Name already exists実行]
    C --> D{qa_rulesテーブル検索}
    D -->|count > 0| E[エラーメッセージ表示]
    D -->|count = 0| F[作成処理続行]
    E --> G[処理中断]
    F --> H[INSERT処理実行]
    G --> I[ユーザーにエラー通知]
    H --> J[作成完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| qa_rules | ルール名の重複チェック | qaru_name, qaru_client_nameで検索 |

### テーブル別参照項目詳細

#### qa_rules

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| qaru_name | ルール名 | WHERE qaru_name = :P7_QARU_NAME |
| qaru_client_name | クライアント名 | AND qaru_client_name = :P7_QARU_CLIENT_NAME |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | なし | バリデーションエラー時は更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バリデーションエラー | ルール名重複時 | エラーメッセージ表示、操作拒否 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- サーバーサイドでの重複チェックにより、クライアントサイドでの改ざんを防止
- SQLインジェクション対策として、APEXバインド変数を使用
- APEXのセッション管理により、認証済みユーザーのみが操作可能

## 備考

- 使用ページ: page_00007（Add/Edit Rule）
- バリデーション名: Validate if Name already exists
- バリデーションシーケンス: 30
- 関連アイテム: P7_QARU_NAME

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バリデーションに使用されるテーブル構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | バリデーション定義とSQL文 |

**読解のコツ**: create_page_validationプロシージャ内のp_validationパラメータに記述されたPL/SQL無名ブロックがバリデーションロジックを実装している。ルール番号重複チェック（バリデーションシーケンス20）との違いは検索カラムのみ。

#### Step 2: エントリーポイントを理解する

バリデーションがどのように呼び出されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | Createボタンとバリデーションの関連付け |

**主要処理フロー**:
1. **行491-522**: wwv_flow_imp_page.create_page_validationでバリデーション定義
2. **行492**: p_validation_name=>'Validate if Name already exists'
3. **行493**: p_validation_sequence=>30
4. **行495-515**: p_validationでPL/SQL無名ブロックを定義
5. **行499-503**: qa_rulesテーブルからcount(1)を取得するSELECT文
6. **行502**: WHERE qaru_name = :P7_QARU_NAME（ルール名で検索）
7. **行503**: AND qaru_client_name = :P7_QARU_CLIENT_NAME
8. **行505-510**: count > 0の場合にfalseを返し、それ以外はtrueを返す
9. **行518**: p_error_messageでエラーメッセージを設定
10. **行519**: p_when_button_pressed=>wwv_flow_imp.id(37067720447570637)でCREATEボタンに紐付け
11. **行520**: p_associated_item=>wwv_flow_imp.id(54279823323258492)でNameフィールドに関連付け
12. **行521**: p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'

### プログラム呼び出し階層図

```
ユーザー操作（Createボタン押下）
    │
    ├─ APEXフォームサブミット
    │      │
    │      └─ AFTER_SUBMIT処理
    │             │
    │             ├─ create_page_validation実行（シーケンス30）
    │             │      │
    │             │      └─ PL/SQL無名ブロック
    │             │             │
    │             │             ├─ SELECT count(1) FROM qa_rules
    │             │             │   WHERE qaru_name = :P7_QARU_NAME
    │             │             │   AND qaru_client_name = :P7_QARU_CLIENT_NAME
    │             │             │
    │             │             └─ count > 0 ? FALSE : TRUE
    │             │
    │             └─ バリデーション結果判定
    │                    │
    │                    ├─ TRUE: INSERT処理続行
    │                    │
    │                    └─ FALSE: エラーメッセージ表示
    │
    └─ 処理結果をユーザーに表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P7_QARU_NAME ──────────▶ SELECT count(1) ──────────▶ l_count
P7_QARU_CLIENT_NAME ───▶ FROM qa_rules
                              │
                              ▼
                         条件分岐
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              count > 0            count = 0
                    │                   │
                    ▼                   ▼
             FALSE返却             TRUE返却
                    │                   │
                    ▼                   ▼
            エラー表示           作成処理続行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | Add/Edit Ruleページでのバリデーション定義 |
