# 通知設計書 15-オプション未選択エラー通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるオプション未選択エラー通知の設計を記述したものである。この通知は、ユニットテスト生成時にオプションを選択せずにGenerateボタンを押下した際に表示されるバリデーションエラーメッセージである。

### 本通知の処理概要

オプション未選択エラー通知は、ユーザーがUnit Test Generationページでパッケージ生成オプションを選択せずにGenerateボタンを押下した際に、必須入力チェックを行いエラーメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOのユニットテスト生成機能では、生成するパッケージの形式を選択する必要がある。オプションには「Single Package per Scheme」と「Single Package per Scheme and Rule」の2種類があり、いずれかを選択しなければテスト生成処理を実行できない。ユーザーが誤ってオプション未選択のまま操作を進めることを防止する。

**通知の送信タイミング**：ユーザーがUnit Test Generationページ（page_00002）でGenerateボタンをクリックした際に、サーバーサイドでバリデーションが実行され、P2_OPTIONがNULLの場合にこの通知が表示される。

**通知の受信者**：Unit Test Generationページでオプションを選択せずにGenerateボタンを押下したユーザーが対象である。

**通知内容の概要**：「Please select the Option.」というエラーメッセージが表示され、ユーザーにオプションの選択を促す。

**期待されるアクション**：ユーザーは「Single Package per Scheme」または「Single Package per Scheme and Rule」のいずれかのオプションを選択してから再度Generateボタンを押下することが期待される。

## 通知種別

アプリ内通知（バリデーションエラー通知 - INLINE_WITH_FIELD_AND_NOTIFICATION）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（フォームサブミット時） |
| 優先度 | 高 |
| リトライ | なし（即座に表示） |

### 送信先決定ロジック

Generateボタンを押下したユーザーに対して直接表示される。

## 通知テンプレート

### エラーメッセージテンプレート

| 項目 | 内容 |
|-----|------|
| 表示位置 | INLINE_WITH_FIELD_AND_NOTIFICATION |
| 表示方式 | Optionフィールドおよび通知エリアの両方に表示 |
| 関連フィールド | P2_OPTION |

### 本文テンプレート

```
Please select the Option.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | page_00002.sql: p_error_message | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Generateボタン押下 | P2_OPTIONがNULL | オプションが選択されていない場合にエラー表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| オプションが選択されている | P2_OPTIONがNOT NULLの場合は生成処理が続行される |

## 処理フロー

### バリデーションフロー

```mermaid
flowchart TD
    A[Generateボタン押下] --> B[AFTER_SUBMIT処理開始]
    B --> C[Validate Option selected for Generate実行]
    C --> D{:P2_OPTION is not null}
    D -->|FALSE| E[エラーメッセージ表示]
    D -->|TRUE| F[生成処理続行]
    E --> G[処理中断]
    F --> H[QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemes実行]
    G --> I[ユーザーにエラー通知]
    H --> J[Unit Tests created.表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | フォームアイテムの値チェックのみ | DBアクセスなし |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | なし | バリデーションエラー時は更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バリデーションエラー | オプション未選択時 | エラーメッセージ表示、操作拒否 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- サーバーサイドでのNULLチェックにより、クライアントサイドでの改ざんを防止
- APEXのセッション管理により、認証済みユーザーのみが操作可能

## 備考

- 使用ページ: page_00002（Unit Test Generation）
- バリデーション名: Validate Option selected for Generate
- バリデーションシーケンス: 10
- 関連アイテム: P2_OPTION
- オプション選択肢: 1（Single Package per Scheme）, 2（Single Package per Scheme and Rule）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

オプションフィールドの定義とバリデーションに使用される値を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | P2_OPTIONフィールドの定義とLOV |

**読解のコツ**: create_page_itemプロシージャでP2_OPTIONが定義されている。p_lovパラメータにSTATIC2形式で選択肢が記述されている。

#### Step 2: エントリーポイントを理解する

バリデーションがどのように呼び出されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | Generateボタンとバリデーションの関連付け |

**主要処理フロー**:
1. **行178-192**: wwv_flow_imp_page.create_page_itemでP2_OPTIONフィールド定義
2. **行183**: p_item_default=>'1'でデフォルト値設定
3. **行186**: p_lovでオプション選択肢を定義（1: Single Package per Scheme, 2: Single Package per Scheme and Rule）
4. **行209-220**: wwv_flow_imp_page.create_page_validationでバリデーション定義
5. **行211**: p_validation_name=>'Validate Option selected for Generate'
6. **行213**: p_validation=>':P2_OPTION is not null'
7. **行216**: p_error_message=>'Please select the Option.'
8. **行217**: p_when_button_pressed=>wwv_flow_imp.id(21777713683803239)でGENERATEボタンに紐付け
9. **行218**: p_associated_item=>wwv_flow_imp.id(21698960154160717)でP2_OPTIONに関連付け
10. **行219**: p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'

### プログラム呼び出し階層図

```
ユーザー操作（Generateボタン押下）
    │
    ├─ APEXフォームサブミット
    │      │
    │      └─ AFTER_SUBMIT処理
    │             │
    │             ├─ create_page_validation実行
    │             │      │
    │             │      └─ PL/SQL式評価
    │             │             │
    │             │             └─ :P2_OPTION is not null
    │             │
    │             └─ バリデーション結果判定
    │                    │
    │                    ├─ TRUE: 生成処理続行
    │                    │      └─ QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemes
    │                    │
    │                    └─ FALSE: エラーメッセージ表示
    │
    └─ 処理結果をユーザーに表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P2_OPTION ─────────────▶ NOT NULL チェック ─────────▶ BOOLEAN
                              │
                              ▼
                         条件分岐
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              NULL             NOT NULL
                    │                   │
                    ▼                   ▼
            エラー表示           生成処理続行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | Unit Test Generationページでのバリデーション定義 |
