# 通知設計書 16-レポートダウンロード通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるレポートダウンロード通知の設計を記述したものである。この通知は、Interactive Report機能でダウンロード操作を行った際に表示される通知機能である。

### 本通知の処理概要

レポートダウンロード通知は、ユーザーがInteractive Reportからデータをダウンロードした際に、APEXの標準機能として提供される通知表示機能である。

**業務上の目的・背景**：QUASTOでは複数のInteractive Reportでデータを表示しており、ユーザーはこれらのデータをCSV、HTML、XLSX、PDF形式でダウンロードできる。ダウンロード操作時に視覚的なフィードバックを提供することで、ユーザーに操作が正常に開始されたことを通知し、ユーザビリティを向上させる。

**通知の送信タイミング**：ユーザーがInteractive Reportのダウンロードメニューからダウンロード形式を選択した際に、APEXの標準通知機能により表示される。

**通知の受信者**：ダウンロード操作を行ったユーザーが対象である。

**通知内容の概要**：APEXの標準通知としてダウンロード処理の状況がブラウザに通知される。

**期待されるアクション**：ユーザーはダウンロードが完了するまで待機し、ファイルを保存することが期待される。

## 通知種別

アプリ内通知（APEX Interactive Report標準機能 - show_notify='Y'）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（JavaScript通知） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

ダウンロード操作を行ったユーザーのブラウザに直接表示される。

## 通知テンプレート

### 通知設定

| 項目 | 内容 |
|-----|------|
| 通知有効化パラメータ | p_show_notify |
| 設定値 | 'Y' |
| ダウンロード形式 | CSV:HTML:XLSX:PDF |

### 本文テンプレート

APEXの標準通知テンプレートを使用（カスタマイズなし）

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| レポートデータ | CSV/HTML/XLSX/PDF | ユーザー選択 | ダウンロードファイル自体 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | APEX標準機能 | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ダウンロードメニュー選択 | show_notify='Y' | Interactive Reportのダウンロード機能実行時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| show_notify='N' | 通知を無効化した場合は表示されない |

## 処理フロー

### ダウンロード通知フロー

```mermaid
flowchart TD
    A[ユーザーがダウンロードメニュー選択] --> B[APEXがダウンロード処理開始]
    B --> C{show_notify設定}
    C -->|'Y'| D[通知表示]
    C -->|'N'| E[通知なし]
    D --> F[ダウンロード実行]
    E --> F
    F --> G[ファイル生成]
    G --> H[ブラウザにダウンロード]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| QA_TEST_RUN_DETAILS_P0004_V | Invalid Objectsレポートデータ | page_00004 |
| QA_RULES_P0006_V | Rulesレポートデータ | page_00006 |

### テーブル別参照項目詳細

#### QA_TEST_RUN_DETAILS_P0004_V（page_00004）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| QATO_ID | テストオブジェクトID | レポート表示 |
| QATR_SCHEME_NAME | スキーム名 | レポート表示 |
| QATO_OBJECT_NAME | オブジェクト名 | レポート表示 |
| QATO_OBJECT_DETAILS | オブジェクト詳細 | レポート表示 |
| QATO_QATR_ID | テスト実行ID | WHERE句 |

#### QA_RULES_P0006_V（page_00006）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| QARU_ID | ルールID | レポート表示 |
| QARU_RULE_NUMBER | ルール番号 | レポート表示 |
| QARU_CLIENT_NAME | クライアント名 | レポート表示 |
| QARU_NAME | ルール名 | レポート表示 |
| その他全カラム | レポートデータ | レポート表示 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | なし | ダウンロードは読み取り専用操作 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| データなし | レポートデータが0件 | 空のファイルをダウンロード |
| タイムアウト | 大量データ処理時 | APEXのタイムアウト設定に依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | ユーザー操作による再試行 |
| リトライ間隔 | なし |
| リトライ対象エラー | すべてのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座にダウンロード）

## セキュリティ考慮事項

- APEXのセッション管理により、認証済みユーザーのみがダウンロード可能
- ビューを介したデータアクセスにより、直接テーブルアクセスを防止
- ダウンロードファイルには表示権限のあるデータのみ含まれる

## 備考

- 使用ページ: page_00004（Invalid Objects）, page_00006（Rules）
- 機能パラメータ: p_show_notify=>'Y', p_download_formats=>'CSV:HTML:XLSX:PDF'
- APEX標準機能のため、カスタマイズは制限される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Interactive Reportワークシートの設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | Invalid Objects ReportのWorksheet設定 |
| 1-2 | page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | Rules ReportのWorksheet設定 |

**読解のコツ**: create_worksheetプロシージャでInteractive Reportの動作設定が定義されている。p_show_notifyとp_download_formatsパラメータに注目。

#### Step 2: エントリーポイントを理解する

ダウンロード機能がどのように設定されているかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | Worksheet作成部分 |
| 2-2 | page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | Worksheet作成部分 |

**主要処理フロー**:

page_00004.sql:
1. **行81-94**: wwv_flow_imp_page.create_worksheetでWorksheet定義
2. **行89**: p_show_notify=>'Y'で通知を有効化
3. **行90**: p_download_formats=>'CSV:HTML:XLSX:PDF'でダウンロード形式を定義
4. **行91**: p_enable_mail_download=>'Y'でメールダウンロードを有効化

page_00006.sql:
1. **行77-93**: wwv_flow_imp_page.create_worksheetでWorksheet定義
2. **行86**: p_show_notify=>'Y'で通知を有効化
3. **行87**: p_download_formats=>'CSV:HTML:XLSX:PDF'でダウンロード形式を定義
4. **行88**: p_enable_mail_download=>'Y'でメールダウンロードを有効化

### プログラム呼び出し階層図

```
ユーザー操作（ダウンロードメニュー選択）
    │
    ├─ APEX Interactive Report Engine
    │      │
    │      ├─ create_worksheet設定読み込み
    │      │      │
    │      │      ├─ p_show_notify => 'Y'
    │      │      │
    │      │      └─ p_download_formats => 'CSV:HTML:XLSX:PDF'
    │      │
    │      ├─ 通知表示（show_notify='Y'の場合）
    │      │
    │      └─ データ取得・ファイル生成
    │             │
    │             └─ ビュー参照（QA_TEST_RUN_DETAILS_P0004_V等）
    │
    └─ ブラウザダウンロード
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ダウンロード形式選択 ───▶ APEX IR Engine ─────────▶ 通知表示
                              │
                              ▼
                         データ取得
                              │
                              ▼
                         ファイル生成
                              │
                              ▼
                         ブラウザダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | ソース | Invalid Objects ReportのWorksheet設定 |
| page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | ソース | Rules ReportのWorksheet設定 |
