# 通知設計書 17-レポートメール送信機能

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるレポートメール送信機能の設計を記述したものである。この機能は、Interactive Reportのメールダウンロード機能を使用して、レポートデータをメールで送信する機能である。

### 本通知の処理概要

レポートメール送信機能は、ユーザーがInteractive Reportからデータをメールで送信できる機能である。APEXの標準機能として提供され、enable_mail_download='Y'設定により有効化される。

**業務上の目的・背景**：QUASTOでは複数のInteractive Reportでデータを表示しており、ユーザーはこれらのデータを他のチームメンバーや関係者と共有する必要がある。メール送信機能を提供することで、ダウンロードしてからメールに添付するという手間を省き、直接レポートデータを共有できるようにする。

**通知の送信タイミング**：ユーザーがInteractive Reportのメールメニューから送信操作を行った際に、指定されたメールアドレスにレポートデータが送信される。

**通知の受信者**：ユーザーが指定したメールアドレスの受信者が対象である。

**通知内容の概要**：選択した形式（CSV、HTML、XLSX、PDF）のレポートデータが添付ファイルまたは本文としてメールで送信される。

**期待されるアクション**：メール受信者はレポートデータを確認し、必要に応じてデータを活用することが期待される。

## 通知種別

メールダウンロード機能（APEX Interactive Report標準機能 - enable_mail_download='Y'）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（APEXメール送信機能） |
| 優先度 | 中 |
| リトライ | APEXメールキューに依存 |

### 送信先決定ロジック

ユーザーがダイアログで入力したメールアドレスに送信される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | APEXメール設定に依存 |
| 送信元名称 | APEXメール設定に依存 |
| 件名 | ユーザー入力またはAPEXデフォルト |
| 形式 | HTML/テキスト |

### 本文テンプレート

APEXの標準メールテンプレートを使用

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| レポートデータ | CSV/HTML/XLSX/PDF | ユーザー選択 | レポートデータファイル |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| TO_ADDRESS | 送信先メールアドレス | ユーザー入力 | Yes |
| SUBJECT | メール件名 | ユーザー入力 | No |
| CC | CCメールアドレス | ユーザー入力 | No |
| BCC | BCCメールアドレス | ユーザー入力 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | メール送信ダイアログの送信ボタン押下 | enable_mail_download='Y' | Interactive Reportのメール機能実行時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| enable_mail_download='N' | メール機能を無効化した場合は使用不可 |
| APEXメール設定なし | サーバーにメール設定がない場合は送信不可 |

## 処理フロー

### メール送信フロー

```mermaid
flowchart TD
    A[ユーザーがメールメニュー選択] --> B[メール送信ダイアログ表示]
    B --> C[ユーザーが送信先等を入力]
    C --> D[送信ボタン押下]
    D --> E{enable_mail_download設定}
    E -->|'Y'| F[レポートデータ生成]
    E -->|'N'| G[機能無効]
    F --> H[APEXメールキューに登録]
    H --> I[メール送信]
    I --> J[送信完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| QA_TEST_RUN_DETAILS_P0004_V | Invalid Objectsレポートデータ | page_00004 |
| QA_TEST_RESULT_FILES_P0005_V | Test Resultsレポートデータ | page_00005 |
| QA_RULES_P0006_V | Rulesレポートデータ | page_00006 |
| QA_CLIENT_NAMES_P0008_V | Client Namesレポートデータ | page_00008 |

### テーブル別参照項目詳細

#### 各ページのビュー

レポート表示に使用される全カラムがメール添付ファイルに含まれる。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| APEXメールキューテーブル | INSERT | APEXがメール送信用にキューに登録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メールアドレス不正 | 形式エラー | エラーメッセージ表示 |
| メールサーバー接続失敗 | ネットワークエラー | APEXエラーログに記録 |
| 添付ファイルサイズ超過 | 大量データ | サイズ制限に関するエラー表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | APEXメールキュー設定に依存 |
| リトライ間隔 | APEXメールキュー設定に依存 |
| リトライ対象エラー | 一時的な送信エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | APEXメールキュー設定に依存 |
| 1日あたり上限 | APEXメールキュー設定に依存 |

### 配信時間帯

制限なし（APEXメールキューの処理に依存）

## セキュリティ考慮事項

- APEXのセッション管理により、認証済みユーザーのみがメール送信可能
- ビューを介したデータアクセスにより、直接テーブルアクセスを防止
- メール添付ファイルには表示権限のあるデータのみ含まれる
- メールアドレスの検証はAPEX標準機能で実施

## 備考

- 使用ページ: page_00004（Invalid Objects）, page_00005（Test Result Files）, page_00006（Rules）, page_00008（Rule Files）
- 機能パラメータ: p_enable_mail_download=>'Y'
- APEXインスタンスにメールサーバー設定が必要
- メール送信はAPEXジョブとして非同期で処理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Interactive Reportワークシートのメール設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | Invalid Objects ReportのWorksheet設定 |
| 1-2 | page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | Test Results ReportのWorksheet設定 |
| 1-3 | page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | Rules ReportのWorksheet設定 |
| 1-4 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | Rule Files ReportのWorksheet設定 |

**読解のコツ**: create_worksheetプロシージャでInteractive Reportの動作設定が定義されている。p_enable_mail_downloadパラメータに注目。

#### Step 2: エントリーポイントを理解する

メール機能がどのように設定されているかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | Worksheet作成部分 |
| 2-2 | page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | Worksheet作成部分 |
| 2-3 | page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | Worksheet作成部分 |
| 2-4 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | Worksheet作成部分 |

**主要処理フロー**:

page_00004.sql:
1. **行81-94**: wwv_flow_imp_page.create_worksheetでWorksheet定義
2. **行91**: p_enable_mail_download=>'Y'でメール機能を有効化

page_00005.sql:
1. **行80-94**: wwv_flow_imp_page.create_worksheetでWorksheet定義
2. **行91**: p_enable_mail_download=>'Y'でメール機能を有効化

page_00006.sql:
1. **行77-93**: wwv_flow_imp_page.create_worksheetでWorksheet定義
2. **行88**: p_enable_mail_download=>'Y'でメール機能を有効化

page_00008.sql:
1. **行80-92**: wwv_flow_imp_page.create_worksheetでWorksheet定義
2. **行89**: p_enable_mail_download=>'Y'でメール機能を有効化

### プログラム呼び出し階層図

```
ユーザー操作（メールメニュー選択）
    │
    ├─ APEX Interactive Report Engine
    │      │
    │      ├─ create_worksheet設定読み込み
    │      │      │
    │      │      └─ p_enable_mail_download => 'Y'
    │      │
    │      ├─ メール送信ダイアログ表示
    │      │
    │      └─ 送信ボタン押下
    │             │
    │             ├─ データ取得・ファイル生成
    │             │      │
    │             │      └─ ビュー参照（各ページのビュー）
    │             │
    │             └─ APEXメールキューに登録
    │
    └─ APEXメールジョブによる送信
```

### データフロー図

```
[入力]                    [処理]                         [出力]

メールアドレス入力 ───▶ APEX IR Engine ─────────▶ メール送信ダイアログ
件名入力 ─────────────▶
                              │
                              ▼
                         データ取得
                              │
                              ▼
                         ファイル生成
                              │
                              ▼
                         メールキュー登録
                              │
                              ▼
                         メール送信 ─────────▶ 受信者メールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | ソース | Invalid Objects ReportのWorksheet設定 |
| page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | ソース | Test Results ReportのWorksheet設定 |
| page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | ソース | Rules ReportのWorksheet設定 |
| page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | ソース | Rule Files ReportのWorksheet設定 |
