# 通知設計書 2-ユニットテスト作成成功通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるユニットテスト作成完了時に表示されるアプリ内通知「ユニットテスト作成成功通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがUnit Test Generation画面（ページ2）でGENERATEボタンをクリックし、ユニットテストパッケージの作成が正常に完了した際に「Unit Tests created.」というメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOルールに基づいたutPLSQL互換のユニットテストパッケージを自動生成する際、ユーザーに生成処理の成功を明確に伝える必要がある。この通知により、ユーザーはテストパッケージの生成が正常に完了したことを即座に認識でき、テスト実行などの後続作業に移行できる。品質保証プロセスにおいて、テスト準備完了の確認は重要なマイルストーンである。

**通知の送信タイミング**：ユーザーがGENERATEボタンをクリックし、サーバー側でPL/SQLプロセス「Create Unit Tests」が正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：ユニットテスト生成操作を実行した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「Unit Tests created.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーは生成の成功を確認し、Generated Unit Test Packagesセクションで生成されたパッケージを確認するか、ダイアログを閉じてスケジューラジョブ等でテストを実行する。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
Unit Tests created.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | GENERATEボタンのクリック | Create Unit Testsプロセスが正常完了 | page_00002のプロセス「Create Unit Tests」の成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロセス失敗時 | エラーが発生した場合は成功メッセージは表示されず、エラーメッセージが表示される |
| バリデーションエラー時 | P2_OPTIONが未選択の場合は「Please select the Option.」エラーが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GENERATEボタンクリック] --> B[フォームバリデーション]
    B -->|P2_OPTION選択済| C[Create Unit Testsプロセス実行]
    B -->|P2_OPTION未選択| D[バリデーションエラー表示]
    C --> E[QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemes呼び出し]
    E --> F{処理結果}
    F -->|成功| G[成功メッセージ表示]
    F -->|失敗| H[エラーメッセージ表示]
    G --> I[終了]
    H --> J[エラー処理]
    D --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| QA_RULES | アクティブなルール一覧の取得 | qaru_is_active = 1の条件 |
| QA_SCHEME_NAMES_FOR_TESTING_V | テスト対象スキーマ一覧 | ビュー |
| USER_OBJECTS | 既存パッケージの確認・削除 | PACKAGE型 |

### テーブル別参照項目詳細

#### QA_RULES

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| qaru_id | ルール識別 | qaru_is_active = 1 |
| qaru_rule_number | ルール番号 | 同上 |
| qaru_client_name | クライアント名 | 同上 |
| qaru_name | ルール名 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| USER_OBJECTS（間接的） | DROP/CREATE | ユニットテストパッケージの削除・作成 |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| オプション未選択 | P2_OPTIONがnull | 「Please select the Option.」バリデーションエラー |
| ルール未定義 | QA_RULESにルールがない | raise_application_errorでエラー表示 |
| 不正スキーマ名 | 指定スキーマが存在しない | raise_application_errorでエラー表示 |
| パッケージコンパイルエラー | DDL実行失敗 | 例外処理でエラー表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- ユニットテストパッケージはデータベースオブジェクトとして作成される
- EXECUTE IMMEDIATE使用によるDDL実行
- 保護レベル: C（チェックサム保護）

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- 生成オプションは2種類：Single Package per Scheme（1）、Single Package per Scheme and Rule（2）
- 既存パッケージは削除してから再作成される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、入力パラメータとルール定義の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_unit_tests_for_schemesプロシージャのパラメータ定義（1488-1521行） |
| 1-2 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | P2_OPTIONとP2_SCHEME_NAMESのアイテム定義（178-208行） |

**読解のコツ**: LOV定義「Single Package per Scheme;1,Single Package per Scheme and Rule;2」でオプション値の意味を把握する。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **260-274行**: Create Unit Testsプロセスの定義。process_success_messageに「Unit Tests created.」が設定されている
2. **266-268行**: QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemes呼び出し
3. **209-220行**: バリデーション「Validate Option selected for Generate」定義

#### Step 3: PL/SQL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_unit_tests_for_schemesの実装（1488-1521行） |
| 3-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_unit_test_packagesの実装（657-823行） |
| 3-3 | p00002.sql | `src/apex/f141/embedded_code/pages/p00002.sql` | 埋め込みPL/SQLコード |

**主要処理フロー**:
- **1504-1506行**: スキーマ名がnullの場合は全スキーマ対象
- **1507-1511行**: スキーマ名がある場合はパース処理
- **673-678行**: バリデーションとルール検証
- **686-809行**: パッケージ生成ロジック（オプション別処理）

### プログラム呼び出し階層図

```
page_00002.sql (Create Unit Testsプロセス)
    │
    └─ QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemes
           │
           ├─ qa_utils_pkg.f_get_string_as_table（スキーマ名パース）
           │
           └─ p_create_unit_test_packages
                  │
                  ├─ p_validate_input（入力検証）
                  │
                  ├─ p_verify_rules（ルール検証）
                  │
                  ├─ p_delete_unit_test_packages（既存削除）
                  │
                  ├─ f_get_all_scheme_names（スキーマ名取得）
                  │
                  ├─ f_get_package_spec_header/content/footer（仕様部生成）
                  │
                  ├─ f_get_package_body_header/content/footer（本体部生成）
                  │
                  └─ EXECUTE IMMEDIATE（DDL実行）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P2_OPTION ──────────▶ p_create_unit_tests_for_schemes
P2_SCHEME_NAMES ────▶         │
                              │
                              ▼
                    スキーマ名リスト変換
                              │
                              ▼
                    p_create_unit_test_packages
                              │
                              ▼
                    QA_RULES (SELECT) ───▶ ルール情報取得
                              │
                              ▼
                    パッケージDDL生成
                              │
                              ▼
                    EXECUTE IMMEDIATE ───▶ UT_*_PKGパッケージ作成
                              │
                              ▼
                    「Unit Tests created.」表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | ページ定義とプロセス設定 |
| p00002.sql | `src/apex/f141/embedded_code/pages/p00002.sql` | ソース | 埋め込みPL/SQLコード |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | ユニットテストパッケージ生成処理 |
