# 通知設計書 3-ユニットテスト削除成功通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるユニットテスト削除完了時に表示されるアプリ内通知「ユニットテスト削除成功通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがUnit Test Generation画面（ページ2）でDelete Unit Testsボタンをクリックし、ユニットテストパッケージの削除が正常に完了した際に「Unit Tests deleted.」というメッセージを表示する機能である。

**業務上の目的・背景**：生成済みのユニットテストパッケージを削除する際、ユーザーに削除処理の成功を明確に伝える必要がある。この通知により、ユーザーはテストパッケージの削除が正常に完了したことを即座に認識でき、新しいテストの再生成など後続作業に移行できる。テスト環境のクリーンアップや再構築において、削除完了の確認は重要である。

**通知の送信タイミング**：ユーザーがDelete Unit Testsボタンをクリックし、サーバー側でPL/SQLプロセス「Delete Unit Tests」が正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：ユニットテスト削除操作を実行した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「Unit Tests deleted.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーは削除の成功を確認し、必要に応じて新しいユニットテストを再生成するか、ダイアログを閉じて他の操作に移行する。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
Unit Tests deleted.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Delete Unit Testsボタンのクリック | Delete Unit Testsプロセスが正常完了 | page_00002のプロセス「Delete Unit Tests」の成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロセス失敗時 | エラーが発生した場合は成功メッセージは表示されず、エラーメッセージが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Delete Unit Testsボタンクリック] --> B[Delete Unit Testsプロセス実行]
    B --> C[QA_UNIT_TESTS_PKG.p_delete_unit_tests_for_schemes呼び出し]
    C --> D{処理結果}
    D -->|成功| E[成功メッセージ表示]
    D -->|失敗| F[エラーメッセージ表示]
    E --> G[終了]
    F --> H[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| USER_OBJECTS | 削除対象パッケージの特定 | PACKAGE型、プレフィックスで検索 |

### テーブル別参照項目詳細

#### USER_OBJECTS

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| object_name | 削除対象パッケージ名 | object_type = 'PACKAGE' AND object_name LIKE 'UT_%' |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| USER_OBJECTS（間接的） | DROP | ユニットテストパッケージの削除 |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パッケージ削除エラー | DDL実行失敗時 | 例外処理でエラー表示 |
| 対象パッケージなし | 削除対象が存在しない | 正常終了（エラーなし） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- DROP PACKAGE文の実行権限が必要
- EXECUTE IMMEDIATE使用によるDDL実行
- 保護レベル: C（チェックサム保護）

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- スキーマ名が指定されない場合はすべてのユニットテストパッケージが削除される
- 削除対象はプレフィックス「UT_」で始まるパッケージ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、削除対象となるパッケージの命名規則を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_delete_unit_tests_for_schemesプロシージャのパラメータ定義（1523-1552行） |

**読解のコツ**: パッケージ名のプレフィックス（gc_utplsql_ut_test_packages_prefix）の値と検索パターンを確認する。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **275-287行**: Delete Unit Testsプロセスの定義。process_success_messageに「Unit Tests deleted.」が設定されている
2. **281行**: QA_UNIT_TESTS_PKG.p_delete_unit_tests_for_schemes呼び出し
3. **152-164行**: DELETEボタンの定義（Dangerスタイル）

#### Step 3: PL/SQL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_delete_unit_tests_for_schemesの実装（1523-1552行） |
| 3-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_delete_unit_test_packagesの実装（825-871行） |
| 3-3 | p00002.sql | `src/apex/f141/embedded_code/pages/p00002.sql` | 埋め込みPL/SQLコード |

**主要処理フロー**:
- **1536-1538行**: スキーマ名がnullの場合は全パッケージ削除
- **1539-1543行**: スキーマ名がある場合はパース処理
- **834-847行**: スキーマ名指定ありの場合の削除ロジック
- **848-857行**: スキーマ名指定なしの場合の削除ロジック

### プログラム呼び出し階層図

```
page_00002.sql (Delete Unit Testsプロセス)
    │
    └─ QA_UNIT_TESTS_PKG.p_delete_unit_tests_for_schemes
           │
           ├─ qa_utils_pkg.f_get_string_as_table（スキーマ名パース）
           │
           └─ p_delete_unit_test_packages
                  │
                  ├─ USER_OBJECTS (SELECT) ─── パッケージ検索
                  │
                  └─ EXECUTE IMMEDIATE 'DROP PACKAGE ...'
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P2_SCHEME_NAMES ────▶ p_delete_unit_tests_for_schemes
                              │
                              ▼
                    スキーマ名リスト変換（または全削除）
                              │
                              ▼
                    p_delete_unit_test_packages
                              │
                              ▼
                    USER_OBJECTS (SELECT) ───▶ 対象パッケージ特定
                              │
                              ▼
                    EXECUTE IMMEDIATE 'DROP PACKAGE' ───▶ パッケージ削除
                              │
                              ▼
                    「Unit Tests deleted.」表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | ページ定義とプロセス設定 |
| p00002.sql | `src/apex/f141/embedded_code/pages/p00002.sql` | ソース | 埋め込みPL/SQLコード |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | ユニットテストパッケージ削除処理 |
