# 通知設計書 4-ルール保存成功通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるルールの作成・更新・削除完了時に表示されるアプリ内通知「ルール保存成功通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがAdd/Edit Rule画面（ページ7）でルールの作成、更新、または削除操作を行い、処理が正常に完了した際に「Changes saved.」というメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOルールはコード品質チェックの基盤となる重要な設定である。ルールの追加・変更・削除は慎重に行う必要があり、ユーザーに操作の成功を明確に伝える必要がある。この通知により、ユーザーはルール定義の変更が正常にデータベースに反映されたことを即座に認識でき、次のアクション（例：ユニットテストの再生成）に移行できる。

**通知の送信タイミング**：ユーザーがSAVE、CREATE、またはDELETEボタンをクリックし、サーバー側でNATIVE_FORM_DMLプロセスが正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：ルール操作を実行した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「Changes saved.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーは保存の成功を確認し、ダイアログを閉じてルール一覧画面に戻るか、ユニットテストの再生成などの後続操作に移行する。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
Changes saved.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | SAVEボタンのクリック | Save Form Processが正常完了（UPDATE） | 既存ルールの更新時 |
| 画面操作 | CREATEボタンのクリック | Save Form Processが正常完了（INSERT） | 新規ルールの作成時 |
| 画面操作 | DELETEボタンのクリック | Save Form Processが正常完了（DELETE） | ルールの削除時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロセス失敗時 | エラーが発生した場合は成功メッセージは表示されず、エラーメッセージが表示される |
| バリデーションエラー時 | 必須項目未入力、重複チェック等のエラー時は通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SAVE/CREATE/DELETEボタンクリック] --> B[フォームバリデーション]
    B -->|バリデーションOK| C[Save Form Process実行]
    B -->|バリデーションNG| D[バリデーションエラー表示]
    C --> E[NATIVE_FORM_DML処理]
    E --> F{処理結果}
    F -->|成功| G[成功メッセージ表示]
    F -->|失敗| H[エラーメッセージ表示]
    G --> I[Close Dialogプロセス実行]
    H --> J[エラー処理]
    D --> J
    I --> K[ダイアログクローズ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| QA_RULES_P0007_V | フォームデータソース | ビュー |
| QA_RULES | ルール重複チェック | バリデーション用 |
| QA_TEST_RUNS | テスト結果存在チェック | 削除バリデーション用 |

### テーブル別参照項目詳細

#### QA_RULES（バリデーション用）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| qaru_rule_number | ルール番号重複チェック | qaru_client_name = :P7_QARU_CLIENT_NAME |
| qaru_name | ルール名重複チェック | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| QA_RULES | INSERT/UPDATE/DELETE | ルールの作成・更新・削除 |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ルール番号重複 | 同一クライアント内で既存ルール番号と重複 | 「Rulenumber already exists for this client.」表示 |
| ルール名重複 | 同一クライアント内で既存ルール名と重複 | 「Rulename already exists for this client.」表示 |
| 削除不可 | テスト結果が存在するルールの削除試行 | 「The Rule has saved test results...」表示 |
| 必須項目未入力 | 必須フィールドが空 | フィールドバリデーションエラー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- フォームはAPEXのNATIVE_FORM_DML機能で処理される
- 主キー（P7_QARU_ID）は隠しフィールドで保護レベルS
- 保護レベル: C（チェックサム保護）
- 削除時は確認ダイアログあり（confirm_message）

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- 成功後は自動的にダイアログが閉じる
- SAVE/CREATE/DELETEの3操作すべてで同一メッセージ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ルールデータの構造とフォーム項目を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | フォームアイテム定義（P7_QARU_*）を確認 |

**読解のコツ**: is_required=>trueの項目が必須フィールド。source_data_typeでデータ型を確認する。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **542-556行**: Save Form Processの定義。process_success_messageに「Changes saved.」が設定されている
2. **118-134行**: SAVEボタン定義（UPDATE操作）
3. **135-151行**: CREATEボタン定義（INSERT操作）
4. **101-117行**: DELETEボタン定義（DELETE操作）

#### Step 3: バリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | バリデーション定義（446-522行） |
| 3-2 | p00007.sql | `src/apex/f141/embedded_code/pages/p00007.sql` | 埋め込みPL/SQLコード |

**主要処理フロー**:
- **446-458行**: 削除可否チェック（qa_unit_tests_pkg.f_has_rule_test_results）
- **459-490行**: ルール番号重複チェック
- **491-522行**: ルール名重複チェック

### プログラム呼び出し階層図

```
page_00007.sql
    │
    ├─ バリデーション
    │      ├─ Validate if rule can be deleted
    │      │      └─ qa_unit_tests_pkg.f_has_rule_test_results
    │      │
    │      ├─ Validate if Rule already exists
    │      │      └─ QA_RULES (SELECT)
    │      │
    │      └─ Validate if Name already exists
    │             └─ QA_RULES (SELECT)
    │
    └─ Save Form Process (NATIVE_FORM_DML)
           │
           └─ QA_RULES (INSERT/UPDATE/DELETE)
                  │
                  └─ 「Changes saved.」表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P7_QARU_ID ─────────▶ NATIVE_FORM_DML
P7_QARU_RULE_NUMBER ▶       │
P7_QARU_CLIENT_NAME ▶       │
P7_QARU_NAME ───────▶       │
P7_QARU_CATEGORY ───▶       │
P7_QARU_ERROR_MESSAGE▶      │
P7_QARU_ERROR_LEVEL ▶       │
P7_QARU_IS_ACTIVE ──▶       │
P7_QARU_LAYER ──────▶       │
P7_QARU_SQL ────────▶       │
P7_QARU_OBJECT_TYPES▶       │
P7_QARU_EXCLUDE_OBJECTS▶    │
P7_QARU_COMMENT ────▶       │
                              │
                              ▼
                    バリデーション実行
                              │
                              ▼
                    QA_RULES (INSERT/UPDATE/DELETE)
                              │
                              ▼
                    「Changes saved.」表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | ページ定義とプロセス設定 |
| p00007.sql | `src/apex/f141/embedded_code/pages/p00007.sql` | ソース | 埋め込みバリデーションコード |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_has_rule_test_results関数 |
