# 通知設計書 5-ファイルインポート成功通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるJSONファイルインポート完了時に表示されるアプリ内通知「ファイルインポート成功通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがRule Files画面（ページ8）でJSONファイルをインポートし、ルールデータがデータベースに正常に取り込まれた際に「File imported.」というメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOルールはJSONファイル形式でエクスポート・インポートが可能であり、異なる環境間でのルール移行や、バックアップからの復元に使用される。インポート処理は複数のルールを一括で取り込む重要な操作であり、ユーザーに処理の成功を明確に伝える必要がある。この通知により、ユーザーはルールのインポートが正常に完了したことを即座に認識でき、インポートされたルールの確認などの後続作業に移行できる。

**通知の送信タイミング**：ユーザーがIMPORTボタンをクリックし、サーバー側でPL/SQLプロセス「Import file」が正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：ファイルインポート操作を実行した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「File imported.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーはインポートの成功を確認し、Rules画面でインポートされたルールを確認するか、ユニットテストの再生成などの後続操作に移行する。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
File imported.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | IMPORTボタンのクリック | Import fileプロセスが正常完了 | page_00008のプロセス「Import file」の成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロセス失敗時 | エラーが発生した場合は成功メッセージは表示されず、エラーメッセージが表示される |
| バリデーションエラー時 | 必須項目（P8_JSON_FILE）が未入力の場合は通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[IMPORTボタンクリック] --> B[フォームバリデーション]
    B -->|バリデーションOK| C[Import fileプロセス実行]
    B -->|バリデーションNG| D[エラー表示]
    C --> E[qa_apex_app_pkg.p_upload_rules_json呼び出し]
    E --> F{処理結果}
    F -->|成功| G[成功メッセージ表示]
    F -->|失敗| H[エラーメッセージ表示]
    G --> I[終了]
    H --> J[エラー処理]
    D --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| APEX_APPLICATION_TEMP_FILES | アップロードされたファイルの一時保存先 | APEXセッション管理 |

### テーブル別参照項目詳細

#### APEX_APPLICATION_TEMP_FILES

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| blob_content | アップロードファイルの内容 | name = :P8_JSON_FILE |
| mime_type | ファイルのMIMEタイプ | 同上 |
| filename | 元のファイル名 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| QA_IMPORT_FILES | INSERT | インポートファイル情報の保存 |
| QA_RULES | INSERT/UPDATE | ルールデータのインポート |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| MIMEタイプ不正 | application/json以外のファイル | raise_application_errorでエラー表示 |
| ファイル未選択 | P8_JSON_FILEが空 | バリデーションエラー表示 |
| JSONパースエラー | 不正なJSON形式 | 例外処理でエラー表示 |
| データベースエラー | INSERT/UPDATE失敗時 | 例外処理でエラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- アップロードファイルはセッション単位で管理され、他ユーザーからアクセス不可
- ファイルの拡張子制限（.json）あり
- MIMEタイプチェック（application/json）あり
- 保護レベル: C（チェックサム保護）

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- インポートはqa_export_import_rules_pkgパッケージを経由して実行される
- 同一クライアント・ルール番号のルールは上書きされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インポートされるJSONファイルとその処理結果の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_jsonプロシージャのパラメータと処理内容を確認 |

**読解のコツ**: PL/SQLパッケージの仕様部（1-55行）で公開インターフェースを確認し、本体部（117-161行）で実装詳細を把握する。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **223-235行**: Import fileプロセスの定義。process_success_messageに「File imported.」が設定されている
2. **229行**: qa_apex_app_pkg.p_upload_rules_json呼び出し
3. **231行**: error_display_locationがINLINE_IN_NOTIFICATIONに設定

#### Step 3: PL/SQL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_jsonの実装（117-161行） |
| 3-2 | p00008.sql | `src/apex/f141/embedded_code/pages/p00008.sql` | 埋め込みPL/SQLコード |

**主要処理フロー**:
- **134-141行**: APEX_APPLICATION_TEMP_FILESからファイル内容取得
- **143-146行**: MIMEタイプ検証
- **148-150行**: qa_export_import_rules_pkg.f_import_clob_to_qa_import_files呼び出し
- **152行**: qa_export_import_rules_pkg.p_import_clob_to_rules_table呼び出し

### プログラム呼び出し階層図

```
page_00008.sql (Import fileプロセス)
    │
    └─ qa_apex_app_pkg.p_upload_rules_json
           │
           ├─ APEX_APPLICATION_TEMP_FILES (SELECT)
           │
           ├─ qa_export_import_rules_pkg.f_import_clob_to_qa_import_files
           │      │
           │      └─ QA_IMPORT_FILES (INSERT)
           │
           └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table
                  │
                  └─ QA_RULES (INSERT/UPDATE)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P8_JSON_FILE ────────▶ APEX_APPLICATION_TEMP_FILES ────▶ qa_apex_app_pkg
(ファイル参照名)         (一時ファイル保存)                  │
                                                          │
                                                          ▼
                                                    MIMEタイプ検証
                                                          │
                                                          ▼
                                    f_import_clob_to_qa_import_files
                                                          │
                                                          ▼
                                              QA_IMPORT_FILES (INSERT)
                                                          │
                                                          ▼
                                    p_import_clob_to_rules_table
                                                          │
                                                          ▼
                                              QA_RULES (INSERT/UPDATE)
                                                          │
                                                          ▼
                                              「File imported.」表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | ソース | ページ定義とプロセス設定 |
| p00008.sql | `src/apex/f141/embedded_code/pages/p00008.sql` | ソース | 埋め込みPL/SQLコード |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | ファイルアップロード処理 |
