# 通知設計書 6-スケジューラ設定保存成功通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるスケジューラジョブ設定保存時に表示されるアプリ内通知「スケジューラ設定保存成功通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがConfig Scheduler Job画面（ページ9）でスケジューラジョブの有効/無効設定を保存し、処理が正常に完了した際に「Saved.」というメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOのユニットテストは、定期的なスケジューラジョブ（Cronjob）として自動実行される。このスケジューラの有効/無効切り替えは、テスト実行の自動化を制御する重要な設定である。ユーザーに設定変更の成功を明確に伝えることで、意図した通りにスケジューラが設定されたことを確認できる。

**通知の送信タイミング**：ユーザーがSAVEボタンをクリックし、サーバー側でPL/SQLプロセス「Save Scheduler Job Status」が正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：スケジューラ設定を変更した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「Saved.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーは設定保存の成功を確認し、Overview セクションでジョブの状態を確認するか、ダイアログを閉じて他の操作に移行する。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
Saved.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | SAVEボタンのクリック | Save Scheduler Job Statusプロセスが正常完了 | page_00009のプロセス「Save Scheduler Job Status」の成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロセス失敗時 | エラーが発生した場合は成功メッセージは表示されず、エラーメッセージが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SAVEボタンクリック] --> B[Save Scheduler Job Statusプロセス実行]
    B --> C[qa_unit_tests_pkg.p_enable_scheduler_cronjob呼び出し]
    C --> D{処理結果}
    D -->|成功| E[成功メッセージ表示]
    D -->|失敗| F[エラーメッセージ表示]
    E --> G[終了]
    F --> H[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| USER_SCHEDULER_JOBS | ジョブの有効/無効状態確認 | 初期値取得用 |

### テーブル別参照項目詳細

#### USER_SCHEDULER_JOBS

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| enabled | ジョブの有効状態 | job_name = gc_utplsql_scheduler_cronjob_name |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| USER_SCHEDULER_JOBS（間接的） | UPDATE | dbms_scheduler.enable/disableによる状態変更 |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不正ステータス | Y/N以外の値 | raise_application_errorでエラー表示 |
| スケジューラエラー | dbms_scheduler処理失敗 | 例外処理でエラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- dbms_schedulerのenable/disable権限が必要
- 保護レベル: C（チェックサム保護）

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- P9_ENABLE_SCHEDULER_JOBの値はY（有効）/N（無効）
- スケジューラジョブ名は定数gc_utplsql_scheduler_cronjob_nameで管理

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スケジューラジョブの状態管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_enable_scheduler_cronjobとf_is_scheduler_cronjob_enabledの定義を確認 |

**読解のコツ**: 定数gc_utplsql_scheduler_cronjob_nameがジョブ名を定義している。Y/Nの2値でジョブの有効/無効を制御する。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **409-421行**: Save Scheduler Job Statusプロセスの定義。process_success_messageに「Saved.」が設定されている
2. **415行**: qa_unit_tests_pkg.p_enable_scheduler_cronjob呼び出し
3. **353-370行**: P9_ENABLE_SCHEDULER_JOBアイテム定義（Yes/Noスイッチ）

#### Step 3: PL/SQL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_enable_scheduler_cronjobの実装（1335-1364行） |
| 3-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_is_scheduler_cronjob_enabledの実装（1304-1333行） |
| 3-3 | p00009.sql | `src/apex/f141/embedded_code/pages/p00009.sql` | 埋め込みPL/SQLコード |

**主要処理フロー**:
- **1345-1349行**: ステータス値のバリデーション（Y/Nのみ許可）
- **1351-1356行**: dbms_scheduler.enable/disableの呼び出し

### プログラム呼び出し階層図

```
page_00009.sql (Save Scheduler Job Statusプロセス)
    │
    └─ qa_unit_tests_pkg.p_enable_scheduler_cronjob
           │
           ├─ バリデーション（Y/Nチェック）
           │
           └─ dbms_scheduler.enable/disable
                  │
                  └─ USER_SCHEDULER_JOBS（状態更新）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P9_ENABLE_SCHEDULER_JOB ──▶ p_enable_scheduler_cronjob
(Y/N)                              │
                                   │
                                   ▼
                         ステータスバリデーション
                                   │
                                   ▼
                    ┌──────────────┴──────────────┐
                    │                             │
                    ▼                             ▼
              pi_status='Y'                pi_status='N'
                    │                             │
                    ▼                             ▼
           dbms_scheduler.enable      dbms_scheduler.disable
                    │                             │
                    └──────────────┬──────────────┘
                                   │
                                   ▼
                         「Saved.」表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | ソース | ページ定義とプロセス設定 |
| p00009.sql | `src/apex/f141/embedded_code/pages/p00009.sql` | ソース | 埋め込みPL/SQLコード |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | スケジューラ有効化/無効化処理 |
