# 通知設計書 7-スケジューラジョブ開始通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおけるスケジューラジョブ（Cronjob）の手動トリガー時に表示されるアプリ内通知「スケジューラジョブ開始通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがConfig Scheduler Job画面（ページ9）でRUN CRONJOBボタンをクリックし、スケジューラジョブが正常に開始された際に「Cronjob started.」というメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOのユニットテストは、通常dbms_schedulerによる定期実行（Cronjob）として自動的に実行される。しかし、スケジュール外でもユーザーが手動でジョブを実行したい場合がある（例：ルール変更直後の即時テスト実行、スケジュール間隔が長い場合の即時確認など）。この通知により、ユーザーは手動トリガーによるジョブが正常に開始されたことを即座に認識できる。

**通知の送信タイミング**：ユーザーがRUN CRONJOBボタンをクリックし、サーバー側でPL/SQLプロセス「Trigger Scheduler Cronjob」が正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：ジョブをトリガーした当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「Cronjob started.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーはジョブの開始を確認し、Test Results画面でテスト結果が更新されるのを待つか、ダイアログを閉じて他の操作に移行する。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
Cronjob started.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | RUN CRONJOBボタンのクリック | Trigger Scheduler Cronjobプロセスが正常完了 | page_00009のプロセス「Trigger Scheduler Cronjob」の成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ジョブ実行中 | 既にジョブが実行中の場合はエラーメッセージが表示される |
| プロセス失敗時 | その他エラーが発生した場合は成功メッセージは表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[RUN CRONJOBボタンクリック] --> B[Trigger Scheduler Cronjobプロセス実行]
    B --> C[qa_unit_tests_pkg.p_trigger_scheduler_cronjob呼び出し]
    C --> D{ジョブ実行中チェック}
    D -->|実行中でない| E[dbms_scheduler.run_job実行]
    D -->|実行中| F[エラーメッセージ表示]
    E --> G{処理結果}
    G -->|成功| H[成功メッセージ表示]
    G -->|失敗| I[エラーメッセージ表示]
    H --> J[終了]
    F --> K[エラー処理]
    I --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| USER_SCHEDULER_JOBS | ジョブの実行状態確認 | f_is_job_running関数で参照 |
| USER_SCHEDULER_RUNNING_JOBS | 実行中ジョブの確認 | f_is_job_running関数で参照 |

### テーブル別参照項目詳細

#### USER_SCHEDULER_JOBS

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| job_name | ジョブ名 | job_name = gc_utplsql_scheduler_cronjob_name |
| state | ジョブ状態 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| USER_SCHEDULER_JOBS（間接的） | RUN_JOB | dbms_scheduler.run_jobによるジョブ実行 |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ジョブ実行中 | 既にCronjobが実行中 | raise_application_errorでエラー表示「Scheduler Cronjob is currently running: {job_name}」 |
| スケジューラエラー | dbms_scheduler.run_job失敗時 | 例外処理でエラーログ記録（qa_logger_pkg） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ただし実行中は再実行不可） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- dbms_scheduler.run_job権限が必要
- 保護レベル: C（チェックサム保護）
- モーダルダイアログ内で操作が完結

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- ジョブはuse_current_session => falseで非同期実行される
- スケジューラジョブ名は定数qa_constant_pkg.gc_utplsql_scheduler_cronjob_nameで管理
- 同じジョブが既に実行中の場合はエラーとなる（二重実行防止）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スケジューラジョブの状態管理と実行制御を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_trigger_scheduler_cronjobとf_is_job_runningの定義を確認 |
| 1-2 | qa_constant_pkg.sql | `src/plsql/pkg/qa_constant_pkg.sql` | gc_utplsql_scheduler_cronjob_name定数を確認 |

**読解のコツ**: f_is_job_running関数がジョブの実行状態（Y/N）を返す。この戻り値がNの場合のみdbms_scheduler.run_jobが呼び出される。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **422-434行**: Trigger Scheduler Cronjobプロセスの定義。process_success_messageに「Cronjob started.」が設定されている
2. **428行**: qa_unit_tests_pkg.p_trigger_scheduler_cronjob呼び出し
3. **430行**: error_display_locationがINLINE_IN_NOTIFICATIONに設定

#### Step 3: PL/SQL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_trigger_scheduler_cronjobの実装（1366-1386行） |

**主要処理フロー**:
- **1372行**: f_is_job_runningでジョブ実行中チェック
- **1374行**: dbms_scheduler.run_job呼び出し（use_current_session => false）
- **1376行**: 実行中の場合はraise_application_errorでエラー

### プログラム呼び出し階層図

```
page_00009.sql (Trigger Scheduler Cronjobプロセス)
    │
    └─ qa_unit_tests_pkg.p_trigger_scheduler_cronjob
           │
           ├─ f_is_job_running(gc_utplsql_scheduler_cronjob_name)
           │      │
           │      └─ USER_SCHEDULER_RUNNING_JOBS (SELECT)
           │
           └─ dbms_scheduler.run_job
                  │
                  └─ USER_SCHEDULER_JOBS（ジョブ実行開始）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

RUN CRONJOBボタン ───▶ p_trigger_scheduler_cronjob
                              │
                              ▼
                    f_is_job_running チェック
                              │
                    ┌─────────┴─────────┐
                    │                   │
                    ▼                   ▼
              running = 'N'       running = 'Y'
                    │                   │
                    ▼                   ▼
        dbms_scheduler.run_job    raise_application_error
        (use_current_session      「Scheduler Cronjob is
         => false)                 currently running」
                    │                   │
                    ▼                   ▼
          「Cronjob started.」    エラーメッセージ
                表示                   表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | ソース | ページ定義とプロセス設定 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | スケジューラジョブトリガー処理 |
| qa_constant_pkg.sql | `src/plsql/pkg/qa_constant_pkg.sql` | ソース | ジョブ名定数定義 |
