# 通知設計書 8-ユニットテストジョブ開始通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおける個別ユニットテストのカスタムジョブ実行開始時に表示されるアプリ内通知「ユニットテストジョブ開始通知」の設計を記述する。

### 本通知の処理概要

この通知は、ユーザーがRestart Unit Test画面（ページ11）でRESTART UNIT TESTボタンをクリックし、指定されたルール・クライアント・スキーマの組み合わせに対するカスタムユニットテストジョブが正常に作成・開始された際に「Job started.」というメッセージを表示する機能である。

**業務上の目的・背景**：QUASTOでは、定期的なスケジューラジョブ（全ルールの一括テスト）とは別に、特定のルール・スキーマの組み合わせに対して個別にユニットテストを再実行する機能がある。テスト結果が予想外だった場合の再確認や、ルール修正後の即時検証などに使用される。この通知により、ユーザーはカスタムジョブが正常に開始されたことを即座に認識できる。

**通知の送信タイミング**：ユーザーがRESTART UNIT TESTボタンをクリックし、サーバー側でPL/SQLプロセス「Create Job」が正常に完了した時点でAPEXの成功メッセージ機能により自動的に表示される。

**通知の受信者**：ジョブを作成した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：「Job started.」という固定メッセージが画面上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーはジョブの開始を確認し、Job Historyセクションでジョブの実行状況を確認するか、REFRESHボタンでページを更新してジョブの完了を待つ。

## 通知種別

アプリ内通知（Oracle APEXの成功メッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 中 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | 成功（Success） |
| 自動消去 | 有（APEXデフォルト動作） |

### 本文テンプレート

```
Job started.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数は使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | RESTART UNIT TESTボタンのクリック | Create Jobプロセスが正常完了 | page_00011のプロセス「Create Job」の成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ジョブ存在時 | 同一ルール・クライアント・スキーマのジョブが既に存在する場合、ボタンが非表示になる |
| プロセス失敗時 | エラーが発生した場合は成功メッセージは表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[RESTART UNIT TESTボタンクリック] --> B[Create Jobプロセス実行]
    B --> C[qa_unit_tests_pkg.p_create_custom_unit_test_job呼び出し]
    C --> D[ジョブ名生成]
    D --> E[dbms_scheduler.create_job実行]
    E --> F{処理結果}
    F -->|成功| G[成功メッセージ表示]
    F -->|失敗| H[エラーメッセージ表示]
    G --> I[終了]
    H --> J[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| USER_SCHEDULER_JOBS | 既存ジョブ確認 | f_exists_custom_job関数で参照 |
| QA_JOB_RUN_DETAILS_P0011_V | ジョブ実行履歴表示 | ページ内レポート用 |

### テーブル別参照項目詳細

#### USER_SCHEDULER_JOBS

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| job_name | ジョブ名 | job_name like 'QUASTO_UT_{rule}_{client}_{scheme}%' |
| state | ジョブ状態 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| USER_SCHEDULER_JOBS（間接的） | INSERT | dbms_scheduler.create_jobによるジョブ作成 |

#### 送信ログテーブル

通知自体のログは保存されない（APEX標準の成功メッセージ機能のため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スケジューラエラー | dbms_scheduler.create_job失敗時 | 例外処理でエラーログ記録（qa_logger_pkg） |
| ジョブ名重複 | 同一名のジョブが存在する場合 | タイムスタンプ付きジョブ名で回避 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ただしジョブ存在時はボタン非表示） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- dbms_scheduler.create_job権限が必要
- 保護レベル: C（チェックサム保護）
- モーダルダイアログ内で操作が完結

## 備考

- 本通知はAPEXの標準機能（process_success_message）を利用している
- モーダルダイアログ内で表示される
- ジョブは5秒後に開始される（interval '5' second）
- ジョブ名は「{prefix}_{rule}_{client}_{scheme}_{timestamp}」形式
- auto_drop => trueで実行後に自動削除される
- f_exists_custom_job関数でジョブの存在確認を行い、ボタン表示を制御

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、カスタムジョブの作成と管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_custom_unit_test_jobの定義（37-42行）と実装（873-916行）を確認 |
| 1-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_job_name関数でジョブ名生成ロジックを確認 |

**読解のコツ**: カスタムジョブはルール番号・クライアント名・スキーマ名とタイムスタンプからジョブ名を生成する。5秒後に開始するように設定され、実行後は自動削除される。

#### Step 2: エントリーポイントを理解する

ページ定義がすべての起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | APEXページ定義全体の構造とプロセス定義を確認 |

**主要処理フロー**:
1. **363-378行**: Create Jobプロセスの定義。process_success_messageに「Job started.」が設定されている
2. **369-372行**: qa_unit_tests_pkg.p_create_custom_unit_test_job呼び出し
3. **374行**: error_display_locationがINLINE_IN_NOTIFICATIONに設定
4. **189-208行**: RESTART_UNIT_TESTボタン定義（f_exists_custom_jobで表示条件制御）

#### Step 3: PL/SQL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_custom_unit_test_jobの実装（873-916行） |
| 3-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_run_custom_unit_testの実装（実際に実行されるプロシージャ） |

**主要処理フロー**:
- **892行**: ジョブ開始時刻を5秒後に設定（systimestamp + interval '5' second）
- **893-897行**: ジョブ名生成（f_get_job_name + タイムスタンプ）
- **899-907行**: dbms_scheduler.create_jobでジョブ作成
- **902行**: job_actionにp_run_custom_unit_testを設定
- **905行**: auto_drop => trueで実行後自動削除

### プログラム呼び出し階層図

```
page_00011.sql (Create Jobプロセス)
    │
    └─ qa_unit_tests_pkg.p_create_custom_unit_test_job
           │
           ├─ f_get_job_name（ジョブ名生成）
           │
           └─ dbms_scheduler.create_job
                  │
                  └─ USER_SCHEDULER_JOBS（ジョブ登録）
                         │
                         └─ [5秒後に実行]
                               │
                               └─ qa_unit_tests_pkg.p_run_custom_unit_test
                                      │
                                      └─ QA_TEST_RESULTS（テスト結果保存）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

P11_RULE_NUMBER ─────▶ p_create_custom_unit_test_job
P11_CLIENT_NAME ─────▶            │
P11_SCHEME_NAME ─────▶            │
                                   ▼
                         f_get_job_name
                         （ジョブ名生成）
                                   │
                                   ▼
                    l_job_name = {prefix}_{rule}_{client}_{scheme}_{timestamp}
                                   │
                                   ▼
                    dbms_scheduler.create_job
                    - job_type: PLSQL_BLOCK
                    - start_date: +5秒
                    - enabled: true
                    - auto_drop: true
                                   │
                                   ▼
                         「Job started.」表示
                                   │
                                   ▼
                    [5秒後にp_run_custom_unit_testが実行]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | ソース | ページ定義とプロセス設定 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | カスタムジョブ作成・実行処理 |
| QA_JOB_RUN_DETAILS_P0011_V | DBビュー | ビュー | ジョブ実行履歴表示用 |
