# 通知設計書 9-バリデーションエラー通知

## 概要

本ドキュメントは、QUASTOアプリケーションにおける各種処理のエラー発生時に表示されるアプリ内通知「バリデーションエラー通知」の設計を記述する。

### 本通知の処理概要

この通知は、サーバー側のPL/SQLプロセス実行時にエラーが発生した際に、エラーメッセージをページ上部の通知領域（INLINE_IN_NOTIFICATION）にインライン表示する機能である。エラーの種類に応じて、raise_application_errorで発生したアプリケーションエラーや、PL/SQL例外、APEXプロセスエラーなどが対象となる。

**業務上の目的・背景**：フォーム入力や処理実行時にエラーが発生した場合、ユーザーに何が問題だったかを明確に伝える必要がある。INLINE_IN_NOTIFICATION方式では、エラーメッセージがページ上部の通知領域に一元的に表示されるため、ユーザーはエラー内容を即座に把握できる。

**通知の送信タイミング**：ユーザーがボタンをクリックしてフォームをサブミットし、サーバー側でPL/SQLプロセスがエラーで失敗した時点でAPEXのエラーメッセージ機能により自動的に表示される。

**通知の受信者**：操作を実行した当該ユーザー本人。セッション単位で表示されるため、他のユーザーには通知されない。

**通知内容の概要**：エラーの内容に応じたメッセージがページ上部の通知領域にインライン表示される。

**期待されるアクション**：ユーザーはエラー内容を確認し、入力内容を修正するか、操作を中止する。

## 通知種別

アプリ内通知（Oracle APEXのエラーメッセージ機能）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ページサブミット後のレスポンス） |
| 優先度 | 高 |
| リトライ | 無（単発表示） |

### 送信先決定ロジック

操作を実行した当該ユーザーのブラウザセッションに対して表示される。APEXセッション管理によりユーザーが特定される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | ページ上部の通知領域（INLINE_IN_NOTIFICATION） |
| メッセージタイプ | エラー（Error） |
| 自動消去 | 無（ユーザーが閉じるまで表示継続） |

### 本文テンプレート

エラーメッセージはPL/SQLコードで動的に生成される。以下は代表的なエラーメッセージ例：

```
Scheduler Cronjob is currently running: {job_name}
```
（スケジューラジョブが実行中の場合）

```
Missing input parameter value for {parameter_name}
```
（必須パラメータが欠損している場合）

```
{PL/SQL例外メッセージ}
```
（データベースエラーの場合）

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {job_name} | ジョブ名（実行中エラー時） | qa_constant_pkg.gc_utplsql_scheduler_cronjob_name | 条件付き |
| {parameter_name} | パラメータ名（欠損エラー時） | PL/SQLコード内で指定 | 条件付き |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロセスエラー | フォームサブミット | p_error_display_location='INLINE_IN_NOTIFICATION'のプロセスでエラー発生 | 対象ページ: 00002, 00005, 00007, 00008, 00009, 00011, 09999 |

### 対象プロセス一覧

| ページ | プロセス名 | エラー表示位置 | 備考 |
|-------|-----------|--------------|------|
| page_00002 | Create Unit Tests | INLINE_IN_NOTIFICATION | ユニットテスト作成時 |
| page_00002 | Delete Unit Tests | INLINE_IN_NOTIFICATION | ユニットテスト削除時 |
| page_00005 | Upload file | INLINE_IN_NOTIFICATION | XMLファイルアップロード時 |
| page_00007 | Save Form Process | INLINE_IN_NOTIFICATION | ルール保存時 |
| page_00007 | Close Dialog | INLINE_IN_NOTIFICATION | ダイアログクローズ時 |
| page_00008 | Import file | INLINE_IN_NOTIFICATION | JSONファイルインポート時 |
| page_00009 | Save Scheduler Job Status | INLINE_IN_NOTIFICATION | スケジューラ設定保存時 |
| page_00009 | Trigger Scheduler Cronjob | INLINE_IN_NOTIFICATION | スケジューラジョブ実行時 |
| page_00011 | Create Job | INLINE_IN_NOTIFICATION | カスタムジョブ作成時 |
| page_09999 | Login | INLINE_IN_NOTIFICATION | ログイン処理時 |
| page_09999 | Clear Page(s) Cache | INLINE_IN_NOTIFICATION | キャッシュクリア時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 処理成功時 | プロセスが正常完了した場合はエラーメッセージは表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ボタンクリック/フォームサブミット] --> B[プロセス実行]
    B --> C{処理結果}
    C -->|成功| D[成功メッセージ表示]
    C -->|失敗| E{error_display_location}
    E -->|INLINE_IN_NOTIFICATION| F[通知領域にエラー表示]
    E -->|INLINE_WITH_FIELD_AND_NOTIFICATION| G[フィールド＋通知領域に表示]
    F --> H[ユーザーがエラー確認]
    G --> H
    D --> I[終了]
    H --> J[入力修正または操作中止]
```

## データベース参照・更新仕様

### 参照テーブル一覧

エラー発生時に特定のテーブルを参照することはないが、エラー内容はqa_logger_pkgによりログテーブルに記録される場合がある。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| QA_LOGS | エラーログ記録 | qa_logger_pkg.p_qa_logで記録 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| QA_LOGS | INSERT | エラー発生時にログ記録（p_qa_log呼び出し時） |

#### 送信ログテーブル

通知自体のログはAPEXセッション管理によるもので、個別のログテーブルには保存されない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ジョブ実行中 | スケジューラジョブが既に実行中 | raise_application_error(-20001, ...) |
| パラメータ欠損 | 必須パラメータが未指定 | raise_application_error(-20001, ...) |
| MIMEタイプ不正 | 不正なファイル形式 | raise_application_error(-20001, ...) |
| データベースエラー | SQL実行失敗 | 例外処理でエラーメッセージ伝播 |
| 認証エラー | ログイン失敗 | APEX認証エラー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- エラーメッセージに機密情報（パスワード、内部パス等）が含まれないよう注意
- SQLエラーの詳細はqa_logger_pkgでログ記録し、ユーザーには汎用メッセージを表示
- 保護レベル: 各ページに依存（多くはC: チェックサム保護）

## 備考

- 本通知はAPEXの標準機能（error_display_location）を利用している
- エラーメッセージは自動消去されず、ユーザーが明示的に閉じるか、次の操作を行うまで表示される
- 複数のエラーが発生した場合は、すべてのエラーメッセージが連結して表示される
- raise_application_errorで発生したエラーはORA-20001形式で表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: APEXページ定義でerror_display_locationを確認する

各ページのプロセス定義でerror_display_locationがINLINE_IN_NOTIFICATIONに設定されている箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | 270行, 283行でINLINE_IN_NOTIFICATIONを確認 |
| 1-2 | page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | 269行, 281行でINLINE_IN_NOTIFICATIONを確認 |
| 1-3 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | 553行, 564行でINLINE_IN_NOTIFICATIONを確認 |
| 1-4 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | 231行でINLINE_IN_NOTIFICATIONを確認 |
| 1-5 | page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | 417行, 430行でINLINE_IN_NOTIFICATIONを確認 |
| 1-6 | page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | 374行でINLINE_IN_NOTIFICATIONを確認 |
| 1-7 | page_09999.sql | `src/apex/f141/application/pages/page_09999.sql` | 118行, 155行, 200行でINLINE_IN_NOTIFICATIONを確認 |

**読解のコツ**: p_error_display_location=>'INLINE_IN_NOTIFICATION'の設定がある箇所で、プロセスがエラーになった場合にこの通知方式でエラーが表示される。

#### Step 2: PL/SQLでのエラー発生箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | raise_application_errorの使用箇所を確認 |
| 2-2 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | raise_application_errorの使用箇所を確認 |

**主要なエラー発生箇所**:
- **qa_unit_tests_pkg.sql 1376行**: ジョブ実行中エラー
- **qa_apex_app_pkg.sql 143-146行**: MIMEタイプ不正エラー

#### Step 3: ロギング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | p_qa_log呼び出しでエラーがログ記録される仕組みを確認 |

### プログラム呼び出し階層図

```
APEXプロセス実行
    │
    ├─ 正常終了
    │      │
    │      └─ process_success_message表示
    │
    └─ エラー発生
           │
           ├─ raise_application_error呼び出し
           │      │
           │      └─ qa_logger_pkg.p_qa_log（ログ記録）
           │             │
           │             └─ QA_LOGS（INSERT）
           │
           └─ APEXエラーハンドリング
                  │
                  └─ error_display_location判定
                         │
                         └─ INLINE_IN_NOTIFICATION
                                │
                                └─ 通知領域にエラーメッセージ表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォームサブミット ───▶ PL/SQLプロセス実行
                              │
                              ▼
                    ┌─────────┴─────────┐
                    │                   │
                    ▼                   ▼
              処理成功              処理失敗
                    │                   │
                    ▼                   ▼
          成功メッセージ表示    raise_application_error
                                        │
                                        ▼
                               qa_logger_pkg.p_qa_log
                                  （ログ記録）
                                        │
                                        ▼
                               APEX error handler
                                        │
                                        ▼
                    error_display_location = INLINE_IN_NOTIFICATION
                                        │
                                        ▼
                               通知領域にエラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | ユニットテスト生成・削除ページ |
| page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | ソース | XMLファイルアップロードページ |
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | ルール編集ページ |
| page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | ソース | JSONファイルインポートページ |
| page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | ソース | スケジューラ設定ページ |
| page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | ソース | ユニットテスト再実行ページ |
| page_09999.sql | `src/apex/f141/application/pages/page_09999.sql` | ソース | ログインページ |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | ユニットテスト関連処理 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEXアプリ関連処理 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | ロギング処理 |
