---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-ファイルアップロード成功通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00005.sql` 261-273行
- E-02: `src/apex/f141/application/pages/page_00005.sql` 267行
- E-03: `src/apex/f141/application/pages/page_00005.sql` 269行
- E-04: `src/apex/f141/application/pages/page_00005.sql` 271行
- E-05: `src/plsql/pkg/qa_apex_app_pkg.sql` 209-246行
- E-06: `src/plsql/pkg/qa_apex_app_pkg.sql` 225-230行
- E-07: `src/plsql/pkg/qa_apex_app_pkg.sql` 232-235行
- E-08: `src/plsql/pkg/qa_apex_app_pkg.sql` 237行
- E-09: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1435-1458行
- E-10: `src/apex/f141/embedded_code/pages/p00005.sql` 14行
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 2行目
- E-12: `src/apex/f141/application/pages/page_00005.sql` 228-239行（P5_XML_FILEアイテム定義）
- E-13: `src/apex/f141/application/pages/page_00005.sql` 23行（保護レベル設定）
- E-14: `src/apex/f141/application/pages/page_00005.sql` 274-283行（Close Dialogプロセス）
- E-15: `src/apex/f141/application/pages/page_00005.sql` 18行（モーダルダイアログ設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「File uploaded.」である | E-04 (p_process_success_message=>'File uploaded.') | ○ |
| C-02 | ページ5（Test Result Files）で発生する | E-01, E-11 | ○ |
| C-03 | Upload fileプロセスで通知が発生する | E-01 | ○ |
| C-04 | qa_apex_app_pkg.p_upload_unit_test_xmlが呼び出される | E-02, E-10 | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-03 | ○ |
| C-06 | APEX_APPLICATION_TEMP_FILESからファイルを取得 | E-06 | ○ |
| C-07 | MIMEタイプはapplication/xmlでチェック | E-07 | ○ |
| C-08 | qa_unit_tests_pkg.f_import_test_resultを呼び出す | E-08 | ○ |
| C-09 | QA_TEST_RESULTSテーブルにINSERTされる | E-09 | ○ |
| C-10 | P5_XML_FILEは必須項目 | E-12 (p_is_required=>true) | ○ |
| C-11 | ファイル拡張子制限は.xml | E-12 (p_attribute_11=>'.xml') | ○ |
| C-12 | 保護レベルはC | E-13 (p_protection_level=>'C') | ○ |
| C-13 | 成功後にClose Dialogプロセスが実行される | E-14 | ○ |
| C-14 | ページはモーダルダイアログ | E-15 (p_page_mode=>'MODAL') | ○ |
| C-15 | 通知カテゴリは「アプリ内通知」 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00005.sqlの271行でprocess_success_messageが「File uploaded.」であることを確認
- [ ] MIMEタイプチェックの実装が適切であることを確認
- [ ] エラー時の通知動作が正しいことを確認
