---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-バリデーションエラー通知（フィールド付）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00002.sql` 209-220行（Validate Optionバリデーション）
- E-02: `src/apex/f141/application/pages/page_00002.sql` 216行（p_error_message）
- E-03: `src/apex/f141/application/pages/page_00002.sql` 218行（p_associated_item）
- E-04: `src/apex/f141/application/pages/page_00002.sql` 219行（p_error_display_location）
- E-05: `src/apex/f141/application/pages/page_00007.sql` 446-458行（Validate Deletionバリデーション）
- E-06: `src/apex/f141/application/pages/page_00007.sql` 455行（p_error_message）
- E-07: `src/apex/f141/application/pages/page_00007.sql` 457行（p_error_display_location）
- E-08: `src/apex/f141/application/pages/page_00007.sql` 459-490行（Validate Rulenumberバリデーション）
- E-09: `src/apex/f141/application/pages/page_00007.sql` 486行（p_error_message）
- E-10: `src/apex/f141/application/pages/page_00007.sql` 488行（p_associated_item）
- E-11: `src/apex/f141/application/pages/page_00007.sql` 489行（p_error_display_location）
- E-12: `src/apex/f141/application/pages/page_00007.sql` 491-522行（Validate Rulenameバリデーション）
- E-13: `src/apex/f141/application/pages/page_00007.sql` 518行（p_error_message）
- E-14: `src/apex/f141/application/pages/page_00007.sql` 520行（p_associated_item）
- E-15: `docs/code-to-docs/通知一覧/通知一覧.csv` 11行目
- E-16: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1388-1433行（f_has_rule_test_results）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page_00002でValidate Optionバリデーションが定義されている | E-01 | ○ |
| C-02 | Validate Optionのエラーメッセージは「Please select the Option.」 | E-02 | ○ |
| C-03 | Validate OptionはP2_OPTIONに関連付けられている | E-03 (p_associated_item=>P2_OPTION) | ○ |
| C-04 | Validate OptionはINLINE_WITH_FIELD_AND_NOTIFICATIONで表示 | E-04 | ○ |
| C-05 | page_00007でValidate Deletionバリデーションが定義されている | E-05 | ○ |
| C-06 | Validate Deletionのエラーメッセージは「The Rule has saved test results and therefore cannot be deleted...」 | E-06 | ○ |
| C-07 | Validate DeletionはINLINE_WITH_FIELD_AND_NOTIFICATIONで表示 | E-07 | ○ |
| C-08 | page_00007でValidate Rulenumberバリデーションが定義されている | E-08 | ○ |
| C-09 | Validate Rulenumberのエラーメッセージは「Rulenumber already exists for this client.」 | E-09 | ○ |
| C-10 | Validate RulenumberはP7_QARU_RULE_NUMBERに関連付けられている | E-10 | ○ |
| C-11 | Validate RulenumberはINLINE_WITH_FIELD_AND_NOTIFICATIONで表示 | E-11 | ○ |
| C-12 | page_00007でValidate Rulenameバリデーションが定義されている | E-12 | ○ |
| C-13 | Validate Rulenameのエラーメッセージは「Rulename already exists for this client.」 | E-13 | ○ |
| C-14 | Validate RulenameはP7_QARU_RULE_NAMEに関連付けられている | E-14 | ○ |
| C-15 | 通知カテゴリは「アプリ内通知」 | E-15 | ○ |
| C-16 | f_has_rule_test_results関数でテスト結果存在チェック | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各バリデーション定義でp_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'が正しく設定されていることを確認
- [ ] p_associated_itemでフィールドとの関連付けが正しいことを確認
- [ ] 各エラーメッセージがユーザーにとって分かりやすいことを確認
- [ ] 重複チェックSQLが正しく機能することを確認
- [ ] f_has_rule_test_results関数が正しく機能することを確認
