---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：11-情報アラート表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **CSSスタイル詳細**：実際のCSSファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/shared_components/user_interface/templates/region/alert.sql` 行14-45
- E-02: `src/apex/f141/application/pages/page_00002.sql` 行37-51
- E-03: `src/apex/f141/application/pages/page_00005.sql` 行185-197
- E-04: `src/apex/f141/application/pages/page_00009.sql` 行38-52
- E-05: `src/apex/f141/application/pages/page_00011.sql` 行176-188
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行12

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知種別がアプリ内通知（APEX Alert Region Template使用） | E-01, E-06 | ○ |
| C-02 | テンプレート名がAlert | E-01 行32 | ○ |
| C-03 | 内部名がALERT | E-01 行33 | ○ |
| C-04 | テーマIDが42 | E-01 行35 | ○ |
| C-05 | テンプレートオプションにt-Alert--infoを使用 | E-02 行41, E-03 行189, E-04 行42, E-05 行166 | ○ |
| C-06 | page_00002でInfo Regionを使用 | E-02 行37-51 | ○ |
| C-07 | page_00005でInfo Regionを使用 | E-03 行185-197 | ○ |
| C-08 | page_00009でInfo Regionを使用 | E-04 行38-52 | ○ |
| C-09 | page_00011でInfo Regionを使用 | E-05 行162-175, 176-188 | ○ |
| C-10 | HTMLテンプレート構造がt-Alertクラスを使用 | E-01 行17-31 | ○ |
| C-11 | テンプレートIDがwwv_flow_imp.id(50721469375675106) | E-01 行15, E-02 行42 | ○ |
| C-12 | p_plug_nameが'Info' | E-02 行39, E-03 行187, E-04 行40, E-05 行163,177 | ○ |
| C-13 | ページロード時に静的に表示される | E-02, E-03, E-04, E-05（create_page_plugの定義方法から推測） | ○ |
| C-14 | メッセージ本文がp_plug_sourceで設定 | E-02 行45-47, E-03 行193, E-04 行47-48, E-05 行170-171,184 | ○ |
| C-15 | 青色の情報スタイルで表示される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CSSファイルの確認ができていないため、実際の色やスタイルの詳細は未検証
  - 候補：themes.sql / theme_files.sql / 外部CSSファイル

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 静的表示機能であり、ビジネスロジックへの影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Alert Regionテンプレートの構造が正しく記述されているか
- [ ] 使用ページ一覧（page_00002, 00005, 00009, 00011）が正しいか
- [ ] テンプレートオプション（t-Alert--info）の指定が正しいか
- [ ] ブラウザでの実際の表示を確認
