---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：12-ルール削除不可通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **f_has_rule_test_results関数の実装詳細**：パッケージ本体の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00007.sql` 行446-458
- E-02: `src/apex/f141/application/pages/page_00007.sql` 行101-117（DELETEボタン定義）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行13

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バリデーション名が「Validate if rule can be deleted」 | E-01 行447 | ○ |
| C-02 | バリデーションシーケンスが10 | E-01 行448 | ○ |
| C-03 | エラーメッセージが「The Rule has saved test results and therefore cannot be deleted. Please set it to "Inactive" instead.」 | E-01 行455 | ○ |
| C-04 | Deleteボタン押下時に実行 | E-01 行456, E-02 行102 | ○ |
| C-05 | 表示位置がINLINE_WITH_FIELD_AND_NOTIFICATION | E-01 行457 | ○ |
| C-06 | qa_unit_tests_pkg.f_has_rule_test_results関数を使用 | E-01 行450-452 | ○ |
| C-07 | pi_qaru_rule_numberパラメータに:P7_QARU_RULE_NUMBERを渡す | E-01 行451 | ○ |
| C-08 | pi_qaru_client_nameパラメータに:P7_QARU_CLIENT_NAMEを渡す | E-01 行452 | ○ |
| C-09 | バリデーションタイプがEXPRESSION | E-01 行454 | ○ |
| C-10 | バリデーションタイプがPLSQL | E-01 行453 | ○ |
| C-11 | DELETEボタンのIDがwwv_flow_imp.id(54468111224367589) | E-01 行456, E-02 行102 | ○ |
| C-12 | f_has_rule_test_results関数がテスト結果の存在を確認する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- qa_unit_tests_pkgパッケージ本体のソースコードが確認できていない
  - 候補：データベース内のパッケージ仕様/本体 / 別SQLファイル

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）: パッケージ関数の実装が未確認のため、実際の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションメッセージが正しく表示されるか
- [ ] f_has_rule_test_results関数の実装を確認
- [ ] テスト結果が存在するルールで削除をテスト
- [ ] テスト結果が存在しないルールで削除が成功するかテスト
