---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ルール重複エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00007.sql` 行459-490
- E-02: `src/apex/f141/application/pages/page_00007.sql` 行135-151（CREATEボタン定義）
- E-03: `src/apex/f141/application/pages/page_00007.sql` 行167-189（P7_QARU_RULE_NUMBER定義）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行14

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バリデーション名が「Validate if Rule already exists」 | E-01 行460 | ○ |
| C-02 | バリデーションシーケンスが20 | E-01 行461 | ○ |
| C-03 | エラーメッセージが「Rulenumber already exists for this client.」 | E-01 行486 | ○ |
| C-04 | Createボタン押下時に実行 | E-01 行487, E-02 行136 | ○ |
| C-05 | 表示位置がINLINE_WITH_FIELD_AND_NOTIFICATION | E-01 行489 | ○ |
| C-06 | P7_QARU_RULE_NUMBERフィールドに関連付け | E-01 行488, E-03 | ○ |
| C-07 | バリデーションタイプがFUNC_BODY_RETURNING_BOOLEAN | E-01 行485 | ○ |
| C-08 | バリデーションタイプがPLSQL | E-01 行484 | ○ |
| C-09 | qa_rulesテーブルからcount(1)を取得 | E-01 行467-468 | ○ |
| C-10 | qaru_rule_numberで検索 | E-01 行470 | ○ |
| C-11 | qaru_client_nameで検索 | E-01 行471 | ○ |
| C-12 | count > 0の場合にfalseを返す | E-01 行473-475 | ○ |
| C-13 | count = 0の場合にtrueを返す | E-01 行476-477 | ○ |
| C-14 | CREATEボタンのIDがwwv_flow_imp.id(37067720447570637) | E-01 行487, E-02 行136 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: バリデーションロジックがソースコード内に完全に記述されており、外部依存なし

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションメッセージが正しく表示されるか
- [ ] 重複するルール番号で作成をテスト
- [ ] 重複しないルール番号で作成が成功するかテスト
- [ ] Rule Numberフィールドにエラーが表示されるか
