---
generated_at: 2026-01-22 11:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ルール名重複エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00007.sql` 行491-522
- E-02: `src/apex/f141/application/pages/page_00007.sql` 行135-151（CREATEボタン定義）
- E-03: `src/apex/f141/application/pages/page_00007.sql` 行214-235（P7_QARU_NAME定義）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行15

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バリデーション名が「Validate if Name already exists」 | E-01 行492 | ○ |
| C-02 | バリデーションシーケンスが30 | E-01 行493 | ○ |
| C-03 | エラーメッセージが「Rulename already exists for this client.」 | E-01 行518 | ○ |
| C-04 | Createボタン押下時に実行 | E-01 行519, E-02 行136 | ○ |
| C-05 | 表示位置がINLINE_WITH_FIELD_AND_NOTIFICATION | E-01 行521 | ○ |
| C-06 | P7_QARU_NAMEフィールドに関連付け | E-01 行520, E-03 | ○ |
| C-07 | バリデーションタイプがFUNC_BODY_RETURNING_BOOLEAN | E-01 行517 | ○ |
| C-08 | バリデーションタイプがPLSQL | E-01 行516 | ○ |
| C-09 | qa_rulesテーブルからcount(1)を取得 | E-01 行499-500 | ○ |
| C-10 | qaru_nameで検索 | E-01 行502 | ○ |
| C-11 | qaru_client_nameで検索 | E-01 行503 | ○ |
| C-12 | count > 0の場合にfalseを返す | E-01 行505-507 | ○ |
| C-13 | count = 0の場合にtrueを返す | E-01 行508-509 | ○ |
| C-14 | CREATEボタンのIDがwwv_flow_imp.id(37067720447570637) | E-01 行519, E-02 行136 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: バリデーションロジックがソースコード内に完全に記述されており、外部依存なし

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションメッセージが正しく表示されるか
- [ ] 重複するルール名で作成をテスト
- [ ] 重複しないルール名で作成が成功するかテスト
- [ ] Nameフィールドにエラーが表示されるか
