---
generated_at: 2026-01-22 11:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-オプション未選択エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00002.sql` 行209-220
- E-02: `src/apex/f141/application/pages/page_00002.sql` 行165-177（GENERATEボタン定義）
- E-03: `src/apex/f141/application/pages/page_00002.sql` 行178-192（P2_OPTIONフィールド定義）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行16

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バリデーション名が「Validate Option selected for Generate」 | E-01 行211 | ○ |
| C-02 | バリデーションシーケンスが10 | E-01 行212 | ○ |
| C-03 | エラーメッセージが「Please select the Option.」 | E-01 行216 | ○ |
| C-04 | Generateボタン押下時に実行 | E-01 行217, E-02 行169 | ○ |
| C-05 | 表示位置がINLINE_WITH_FIELD_AND_NOTIFICATION | E-01 行219 | ○ |
| C-06 | P2_OPTIONフィールドに関連付け | E-01 行218, E-03 | ○ |
| C-07 | バリデーションタイプがEXPRESSION | E-01 行215 | ○ |
| C-08 | バリデーションタイプがPLSQL | E-01 行214 | ○ |
| C-09 | バリデーション式が「:P2_OPTION is not null」 | E-01 行213 | ○ |
| C-10 | P2_OPTIONのデフォルト値が「1」 | E-03 行183 | ○ |
| C-11 | オプション選択肢が「Single Package per Scheme;1,Single Package per Scheme and Rule;2」 | E-03 行186 | ○ |
| C-12 | GENERATEボタンのIDがwwv_flow_imp.id(21777713683803239) | E-01 行217, E-02 行166 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: デフォルト値が設定されているため、通常操作では発生しにくいエラー

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションメッセージが正しく表示されるか
- [ ] オプション未選択状態で生成をテスト（ブラウザ開発者ツールでデフォルト値を削除）
- [ ] オプション選択状態で生成が成功するかテスト
- [ ] Optionフィールドにエラーが表示されるか
