---
generated_at: 2026-01-22 11:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-レポートダウンロード通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00004.sql` 行81-94
- E-02: `src/apex/f141/application/pages/page_00006.sql` 行77-93
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行17

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page_00004でshow_notify='Y'が設定されている | E-01 行89 | ○ |
| C-02 | page_00006でshow_notify='Y'が設定されている | E-02 行86 | ○ |
| C-03 | page_00004でダウンロード形式が'CSV:HTML:XLSX:PDF' | E-01 行90 | ○ |
| C-04 | page_00006でダウンロード形式が'CSV:HTML:XLSX:PDF' | E-02 行87 | ○ |
| C-05 | page_00004でメールダウンロードが有効 | E-01 行91 | ○ |
| C-06 | page_00006でメールダウンロードが有効 | E-02 行88 | ○ |
| C-07 | page_00004のデータソースがQA_TEST_RUN_DETAILS_P0004_V | E-01（page_plug定義より推測） | ○ |
| C-08 | page_00006のデータソースがQA_RULES_P0006_V | E-02 行44 | ○ |
| C-09 | Interactive Reportとしてページが定義されている | E-01, E-02（create_worksheet呼び出し） | ○ |
| C-10 | 通知はAPEX標準機能として提供される | APEX標準仕様（外部ドキュメント） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: APEX標準機能を使用しており、設定パラメータのみで動作する

## 6) レビュアーチェックリスト（最小）
- [ ] ダウンロードメニューが表示されるか
- [ ] 各形式（CSV、HTML、XLSX、PDF）でダウンロードが成功するか
- [ ] 通知がブラウザに表示されるか
- [ ] ダウンロードファイルに正しいデータが含まれているか
