---
generated_at: 2026-01-22 11:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-レポートメール送信機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00004.sql` 行81-94
- E-02: `src/apex/f141/application/pages/page_00005.sql` 行80-94
- E-03: `src/apex/f141/application/pages/page_00006.sql` 行77-93
- E-04: `src/apex/f141/application/pages/page_00008.sql` 行80-92
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行18

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page_00004でenable_mail_download='Y'が設定されている | E-01 行91 | ○ |
| C-02 | page_00005でenable_mail_download='Y'が設定されている | E-02 行91 | ○ |
| C-03 | page_00006でenable_mail_download='Y'が設定されている | E-03 行88 | ○ |
| C-04 | page_00008でenable_mail_download='Y'が設定されている | E-04 行89 | ○ |
| C-05 | Interactive Reportとしてページが定義されている（page_00004） | E-01（create_worksheet呼び出し） | ○ |
| C-06 | Interactive Reportとしてページが定義されている（page_00005） | E-02（create_worksheet呼び出し） | ○ |
| C-07 | Interactive Reportとしてページが定義されている（page_00006） | E-03（create_worksheet呼び出し） | ○ |
| C-08 | Interactive Reportとしてページが定義されている（page_00008） | E-04（create_worksheet呼び出し） | ○ |
| C-09 | メール機能はAPEX標準機能として提供される | APEX標準仕様（外部ドキュメント） | ○ |
| C-10 | メール送信はAPEXメールキューを使用 | APEX標準仕様（外部ドキュメント） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）: APEXインスタンスのメールサーバー設定が必要。設定がない場合は機能が動作しない。

## 6) レビュアーチェックリスト（最小）
- [ ] APEXインスタンスにメールサーバーが設定されているか
- [ ] メール送信ダイアログが表示されるか
- [ ] 実際にメールが送信されるか
- [ ] 添付ファイルが正しく生成されるか
- [ ] page_00004, 00005, 00006, 00008でメール機能が利用可能か
