---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ユニットテスト作成成功通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00002.sql` 260-274行（Create Unit Testsプロセス）
- E-02: `src/apex/f141/application/pages/page_00002.sql` 272行（process_success_message）
- E-03: `src/apex/f141/application/pages/page_00002.sql` 266-268行（PL/SQL呼び出し）
- E-04: `src/apex/f141/application/pages/page_00002.sql` 270行（error_display_location）
- E-05: `src/apex/f141/application/pages/page_00002.sql` 209-220行（バリデーション）
- E-06: `src/apex/f141/application/pages/page_00002.sql` 178-192行（P2_OPTIONアイテム）
- E-07: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1488-1521行（p_create_unit_tests_for_schemes）
- E-08: `src/plsql/pkg/qa_unit_tests_pkg.sql` 657-823行（p_create_unit_test_packages）
- E-09: `src/plsql/pkg/qa_unit_tests_pkg.sql` 312-315行（オプションバリデーション）
- E-10: `src/plsql/pkg/qa_unit_tests_pkg.sql` 346-370行（ルール検証）
- E-11: `src/apex/f141/embedded_code/pages/p00002.sql` 14-15行
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 3行目
- E-13: `src/apex/f141/application/pages/page_00002.sql` 18行（モーダルダイアログ）
- E-14: `src/apex/f141/application/pages/page_00002.sql` 23行（保護レベル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Unit Tests created.」である | E-02 (p_process_success_message=>'Unit Tests created.') | ○ |
| C-02 | ページ2（Unit Test Generation）で発生する | E-01, E-12 | ○ |
| C-03 | Create Unit Testsプロセスで通知が発生する | E-01 | ○ |
| C-04 | QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemesが呼び出される | E-03, E-11 | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-04 | ○ |
| C-06 | P2_OPTIONが未選択時はバリデーションエラー | E-05 (error_message=>'Please select the Option.') | ○ |
| C-07 | オプション値は1（Single Package per Scheme）と2（Single Package per Scheme and Rule） | E-06, E-09 | ○ |
| C-08 | p_create_unit_test_packagesが内部で呼び出される | E-07, E-08 | ○ |
| C-09 | ルールが未定義の場合はエラー | E-10 | ○ |
| C-10 | スキーマ名がnullの場合は全スキーマ対象 | E-07 (1504-1506行) | ○ |
| C-11 | 既存パッケージは削除してから再作成 | E-08 (678行：p_delete_unit_test_packages呼び出し) | ○ |
| C-12 | EXECUTE IMMEDIATEでDDL実行 | E-08 (724, 749, 789, 802行) | ○ |
| C-13 | ページはモーダルダイアログ | E-13 (p_page_mode=>'MODAL') | ○ |
| C-14 | 保護レベルはC | E-14 (p_protection_level=>'C') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00002.sqlの272行でprocess_success_messageが「Unit Tests created.」であることを確認
- [ ] バリデーション「Validate Option selected for Generate」が正しく機能することを確認
- [ ] p_create_unit_test_packagesの生成ロジックが正しいことを確認
