---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ユニットテスト削除成功通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00002.sql` 275-287行（Delete Unit Testsプロセス）
- E-02: `src/apex/f141/application/pages/page_00002.sql` 285行（process_success_message）
- E-03: `src/apex/f141/application/pages/page_00002.sql` 281行（PL/SQL呼び出し）
- E-04: `src/apex/f141/application/pages/page_00002.sql` 283行（error_display_location）
- E-05: `src/apex/f141/application/pages/page_00002.sql` 152-164行（DELETEボタン定義）
- E-06: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1523-1552行（p_delete_unit_tests_for_schemes）
- E-07: `src/plsql/pkg/qa_unit_tests_pkg.sql` 825-871行（p_delete_unit_test_packages）
- E-08: `src/plsql/pkg/qa_unit_tests_pkg.sql` 844行（DROP PACKAGE実行）
- E-09: `src/apex/f141/embedded_code/pages/p00002.sql` 20行
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 4行目
- E-11: `src/apex/f141/application/pages/page_00002.sql` 18行（モーダルダイアログ）
- E-12: `src/apex/f141/application/pages/page_00002.sql` 23行（保護レベル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Unit Tests deleted.」である | E-02 (p_process_success_message=>'Unit Tests deleted.') | ○ |
| C-02 | ページ2（Unit Test Generation）で発生する | E-01, E-10 | ○ |
| C-03 | Delete Unit Testsプロセスで通知が発生する | E-01 | ○ |
| C-04 | QA_UNIT_TESTS_PKG.p_delete_unit_tests_for_schemesが呼び出される | E-03, E-09 | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-04 | ○ |
| C-06 | DELETEボタンはDangerスタイル | E-05 (p_button_template_options=>'...t-Button--danger...') | ○ |
| C-07 | p_delete_unit_test_packagesが内部で呼び出される | E-06, E-07 | ○ |
| C-08 | DROP PACKAGEでパッケージを削除 | E-08 (execute immediate 'DROP PACKAGE ' \|\| l_package_name) | ○ |
| C-09 | スキーマ名がnullの場合は全パッケージ削除 | E-06 (1536-1538行), E-07 (848-857行) | ○ |
| C-10 | USER_OBJECTSからパッケージを検索 | E-07 (838-841行) | ○ |
| C-11 | ページはモーダルダイアログ | E-11 (p_page_mode=>'MODAL') | ○ |
| C-12 | 保護レベルはC | E-12 (p_protection_level=>'C') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00002.sqlの285行でprocess_success_messageが「Unit Tests deleted.」であることを確認
- [ ] p_delete_unit_test_packagesのDROP PACKAGE実行が正しいことを確認
- [ ] スキーマ名指定なしの場合の全削除動作が意図通りであることを確認
