---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ルール保存成功通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00007.sql` 542-556行（Save Form Process）
- E-02: `src/apex/f141/application/pages/page_00007.sql` 554行（process_success_message）
- E-03: `src/apex/f141/application/pages/page_00007.sql` 553行（error_display_location）
- E-04: `src/apex/f141/application/pages/page_00007.sql` 118-134行（SAVEボタン）
- E-05: `src/apex/f141/application/pages/page_00007.sql` 135-151行（CREATEボタン）
- E-06: `src/apex/f141/application/pages/page_00007.sql` 101-117行（DELETEボタン）
- E-07: `src/apex/f141/application/pages/page_00007.sql` 446-458行（削除バリデーション）
- E-08: `src/apex/f141/application/pages/page_00007.sql` 459-490行（ルール番号重複チェック）
- E-09: `src/apex/f141/application/pages/page_00007.sql` 491-522行（ルール名重複チェック）
- E-10: `src/apex/f141/application/pages/page_00007.sql` 557-566行（Close Dialogプロセス）
- E-11: `src/apex/f141/embedded_code/pages/p00007.sql`
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 5行目
- E-13: `src/apex/f141/application/pages/page_00007.sql` 18行（モーダルダイアログ）
- E-14: `src/apex/f141/application/pages/page_00007.sql` 23行（保護レベル）
- E-15: `src/apex/f141/application/pages/page_00007.sql` 112-113行（削除確認メッセージ）
- E-16: `src/apex/f141/application/pages/page_00007.sql` 152-166行（P7_QARU_ID定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Changes saved.」である | E-02 (p_process_success_message=>'Changes saved.') | ○ |
| C-02 | ページ7（Add/Edit Rule）で発生する | E-01, E-12 | ○ |
| C-03 | Save Form Processで通知が発生する | E-01 | ○ |
| C-04 | NATIVE_FORM_DML処理タイプ | E-01 (p_process_type=>'NATIVE_FORM_DML') | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-03 | ○ |
| C-06 | SAVEボタンはUPDATE操作 | E-04 (p_database_action=>'UPDATE') | ○ |
| C-07 | CREATEボタンはINSERT操作 | E-05 (p_database_action=>'INSERT') | ○ |
| C-08 | DELETEボタンはDELETE操作 | E-06 (p_database_action=>'DELETE') | ○ |
| C-09 | テスト結果があるルールは削除不可 | E-07 | ○ |
| C-10 | ルール番号重複時エラー「Rulenumber already exists...」 | E-08 (p_error_message) | ○ |
| C-11 | ルール名重複時エラー「Rulename already exists...」 | E-09 (p_error_message) | ○ |
| C-12 | 成功後にClose Dialogプロセスが実行される | E-10 | ○ |
| C-13 | ページはモーダルダイアログ | E-13 (p_page_mode=>'MODAL') | ○ |
| C-14 | 保護レベルはC | E-14 (p_protection_level=>'C') | ○ |
| C-15 | 削除時は確認ダイアログあり | E-15 (p_confirm_message, p_confirm_style=>'warning') | ○ |
| C-16 | P7_QARU_IDは隠しフィールドで保護レベルS | E-16 (p_display_as=>'NATIVE_HIDDEN', p_protection_level=>'S') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00007.sqlの554行でprocess_success_messageが「Changes saved.」であることを確認
- [ ] バリデーション3種（削除可否、ルール番号重複、ルール名重複）が正しく機能することを確認
- [ ] SAVE/CREATE/DELETEボタンのデータベースアクションが正しいことを確認
