---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-スケジューラ設定保存成功通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00009.sql` 409-421行（Save Scheduler Job Statusプロセス）
- E-02: `src/apex/f141/application/pages/page_00009.sql` 419行（process_success_message）
- E-03: `src/apex/f141/application/pages/page_00009.sql` 415行（PL/SQL呼び出し）
- E-04: `src/apex/f141/application/pages/page_00009.sql` 417行（error_display_location）
- E-05: `src/apex/f141/application/pages/page_00009.sql` 353-370行（P9_ENABLE_SCHEDULER_JOBアイテム）
- E-06: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1335-1364行（p_enable_scheduler_cronjob）
- E-07: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1345-1349行（バリデーション）
- E-08: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1351-1356行（enable/disable呼び出し）
- E-09: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1304-1333行（f_is_scheduler_cronjob_enabled）
- E-10: `src/apex/f141/embedded_code/pages/p00009.sql` 19行
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 7行目
- E-12: `src/apex/f141/application/pages/page_00009.sql` 18行（モーダルダイアログ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Saved.」である | E-02 (p_process_success_message=>'Saved.') | ○ |
| C-02 | ページ9（Config Scheduler Job）で発生する | E-01, E-11 | ○ |
| C-03 | Save Scheduler Job Statusプロセスで通知が発生する | E-01 | ○ |
| C-04 | qa_unit_tests_pkg.p_enable_scheduler_cronjobが呼び出される | E-03, E-10 | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-04 | ○ |
| C-06 | P9_ENABLE_SCHEDULER_JOBはYes/Noスイッチ | E-05 (p_display_as=>'NATIVE_YES_NO') | ○ |
| C-07 | ステータスはY/Nのみ許可 | E-07 | ○ |
| C-08 | dbms_scheduler.enable/disableを呼び出す | E-08 | ○ |
| C-09 | f_is_scheduler_cronjob_enabledで初期値を取得 | E-05, E-09 | ○ |
| C-10 | USER_SCHEDULER_JOBSテーブルを参照 | E-09 (1315-1318行) | ○ |
| C-11 | ページはモーダルダイアログ | E-12 (p_page_mode=>'MODAL') | ○ |
| C-12 | 通知カテゴリは「アプリ内通知」 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00009.sqlの419行でprocess_success_messageが「Saved.」であることを確認
- [ ] dbms_scheduler.enable/disableの呼び出しが正しいことを確認
- [ ] Y/N以外の値が入力された場合のエラー処理を確認
