---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-スケジューラジョブ開始通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00009.sql` 422-434行（Trigger Scheduler Cronjobプロセス）
- E-02: `src/apex/f141/application/pages/page_00009.sql` 432行（process_success_message）
- E-03: `src/apex/f141/application/pages/page_00009.sql` 428行（PL/SQL呼び出し）
- E-04: `src/apex/f141/application/pages/page_00009.sql` 430行（error_display_location）
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1366-1386行（p_trigger_scheduler_cronjob）
- E-06: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1372行（f_is_job_runningチェック）
- E-07: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1374行（dbms_scheduler.run_job）
- E-08: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1376行（実行中エラー）
- E-09: `src/apex/f141/application/pages/page_00009.sql` 18行（モーダルダイアログ）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 8行目
- E-11: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1374行（use_current_session => false）
- E-12: `src/apex/f141/application/pages/page_00009.sql` 23行（保護レベル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Cronjob started.」である | E-02 (p_process_success_message=>'Cronjob started.') | ○ |
| C-02 | ページ9（Config Scheduler Job）で発生する | E-01, E-10 | ○ |
| C-03 | Trigger Scheduler Cronjobプロセスで通知が発生する | E-01 | ○ |
| C-04 | qa_unit_tests_pkg.p_trigger_scheduler_cronjobが呼び出される | E-03 | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-04 | ○ |
| C-06 | f_is_job_runningで実行中チェックを行う | E-06 | ○ |
| C-07 | dbms_scheduler.run_jobでジョブを実行する | E-07 | ○ |
| C-08 | ジョブ実行中の場合はraise_application_errorでエラー | E-08 | ○ |
| C-09 | ページはモーダルダイアログ | E-09 (p_page_mode=>'MODAL') | ○ |
| C-10 | 通知カテゴリは「アプリ内通知」 | E-10 | ○ |
| C-11 | use_current_session => falseで非同期実行 | E-11 | ○ |
| C-12 | 保護レベルはC | E-12 (p_protection_level=>'C') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00009.sqlの432行でprocess_success_messageが「Cronjob started.」であることを確認
- [ ] f_is_job_runningによる二重実行防止が正しく機能することを確認
- [ ] dbms_scheduler.run_jobの非同期実行設定（use_current_session => false）が正しいことを確認
