---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ユニットテストジョブ開始通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00011.sql` 363-378行（Create Jobプロセス）
- E-02: `src/apex/f141/application/pages/page_00011.sql` 376行（process_success_message）
- E-03: `src/apex/f141/application/pages/page_00011.sql` 369-372行（PL/SQL呼び出し）
- E-04: `src/apex/f141/application/pages/page_00011.sql` 374行（error_display_location）
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql` 873-916行（p_create_custom_unit_test_job）
- E-06: `src/plsql/pkg/qa_unit_tests_pkg.sql` 892行（5秒後開始設定）
- E-07: `src/plsql/pkg/qa_unit_tests_pkg.sql` 893-897行（ジョブ名生成）
- E-08: `src/plsql/pkg/qa_unit_tests_pkg.sql` 899-907行（dbms_scheduler.create_job）
- E-09: `src/plsql/pkg/qa_unit_tests_pkg.sql` 905行（auto_drop => true）
- E-10: `src/apex/f141/application/pages/page_00011.sql` 18行（モーダルダイアログ）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 9行目
- E-12: `src/apex/f141/application/pages/page_00011.sql` 189-208行（ボタン定義）
- E-13: `src/apex/f141/application/pages/page_00011.sql` 200-203行（f_exists_custom_job条件）
- E-14: `src/apex/f141/application/pages/page_00011.sql` 23行（保護レベル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Job started.」である | E-02 (p_process_success_message=>'Job started.') | ○ |
| C-02 | ページ11（Restart Unit Test）で発生する | E-01, E-11 | ○ |
| C-03 | Create Jobプロセスで通知が発生する | E-01 | ○ |
| C-04 | qa_unit_tests_pkg.p_create_custom_unit_test_jobが呼び出される | E-03 | ○ |
| C-05 | エラー表示位置はINLINE_IN_NOTIFICATION | E-04 | ○ |
| C-06 | ジョブは5秒後に開始される | E-06 (systimestamp + interval '5' second) | ○ |
| C-07 | ジョブ名はタイムスタンプ付きで生成される | E-07 | ○ |
| C-08 | dbms_scheduler.create_jobでジョブが作成される | E-08 | ○ |
| C-09 | auto_drop => trueで実行後自動削除 | E-09 | ○ |
| C-10 | ページはモーダルダイアログ | E-10 (p_page_mode=>'MODAL') | ○ |
| C-11 | 通知カテゴリは「アプリ内通知」 | E-11 | ○ |
| C-12 | f_exists_custom_jobでボタン表示を制御 | E-13 | ○ |
| C-13 | RESTART_UNIT_TESTボタンで起動 | E-12 (p_button_name=>'RESTART_UNIT_TEST') | ○ |
| C-14 | 保護レベルはC | E-14 (p_protection_level=>'C') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] page_00011.sqlの376行でprocess_success_messageが「Job started.」であることを確認
- [ ] ジョブが5秒後に開始される設定が正しいことを確認
- [ ] auto_drop設定によりジョブが実行後自動削除されることを確認
- [ ] f_exists_custom_jobによるボタン表示制御が正しく機能することを確認
