---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-バリデーションエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00002.sql` 270行（Create Unit Tests - INLINE_IN_NOTIFICATION）
- E-02: `src/apex/f141/application/pages/page_00002.sql` 283行（Delete Unit Tests - INLINE_IN_NOTIFICATION）
- E-03: `src/apex/f141/application/pages/page_00005.sql` 269行（Upload file - INLINE_IN_NOTIFICATION）
- E-04: `src/apex/f141/application/pages/page_00005.sql` 281行（Close Dialog - INLINE_IN_NOTIFICATION）
- E-05: `src/apex/f141/application/pages/page_00007.sql` 553行（Save Form Process - INLINE_IN_NOTIFICATION）
- E-06: `src/apex/f141/application/pages/page_00007.sql` 564行（Close Dialog - INLINE_IN_NOTIFICATION）
- E-07: `src/apex/f141/application/pages/page_00008.sql` 231行（Import file - INLINE_IN_NOTIFICATION）
- E-08: `src/apex/f141/application/pages/page_00009.sql` 417行（Save Scheduler Job Status - INLINE_IN_NOTIFICATION）
- E-09: `src/apex/f141/application/pages/page_00009.sql` 430行（Trigger Scheduler Cronjob - INLINE_IN_NOTIFICATION）
- E-10: `src/apex/f141/application/pages/page_00011.sql` 374行（Create Job - INLINE_IN_NOTIFICATION）
- E-11: `src/apex/f141/application/pages/page_09999.sql` 118行, 155行, 200行（Login関連プロセス - INLINE_IN_NOTIFICATION）
- E-12: `src/plsql/pkg/qa_unit_tests_pkg.sql` 1376行（raise_application_error）
- E-13: `src/plsql/pkg/qa_apex_app_pkg.sql` 143-146行（MIMEタイプエラー）
- E-14: `docs/code-to-docs/通知一覧/通知一覧.csv` 10行目
- E-15: `src/plsql/pkg/qa_unit_tests_pkg.sql` 例外処理セクション（qa_logger_pkg.p_qa_log呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page_00002でINLINE_IN_NOTIFICATION使用 | E-01, E-02 | ○ |
| C-02 | page_00005でINLINE_IN_NOTIFICATION使用 | E-03, E-04 | ○ |
| C-03 | page_00007でINLINE_IN_NOTIFICATION使用 | E-05, E-06 | ○ |
| C-04 | page_00008でINLINE_IN_NOTIFICATION使用 | E-07 | ○ |
| C-05 | page_00009でINLINE_IN_NOTIFICATION使用 | E-08, E-09 | ○ |
| C-06 | page_00011でINLINE_IN_NOTIFICATION使用 | E-10 | ○ |
| C-07 | page_09999でINLINE_IN_NOTIFICATION使用 | E-11 | ○ |
| C-08 | raise_application_errorでエラーを発生させる | E-12, E-13 | ○ |
| C-09 | ジョブ実行中エラーメッセージ「Scheduler Cronjob is currently running」 | E-12 | ○ |
| C-10 | MIMEタイプ不正時にエラーを発生させる | E-13 | ○ |
| C-11 | 通知カテゴリは「アプリ内通知」 | E-14 | ○ |
| C-12 | 複数ページで使用される | E-14 (page_00002, 00005, 00007, 00008, 00009, 00011, 09999) | ○ |
| C-13 | qa_logger_pkg.p_qa_logでエラーログ記録 | E-15 | ○ |
| C-14 | エラーメッセージは通知領域に表示される | E-01-E-11（p_error_display_location設定） | ○ |
| C-15 | エラーはORA-20001形式で表示される | E-12 (raise_application_error(-20001, ...)) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各ページのプロセス定義でp_error_display_location=>'INLINE_IN_NOTIFICATION'が正しく設定されていることを確認
- [ ] raise_application_errorのエラーコードが-20001で統一されていることを確認
- [ ] qa_logger_pkg.p_qa_logによるエラーログ記録が正しく機能することを確認
- [ ] エラーメッセージに機密情報が含まれていないことを確認
