---
generated_at: 2026-01-22 11:35:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：運用マニュアル.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **パスワードリセット手順**：具体的な手順の根拠不足
  2. **サポート連絡方法**：連絡先情報の根拠不足
  3. **管理者権限の詳細機能**：administration_rightsスキームの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要、技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面構成
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移フロー
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-06: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件
- E-07: `docs/code-to-docs/画面設計書/13-Login Page.md` - ログイン画面設計
- E-08: `docs/code-to-docs/画面設計書/2-Dashboard.md` - ダッシュボード画面設計
- E-09: `docs/code-to-docs/画面設計書/7-Rules.md` - ルール管理画面設計
- E-10: `docs/code-to-docs/画面設計書/8-Add_Edit Rule.md` - ルール編集画面設計
- E-11: `docs/code-to-docs/画面設計書/3-Unit Test Generation.md` - ユニットテスト生成画面設計
- E-12: `docs/code-to-docs/画面設計書/10-Config Scheduler Job.md` - スケジューラ設定画面設計
- E-13: `docs/code-to-docs/画面設計書/4-Runtime Error.md` - ランタイムエラー画面設計
- E-14: `docs/code-to-docs/画面設計書/5-Invalid Objects.md` - 無効オブジェクト画面設計
- E-15: `docs/code-to-docs/画面設計書/9-Rule Files.md` - ルールファイル管理画面設計
- E-16: `docs/code-to-docs/画面設計書/6-Test Result Files.md` - テスト結果ファイル管理画面設計
- E-17: `docs/code-to-docs/画面設計書/12-Region Plugin.md` - Region Plugin画面設計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム概要（QUASTO説明） | E-01 | ○ |
| C-02 | 主要業務カテゴリ（品質ルール管理、テスト管理等） | E-04, E-06 | ○ |
| C-03 | 業務フロー（STEP1-5） | E-06 | ○ |
| C-04 | 役割別業務（品質管理者/開発者） | E-06 | ○ |
| C-05 | 主な機能一覧 | E-04, E-05 | ○ |
| C-06 | ユーザー種別（一般ユーザー/管理者） | E-06 BR-015, BR-016 | ○ |
| C-07 | ログイン画面のURL | E-07 | ○ |
| C-08 | ログイン入力項目（Username, Password, Remember） | E-07 | ○ |
| C-09 | ログイン認証フロー | E-07 | ○ |
| C-10 | セッションタイムアウト動作 | E-07 | ○ |
| C-11 | Dashboard画面のアクセス方法 | E-08 | ○ |
| C-12 | ファセット検索項目（Categories等） | E-08 | ○ |
| C-13 | Quota円グラフの説明 | E-08 | ○ |
| C-14 | タイムラインチャートの説明 | E-08 | ○ |
| C-15 | Test Executions Reportのカラム | E-08 | ○ |
| C-16 | Config Scheduler Jobボタンの機能 | E-08, E-12 | ○ |
| C-17 | Test Result Filesボタンの機能 | E-08, E-16 | ○ |
| C-18 | Detailsリンクの機能 | E-08, E-14 | ○ |
| C-19 | Runtime Errorアイコンの機能 | E-08, E-13 | ○ |
| C-20 | Rules画面のアクセス方法 | E-09 | ○ |
| C-21 | ルール一覧のカラム | E-09 | ○ |
| C-22 | Add Ruleボタンの機能 | E-09, E-10 | ○ |
| C-23 | ルール編集画面の入力項目 | E-10 | ○ |
| C-24 | ルール削除時の制約（テスト結果存在時） | E-10 | ○ |
| C-25 | Unit Test Generation画面のアクセス方法 | E-09, E-11 | ○ |
| C-26 | テストパッケージ生成オプション | E-11 | ○ |
| C-27 | 生成パッケージの命名規則 | E-11 | ○ |
| C-28 | スケジューラ情報表示項目 | E-12 | ○ |
| C-29 | 定期実行有効/無効設定 | E-12 | ○ |
| C-30 | Run Cronjob Nowボタンの機能 | E-12 | ○ |
| C-31 | Job History表示項目 | E-12 | ○ |
| C-32 | Invalid Objects画面のカラム | E-14 | ○ |
| C-33 | Runtime Error画面の表示内容 | E-13 | ○ |
| C-34 | Rule Files画面のアクセス方法 | E-09, E-15 | ○ |
| C-35 | ルールエクスポート機能 | E-15 | ○ |
| C-36 | ルールインポート機能 | E-15 | ○ |
| C-37 | Test Result Files画面のアクセス方法 | E-08, E-16 | ○ |
| C-38 | テスト結果エクスポート機能 | E-16 | ○ |
| C-39 | テスト結果インポート機能 | E-16 | ○ |
| C-40 | エラーメッセージ一覧 | E-10, E-15, E-16 | ○ |
| C-41 | ルール削除不可エラー | E-10 | ○ |
| C-42 | ルール番号重複エラー | E-10 | ○ |
| C-43 | ファイルMIMEタイプエラー | E-15, E-16 | ○ |
| C-44 | パスワードリセット手順 | **根拠なし** | △ |
| C-45 | サポート連絡方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パスワードリセット手順**：Login Page画面設計書にはパスワードリセット機能の詳細が記載されていない
  - 候補：APEXワークスペースの管理者設定 / システム管理者マニュアル / 未実装の可能性
- **サポート連絡方法**：連絡先情報が設計書に存在しない
  - 候補：プロジェクト固有の情報 / 導入先依存の情報
- **管理者権限の詳細機能**：administration_rightsスキームの詳細が未確認
  - 候補：APEX認可スキーム設定 / プロジェクト固有の実装

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: システム概要、画面構成、操作手順 - 画面設計書と一致
- **0（低リスク）**: 業務フロー - 業務要件一覧と整合
- **0（低リスク）**: エラーメッセージ - 画面設計書のメッセージ仕様と一致
- **1（中リスク）**: パスワードリセット手順 - 一般的な内容で記載、要確認
- **1（中リスク）**: サポート連絡方法 - 一般的な内容で記載、導入先で補完必要

## 6) レビュアーチェックリスト（最小）
- [ ] ログイン画面のURL形式がシステム固有の設定と一致しているか
- [ ] パスワードリセット手順が組織のポリシーと整合しているか
- [ ] サポート連絡先が実際の連絡先と一致しているか
- [ ] 管理者権限の範囲が実際の権限設定と一致しているか
- [ ] 業務フローがエンドユーザーの実際の業務と整合しているか
- [ ] エラーメッセージの文言が最新のシステムと一致しているか
