# QUASTO 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（Dashboard画面）](#3-トップページdashboard画面)

**【業務フローに沿った機能】**
4. [【STEP1】ルール定義・設定機能](#4-step1ルール定義設定機能)
5. [【STEP2-3】ユニットテスト生成・管理機能](#5-step2-3ユニットテスト生成管理機能)
6. [【STEP3-4】テスト実行・スケジューラ機能](#6-step3-4テスト実行スケジューラ機能)
7. [【STEP4-5】結果確認・分析機能](#7-step4-5結果確認分析機能)

**【サポート機能】**
8. [ルールファイル管理機能](#8-ルールファイル管理機能)
9. [テスト結果ファイル管理機能](#9-テスト結果ファイル管理機能)
10. [Region Plugin機能](#10-region-plugin機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 QUASTOとは

QUASTOは、Oracleデータベース内のコードガイドライン遵守と品質チェックを行うためのシステムです。データモデル、PL/SQLコード、データ自体の品質検証をサポートし、utPLSQLテストとOracle APEXフロントエンドを提供します。

品質管理担当者やデータベース開発者が、定義したルールに基づいてデータベースオブジェクトの品質を継続的にチェックし、問題を早期に発見・対処することを支援します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **品質ルール管理** | ルールの定義、編集、有効/無効設定、インポート/エクスポート |
| **テスト管理** | ユニットテストパッケージの生成、削除、手動実行、定期実行設定 |
| **品質監視** | テスト結果の確認、違反オブジェクトの特定、エラー分析 |
| **データ管理** | ルールファイル・テスト結果ファイルのインポート/エクスポート |

### 1.3 業務フロー概要

本システムにおける品質チェック業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------+
|                        品質チェック業務フロー                         |
+---------------------------------------------------------------------+
|                                                                     |
|  【STEP 1】管理者が品質チェックルールを定義・設定                    |
|      |                                                              |
|      v                                                              |
|  【STEP 2】ルールに基づいてユニットテストを生成                      |
|      |                                                              |
|      v                                                              |
|  【STEP 3】テストを手動実行または定期実行（スケジューラ）            |
|      |                                                              |
|      v                                                              |
|  【STEP 4】Dashboardでテスト結果を確認・分析                        |
|      |                                                              |
|      v                                                              |
|  【STEP 5】違反オブジェクトを特定し、修正対応を実施                  |
|                                                                     |
+---------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **品質管理者** | ルールの定義・管理、スケジューラ設定、テスト結果の監視・分析 |
| **データベース開発者** | テスト結果の確認、違反オブジェクトの修正、テストの手動実行 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| ルール管理 | 品質チェックルールの一覧表示、追加、編集、削除 | STEP 1 |
| ユニットテスト生成 | ルールに基づいてutPLSQLテストパッケージを自動生成 | STEP 2 |
| スケジューラ設定 | テストの定期実行をOracleスケジューラで管理 | STEP 3 |
| ダッシュボード | テスト結果をチャート・レポートで可視化 | STEP 4 |
| 違反オブジェクト詳細 | ルール違反オブジェクトの詳細情報を表示 | STEP 5 |
| ルールファイル管理 | JSON形式でのルールインポート/エクスポート | 随時利用 |
| テスト結果ファイル管理 | XML形式でのテスト結果インポート/エクスポート | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー | 認証済みユーザー。すべての画面にアクセス可能 |
| 管理者 | administration_rightsスキームによる追加権限を持つユーザー |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでQUASTOのログインページにアクセスします
   - URL例: `f?p=141:LOGIN`
2. ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| Username | APEXワークスペースで登録されているユーザー名 |
| Password | ユーザーに設定されたパスワード |
| Remember username | チェックすると次回ログイン時にユーザー名が保存されます |

3. 「Sign In」ボタンをクリックします
4. 認証に成功すると、Dashboard画面が表示されます

**注意点・Tips：**
- ユーザー名を入力してEnterキーを押すと、カーソルがパスワードフィールドに移動します
- パスワードを入力してEnterキーを押すと、ログインが実行されます
- ログイン情報を忘れた場合は、システム管理者にお問い合わせください

### 2.2 ログアウト方法

1. 画面右上のユーザーメニューアイコンをクリックします
2. 表示されるメニューから「Sign Out」を選択します
3. ログイン画面に戻ります

### 2.3 セッションタイムアウト

セッションが一定時間操作されない場合、自動的にログアウトされます。
再度ログインページにアクセスして認証を行ってください。

---

## 3. トップページ（Dashboard画面）

### 3.1 Dashboard画面の概要

ログイン成功後に表示されるメイン画面です。テスト実行結果を視覚的に表示し、品質状況を一元的に把握できます。

**アクセス方法：**
- ログイン成功後に自動遷移
- ナビゲーションメニューから「Dashboard」を選択
- URL: `f?p=141:DASHBOARD`

### 3.2 画面構成

#### 3.2.1 ファセット検索（左側パネル）

テスト結果をフィルタリングできます：

| フィルター項目 | 説明 |
|---------------|------|
| Search | フリーテキストで検索 |
| Categories | ルールカテゴリ（DDL/DML/APEX）でフィルタ |
| Clients/Projects | クライアント/プロジェクトでフィルタ |
| Schemes | スキーム名でフィルタ |
| Test Results | テスト結果（Success/Failure/Error）でフィルタ |
| Error Levels | エラーレベルでフィルタ |
| Dates | 実行日でフィルタ |

#### 3.2.2 Quota円グラフ

テスト結果の内訳を円グラフで表示します：
- **緑色（Success）**: テスト成功
- **赤色（Failure）**: テスト失敗（ルール違反検出）
- **オレンジ色（Error）**: テスト実行時エラー

#### 3.2.3 タイムラインチャート

過去10日間のテスト実行推移を折れ線グラフで表示します。
品質トレンドの把握や、リグレッションの早期発見に役立ちます。

#### 3.2.4 Test Executions Report

テスト実行結果の詳細一覧を表示します：

| カラム | 説明 |
|--------|------|
| Client Name | クライアント/プロジェクト名 |
| Date | 実行日 |
| Scheme Name | スキーム名 |
| Test Result | テスト結果（Success/Failure/Error） |
| Details | 違反オブジェクト詳細へのリンク |
| Restart | テスト再実行リンク |
| Category | ルールカテゴリ |
| Rule Name | ルール名 |
| Runtime Error | エラー詳細へのリンク（アイコン表示） |

### 3.3 Dashboard画面の操作

#### Config Scheduler Jobボタン

スケジューラー設定画面を開きます。定期実行の有効/無効設定や即時実行が可能です。

#### Test Result Filesボタン

テスト結果ファイル管理画面を開きます。XMLファイルのインポート/エクスポートが可能です。

#### Detailsリンク

テスト結果が「Failure」の場合、違反したオブジェクトの詳細を確認できます。

#### Runtime Errorアイコン

テスト結果が「Error」の場合、エラーの詳細（バックトレース）を確認できます。

#### Restartリンク

特定のテストを個別に再実行できます。

---

## 4. 【STEP1】ルール定義・設定機能

> **業務フローでの位置**: 管理者が品質チェックルールを定義・設定するステップです。

### 4.1 Rules画面にアクセスする

1. ナビゲーションメニューから「Rules」を選択します
2. ルール一覧画面が表示されます

### 4.2 ルール一覧を確認する

Rules画面では、定義されている全ルールが一覧表示されます：

| カラム | 説明 |
|--------|------|
| 編集アイコン | クリックでルール編集画面を開く |
| Client | クライアント/プロジェクト名 |
| Number | ルール番号 |
| Name | ルール名 |
| Category | カテゴリ（DDL/DML/APEX） |
| Layer | レイヤー |
| Error Level | エラーレベル |
| Active | 有効/無効状態 |
| Object Types | 対象オブジェクト種別 |

**検索・フィルター機能：**
- インタラクティブ・レポートの検索バーでキーワード検索
- カラムヘッダーをクリックしてソート
- 列の表示/非表示をカスタマイズ可能

### 4.3 新規ルールを作成する

1. 「Add Rule」ボタンをクリックします
2. Add/Edit Rule画面がモーダルダイアログで開きます
3. 以下の項目を入力します：

**左側入力項目：**

| 項目 | 必須 | 説明 |
|------|------|------|
| Rule Number | Yes | ルールを識別する番号（例: 1.1, 2.3） |
| Client Name | Yes | クライアント/プロジェクト名 |
| Name | Yes | ルール名（最大400文字） |
| Category | Yes | DDL/DML/APEXから選択 |
| Layer | Yes | レイヤーを選択 |
| Error Level | Yes | エラーレベルを選択 |
| Active | Yes | 有効/無効を設定（デフォルト: Yes） |
| Comment | No | コメント（最大4000文字） |
| Error Message | Yes | ルール違反時に表示するエラーメッセージ |
| Object Types | Yes | 対象オブジェクトタイプ（コロン区切り）<br>クイックピック: PROCESS, TABLE, VIEW, PACKAGE等 |
| Exclude Objects | No | 除外するオブジェクト（コロン区切り） |

**右側入力項目：**

| 項目 | 必須 | 説明 |
|------|------|------|
| SQL Statement | Yes | 品質チェック用SQLクエリ<br>品質基準を満たさないオブジェクトを返すように記述 |

4. 「Create」ボタンをクリックしてルールを保存します
5. ダイアログが閉じ、Rules画面が更新されます

### 4.4 既存ルールを編集する

1. Rules画面でルール行の編集アイコン（ペンシルアイコン）をクリックします
2. Add/Edit Rule画面がモーダルダイアログで開きます
3. 必要な項目を修正します
   - 注意: Rule NumberとClient Nameは編集できません
4. 「Save」ボタンをクリックして変更を保存します

### 4.5 ルールを削除する

1. 編集画面を開きます
2. 「Delete」ボタンをクリックします
3. 確認ダイアログで「OK」をクリックします

**注意点：**
- テスト結果が保存されているルールは削除できません
- 削除できない場合は、ルールを「Inactive」に設定してください

### 4.6 ルールの有効/無効を切り替える

1. 編集画面を開きます
2. 「Active」項目を「Yes」または「No」に変更します
3. 「Save」ボタンをクリックします

無効化されたルールはテスト実行の対象外となります。

---

## 5. 【STEP2-3】ユニットテスト生成・管理機能

> **業務フローでの位置**: 定義されたルールに基づいてユニットテストを生成するステップです。

### 5.1 Unit Test Generation画面にアクセスする

1. Rules画面の「Generate unit tests for Schemes」ボタンをクリックします
2. Unit Test Generation画面がモーダルダイアログで開きます

### 5.2 ユニットテストパッケージを生成する

1. 対象スキームを選択します
   - 「Scheme Names」シャトルで、左リストから右リストへスキームを移動
   - 全スキームを対象にする場合は全て右リストに移動
2. 生成オプションを選択します：

| オプション | 説明 |
|-----------|------|
| Single Package | 1つのパッケージに全ルールのテストを生成 |
| Single Package per Rule | ルールごとに別パッケージを生成 |

3. 「Create Unit Test Packages」ボタンをクリックします
4. テストパッケージが生成され、成功メッセージが表示されます

**生成されるパッケージ命名規則：**
- Single Package: `UT_{スキーム}_{クライアント}_PKG`
- Single Package per Rule: `UT_{スキーム}_{クライアント}_{ルール}_PKG`

### 5.3 ユニットテストパッケージを削除する

1. Unit Test Generation画面を開きます
2. 削除対象のスキームを選択します
3. 「Delete Unit Test Packages」ボタンをクリックします
4. 確認ダイアログで「OK」をクリックします

---

## 6. 【STEP3-4】テスト実行・スケジューラ機能

> **業務フローでの位置**: ユニットテストを手動実行または定期実行するステップです。

### 6.1 Config Scheduler Job画面にアクセスする

1. Dashboard画面の「Config Scheduler Job」ボタンをクリックします
2. Config Scheduler Job画面がモーダルダイアログで開きます

### 6.2 スケジューラ情報を確認する

画面上部に現在のスケジューラ状態が表示されます：

| 項目 | 説明 |
|------|------|
| First Start | 初回開始日時 |
| Last Start | 最終実行日時 |
| Last Duration | 最終実行時間 |
| Next Run | 次回実行予定日時 |
| Repeat Interval | 繰り返し間隔 |
| Job State | ジョブ状態 |

### 6.3 定期実行を有効/無効にする

1. 「Enable schedule for Cronjob」を「Yes」または「No」に設定します
2. 「Save」ボタンをクリックします

### 6.4 テストを即時実行する

1. 「Run Cronjob Now」ボタンをクリックします
2. テストが開始され、「Cronjob started.」メッセージが表示されます
3. テスト実行中は「Cronjob is running...」ボタンが表示されます
4. 「Refresh」ボタンで画面を更新して最新状態を確認できます

### 6.5 実行履歴を確認する

画面下部の「Job History」リージョンで過去の実行履歴を確認できます：

| カラム | 説明 |
|--------|------|
| Log Date | 実行日時 |
| Job Execution Status | 実行ステータス |
| Error Code | エラーコード |
| Errors | エラー詳細 |
| Run Duration | 実行時間 |

### 6.6 個別テストを再実行する

1. Dashboard画面のTest Executions Reportで対象行を見つけます
2. 「Restart」リンクをクリックします
3. Restart Unit Test画面がモーダルダイアログで開きます
4. 「Run」ボタンをクリックしてテストを再実行します

---

## 7. 【STEP4-5】結果確認・分析機能

> **業務フローでの位置**: テスト結果を確認し、違反オブジェクトを特定・修正するステップです。

### 7.1 テスト結果を確認する

Dashboard画面で以下の情報を確認できます：

1. **Quota円グラフ**: 全体的な成功/失敗/エラーの割合
2. **タイムラインチャート**: 過去10日間の品質トレンド
3. **Test Executions Report**: 個別テスト結果の詳細

### 7.2 違反オブジェクトを確認する

テスト結果が「Failure」の場合：

1. Test Executions Reportの「Details」リンクをクリックします
2. Invalid Objects画面がモーダルダイアログで開きます
3. 違反オブジェクト一覧が表示されます：

| カラム | 説明 |
|--------|------|
| Object | 違反オブジェクトの名前 |
| Details | オブジェクトの詳細情報（位置、属性など） |

4. CSVダウンロード機能でレポートを出力できます

### 7.3 ランタイムエラーを確認する

テスト結果が「Error」の場合：

1. Test Executions Reportのランタイムエラーアイコンをクリックします
2. Runtime Error画面がモーダルダイアログで開きます
3. エラーの詳細情報が表示されます：
   - エラーメッセージ（SQLERRM）
   - エラーバックトレース（スタックトレース）

### 7.4 フィルターで結果を絞り込む

Dashboard画面のファセット検索を使用して結果を絞り込みます：

1. 左側パネルのフィルター項目をチェック
2. 複数のフィルターを組み合わせて検索可能
3. フリーテキスト検索で任意のキーワードを検索

---

## 8. ルールファイル管理機能

### 8.1 Rule Files画面にアクセスする

1. Rules画面の「Rule Files」ボタンをクリックします
2. Rule Files画面がモーダルダイアログで開きます

### 8.2 ルールをエクスポートする

1. 「Export Rules」リージョンを展開します
2. クライアント名の一覧が表示されます
3. エクスポートしたいクライアントの「Download」リンクをクリックします
4. JSONファイルがダウンロードされます

**ファイル名形式：** `export_rules_{クライアント名}_{日時}.json`

### 8.3 ルールをインポートする

1. 「Import Rules」リージョンを展開します
2. JSONファイルをドラッグ&ドロップ、またはクリックして選択します
   - 許可されるファイル形式: `.json`
3. 「Import」ボタンをクリックします
4. 「File imported.」メッセージが表示されます

**注意点：**
- インポート時に既存ルールと重複する場合、インポートデータで上書きされる可能性があります
- インポート前にバックアップを取ることを推奨します

---

## 9. テスト結果ファイル管理機能

### 9.1 Test Result Files画面にアクセスする

1. Dashboard画面の「Test Result Files」ボタンをクリックします
2. Test Result Files画面がモーダルダイアログで開きます

### 9.2 テスト結果をエクスポートする

1. 「Export Test Results」リージョンを展開します
2. テスト結果の一覧が表示されます
3. エクスポートしたい結果の「Download」リンクをクリックします
4. XMLファイルがダウンロードされます

**ファイル名形式：** `export_unit_test_results_{日時}.xml`

### 9.3 テスト結果をインポートする

1. 「Import Test Results」リージョンを展開します
2. XMLファイルをドラッグ&ドロップ、またはクリックして選択します
   - 許可されるファイル形式: `.xml`
3. 「Import」ボタンをクリックします
4. 「File imported.」メッセージが表示されます

---

## 10. Region Plugin機能

### 10.1 Region Plugin画面にアクセスする

1. ナビゲーションメニューから「Region Plugin」を選択します
2. Region Plugin画面が表示されます

### 10.2 プラグインを使用する

Region Plugin画面では、QUASTOリージョンプラグインの動作を確認できます：

1. アプリケーションを選択します
2. ページを選択します
3. ルールを選択します（任意）
4. 選択した条件でルール実行結果が表示されます

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
品質チェック業務フロー概要（再掲）
====================================================================
【STEP 1】管理者が品質チェックルールを定義・設定 -> 4章参照
    |
    v
【STEP 2】ルールに基づいてユニットテストを生成 -> 5章参照
    |
    v
【STEP 3】テストを手動実行または定期実行 -> 6章参照
    |
    v
【STEP 4】Dashboardでテスト結果を確認・分析 -> 7章参照
    |
    v
【STEP 5】違反オブジェクトを特定し、修正対応を実施 -> 7章参照
====================================================================
```

### 11.1 【品質管理者】初期セットアップ業務

新規プロジェクト開始時に以下の作業を行います：

1. **ルールの定義**
   - Rules画面で「Add Rule」からルールを新規作成
   - または、Rule Files画面で既存ルールをインポート

2. **ユニットテストの生成**
   - Unit Test Generation画面でテストパッケージを生成

3. **スケジューラの設定**
   - Config Scheduler Job画面で定期実行を有効化

### 11.2 【品質管理者】定期監視業務

毎日または週次で以下の作業を行います：

1. **Dashboardで品質状況を確認**
   - タイムラインチャートで品質トレンドをチェック
   - Quota円グラフで成功/失敗/エラーの比率を確認

2. **問題のある結果を詳細確認**
   - Failureの「Details」で違反オブジェクトを確認
   - Errorの「Runtime Error」でエラー原因を確認

3. **開発チームへの報告**
   - 違反オブジェクトをCSVエクスポートして共有

### 11.3 【開発者】修正作業業務

品質違反が検出された場合に以下の作業を行います：

1. **違反内容の確認**
   - Dashboard画面で自分のスキーム/プロジェクトをフィルタ
   - Invalid Objects画面で違反オブジェクトを特定

2. **コード修正**
   - 違反オブジェクトのソースコードを修正

3. **再テスト**
   - Restart機能で個別テストを再実行
   - または次回の定期テストを待つ

### 11.4 【品質管理者】環境移行業務

テスト環境から本番環境への移行時に以下の作業を行います：

1. **ルールのエクスポート**
   - Rule Files画面でルールをJSONエクスポート

2. **本番環境へのインポート**
   - 本番環境のRule Files画面でJSONインポート

3. **ユニットテストの再生成**
   - Unit Test Generation画面でテストパッケージを生成

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
- ユーザー名とパスワードが正しいか
- Caps Lockがオフになっているか
- ブラウザのCookieが有効になっているか
- 問題が解決しない場合はシステム管理者に連絡してください

**Q: パスワードを忘れました**

A: システム管理者に連絡して、パスワードのリセットを依頼してください。

### 12.2 ルール管理に関するQ&A

**Q: ルールを削除できません**

A: テスト結果が保存されているルールは削除できません。
- ルールの「Active」を「No」に設定して無効化してください
- または、テスト結果を削除してからルールを削除してください

**Q: ルールのSQL文の書き方がわかりません**

A: SQLは「品質基準を満たさないオブジェクトを返す」ように記述します。
- クエリの結果が0件 = テスト成功（違反なし）
- クエリの結果が1件以上 = テスト失敗（違反あり）

### 12.3 テスト実行に関するQ&A

**Q: テストパッケージを生成したがテストが実行されません**

A: 以下を確認してください：
- ルールが「Active」になっているか
- スケジューラが有効になっているか（定期実行の場合）
- 「Run Cronjob Now」で手動実行を試してください

**Q: テスト結果がすべてErrorになります**

A: ルールのSQL文に構文エラーがある可能性があります。
- Runtime Error画面でエラー詳細を確認してください
- SQL文を見直し、修正してください

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Invalid Login Credentials | ユーザー名またはパスワードが不正 | 正しい認証情報を入力してください |
| The Rule has saved test results and therefore cannot be deleted | テスト結果が存在するルールの削除試行 | ルールを「Inactive」に設定するか、テスト結果を削除してください |
| Rulenumber already exists for this client | 同一クライアントで重複するルール番号 | 別のルール番号を指定してください |
| Invalid MIME type of json file | JSON以外のファイル形式でのインポート試行 | 正しい.jsonファイルを選択してください |
| Invalid MIME type of xml file | XML以外のファイル形式でのインポート試行 | 正しい.xmlファイルを選択してください |
| No rules defined | ルールが未定義の状態でテスト生成を試行 | 先にルールを定義してください |

### 13.2 よくあるトラブルと解決方法

**トラブル: ダッシュボードのチャートが表示されない**

解決方法：
1. ブラウザをリロードしてください
2. ファセット検索のフィルターをクリアしてください
3. テスト結果データが存在するか確認してください

**トラブル: ファイルのアップロードに失敗する**

解決方法：
1. ファイル形式が正しいか確認（JSONまたはXML）
2. ファイルサイズが制限内か確認
3. ブラウザをリロードして再試行

**トラブル: スケジューラジョブが実行されない**

解決方法：
1. Config Scheduler Job画面で「Enable schedule for Cronjob」が「Yes」になっているか確認
2. Job Stateが「RUNNING」でないことを確認
3. 「Run Cronjob Now」で手動実行を試行

### 13.3 サポートへの連絡方法

システムの問題が解決しない場合は、以下の情報を添えてシステム管理者に連絡してください：

1. 発生した問題の詳細説明
2. エラーメッセージ（表示された場合）
3. 問題が発生した画面名
4. 問題発生日時
5. 実行した操作の手順

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-22 | 初版作成 |

---

*本マニュアルは、QUASTOのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
