---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 33
  claims_with_evidence: 28
  claims_without_evidence: 5
confidence_derived: 0.85
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：28 / 33、根拠なし：5
- 優先レビュー（高）
  1. **NFT-003 同時ルール実行処理**：同時処理数の具体的な要件定義なし
  2. **NFT-026 大規模スキーマ対応**：許容時間の具体的定義なし
  3. **NFT-027 大量ルール対応**：許容時間の具体的定義なし
  4. **NFT-028 複数ユーザー同時利用**：具体的なSLA定義なし
  5. **NFT-015 Cookieセキュリティ**：セキュア設定が無効（p_use_secure_cookie_yn='N'）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理メインパッケージ
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` - ユニットテスト生成・実行
- E-04: `src/plsql/pkg/qa_logger_pkg.sql` - ロギング機能
- E-05: `src/plsql/pkg/qa_utils_pkg.sql` - ユーティリティ関数
- E-06: `src/ddl/tab/qa_rules.sql` - ルールテーブル定義
- E-07: `src/apex/f141/application/shared_components/security/authentications/oracle_apex_accounts.sql` - APEX認証設定
- E-08: `src/apex/f141/application/shared_components/security/authentications/opendoor.sql` - OpenDoor認証（開発用）
- E-09: `src/apex/f141/application/shared_components/security/authorizations/administration_rights.sql` - 管理者認可スキーム
- E-10: `src/apex/f141/application/create_application.sql` - APEXアプリケーション設定
- E-11: `README.md` - プロジェクト概要・インストール手順
- E-12: `install.sql` - インストールスクリプト
- E-13: `uninstall.sql` - アンインストールスクリプト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: ルール実行レスポンス時間測定 | E-01 (tf_run_rule関数の存在確認) | ○ |
| C-02 | NFT-002: 複数ルール一括実行 | E-01 (tf_run_rules関数の存在確認) | ○ |
| C-03 | NFT-003: 同時ルール実行処理 | **根拠なし** | △ |
| C-04 | NFT-004: 大量ルール登録時の性能 | E-06 (QA_RULESテーブル定義) | ○ |
| C-05 | NFT-005: ユニットテスト一括実行 | E-03 (f_run_all_unit_tests関数) | ○ |
| C-06 | NFT-006: データベース再起動後の動作 | E-11 (Oracle 19c以上の前提) | ○ |
| C-07 | NFT-007: 不正ルール番号指定時のエラー | E-01, E-02 (例外処理実装確認) | ○ |
| C-08 | NFT-008: NULL入力時のエラー処理 | E-01, E-02 (入力検証コード確認) | ○ |
| C-09 | NFT-009: ログ出力機能 | E-04 (qa_logger_pkg実装) | ○ |
| C-10 | NFT-010: APEX認証機能 | E-07 (NATIVE_APEX_ACCOUNTS設定) | ○ |
| C-11 | NFT-011: 管理者権限チェック | E-09 (Administration Rights認可) | ○ |
| C-12 | NFT-012: SQLインジェクション対策 | E-01 (バインド変数使用確認) | ○ |
| C-13 | NFT-013: スキーマブラックリスト | E-02 (f_is_owner_black_listed関数) | ○ |
| C-14 | NFT-014: チェックサム設定 | E-10 (p_checksum_salt, p_bookmark_checksum_function) | ○ |
| C-15 | NFT-015: Cookieセキュリティ | E-07 (p_use_secure_cookie_yn='N'で要確認) | △ |
| C-16 | NFT-016: Oracle 19c互換性 | E-11 (README記載) | ○ |
| C-17 | NFT-017: Oracle APEX 24.1互換性 | E-10 (p_release='24.1.5') | ○ |
| C-18 | NFT-018: utPLSQL連携 | E-03, E-11 (utPLSQL連携コード) | ○ |
| C-19 | NFT-019: Logger連携 | E-04 (Logger統合コード) | ○ |
| C-20 | NFT-020: クリーンインストール | E-11, E-12 (インストール手順記載) | ○ |
| C-21 | NFT-021: バージョンアップグレード | E-11 (自動バージョン検出記載) | ○ |
| C-22 | NFT-022: 完全アンインストール | E-11, E-13 (アンインストール手順) | ○ |
| C-23 | NFT-023: ルールエクスポート | E-11 (export_rules_to_file.sql記載) | ○ |
| C-24 | NFT-024: ルールインポート | E-11 (import_file_to_rules.js記載) | ○ |
| C-25 | NFT-025: テスト結果XML出力 | E-03 (f_export_test_result関数) | ○ |
| C-26 | NFT-026: 大規模スキーマ対応 | **根拠なし** | △ |
| C-27 | NFT-027: 大量ルール対応 | **根拠なし** | △ |
| C-28 | NFT-028: 複数ユーザー同時利用 | **根拠なし** | △ |
| C-29 | NFT-029: スケジューラ定期実行 | E-03 (p_enable_scheduler_cronjob) | ○ |
| C-30 | NFT-030: ジョブ状態監視 | E-03 (f_is_job_running関数) | ○ |
| C-31 | NFT-031: ルール循環検出 | E-02 (f_check_for_loop関数) | ○ |
| C-32 | NFT-032: 自律トランザクション | E-03 (pragma autonomous_transaction) | ○ |
| C-33 | NFT-033: 結果キャッシュ | E-02 (result_cache句) | ○ |

## 4) 不足情報（Unknown / Missing）

- **同時処理数・スケーラビリティの要件定義**
  - コードからは同時実行制御の明示的な制限は確認できず
  - 候補：性能要件定義書 / SLA定義書 / 運用設計書

- **許容レスポンス時間の定義**
  - 具体的な数値基準がドキュメントに記載なし
  - 候補：非機能要件定義書 / SLA定義書

- **Cookieセキュリティ設定の意図**
  - p_use_secure_cookie_yn='N'の設定理由が不明
  - 候補：セキュリティ設計書 / 開発環境設定ガイド

## 5) リスクフラグ（レビュー観点）

- **1: 中リスク** - NFT-015（Cookieセキュリティ）
  - セキュアCookieが無効に設定されている。本番環境では有効化を検討

- **1: 中リスク** - NFT-003, NFT-026-028（スケーラビリティ関連）
  - 具体的な性能要件が定義されていないため、テスト基準の妥当性を検証必要

- **0: 低リスク** - その他のテストケース
  - コードベースから明確な根拠が確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] 性能テストケース（NFT-001〜005）のレスポンス基準値は妥当か
- [ ] セキュリティテストケース（NFT-010〜015）で本番環境の設定を考慮しているか
- [ ] スケーラビリティテストケース（NFT-026〜028）の許容時間を定義する必要があるか
- [ ] opendoor認証（E-08）は開発専用で本番では無効化されているか確認
- [ ] Oracle 19c以上の要件（NFT-016）は現行環境と整合しているか
- [ ] utPLSQL/Logger統合（NFT-018〜019）はオプション機能として明記されているか
