---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 38
  claims_without_evidence: 7
confidence_derived: 0.84
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：38 / 45、根拠なし：7
- 優先レビュー（高）
  1. **レスポンスタイム目標値**：コードから具体的な数値が確認できない（推定値）
  2. **稼働率目標値**：明示的な要件定義が存在しない
  3. **RTO/RPO目標値**：明示的な要件定義が存在しない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_api_pkg.sql` - APIパッケージ（tf_run_rule, tf_run_rules）
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - メインパッケージ（authid definer, ループ検出等）
- E-03: `src/plsql/pkg/qa_logger_pkg.sql` - ロガーパッケージ（ログ機能、フォーマット）
- E-04: `src/plsql/pkg/qa_utils_pkg.sql` - ユーティリティパッケージ（deterministic関数）
- E-05: `src/ddl/tab/qa_rules.sql` - ルールテーブル定義（カラムコメント含む）
- E-06: `src/ddl/tab/qa_test_runs.sql` - テスト実行テーブル定義
- E-07: `src/scripts/install_constant_package.sql` - 定数パッケージ生成スクリプト
- E-08: `src/scripts/create_scheduler_job_for_unit_tests.sql` - スケジューラジョブ定義
- E-09: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - ブラックリストビュー
- E-10: `src/apex/f141/application/shared_components/security/authentications/oracle_apex_accounts.sql` - APEX認証設定
- E-11: `src/install_objects.sql` - インストールスクリプト
- E-12: `README.md` - プロジェクト説明（Oracle 19c要件、utPLSQL等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tf_run_rule関数が存在する | E-01 | ○ |
| C-02 | tf_run_rules関数が存在する | E-01 | ○ |
| C-03 | レスポンスタイム目標値（10秒以内等） | **根拠なし** | △ |
| C-04 | スループットはAPEX標準に依存 | E-10 | ○ |
| C-05 | ルールは順次実行される | E-01, E-02 | ○ |
| C-06 | 稼働率99.5%目標 | **根拠なし** | △ |
| C-07 | RTO 2時間以内 | **根拠なし** | △ |
| C-08 | RPOはバックアップ時点に依存 | E-11, E-12 | ○ |
| C-09 | Oracle APEX Accounts認証を使用 | E-10 | ○ |
| C-10 | APEX管理者ロールによる権限制御 | E-12 | ○ |
| C-11 | 最小権限でのスキーマ権限 | E-12 | ○ |
| C-12 | ブラックリストビューによるスキーマ制御 | E-09 | ○ |
| C-13 | システムスキーマ自動除外 | E-09 | ○ |
| C-14 | DEFINER権限でのパッケージ制御 | E-02, E-03 | ○ |
| C-15 | CURRENT_USER権限でのAPI制御 | E-01 | ○ |
| C-16 | NULLパラメータチェック実装 | E-01, E-02 | ○ |
| C-17 | ループ検出機能 | E-02 | ○ |
| C-18 | カスタム例外によるエラーハンドリング | E-02 | ○ |
| C-19 | utPLSQLフラグによる機能切替 | E-07 | ○ |
| C-20 | APEXフラグによる機能切替 | E-07 | ○ |
| C-21 | Loggerフラグによる機能切替 | E-07 | ○ |
| C-22 | 条件付きコンパイル使用 | E-01, E-03 | ○ |
| C-23 | Oracle 19c以上対応 | E-12 | ○ |
| C-24 | APEX 24.1.5対応 | E-10 | ○ |
| C-25 | QA_RULESへのカスタムルール定義 | E-05 | ○ |
| C-26 | DDL/APEX/DATAの3カテゴリ | E-05 | ○ |
| C-27 | エラーレベル3段階 | E-05 | ○ |
| C-28 | 前提条件チェーン機能 | E-02, E-05 | ○ |
| C-29 | OraOpenSource Logger統合 | E-03, E-12 | ○ |
| C-30 | logger_logsテーブル使用 | E-12 | ○ |
| C-31 | 詳細パラメータトレース | E-03 | ○ |
| C-32 | 日付フォーマット定義 | E-03 | ○ |
| C-33 | WHEN OTHERS例外でログ出力後re-raise | E-01, E-02, E-04 | ○ |
| C-34 | $$plsql_unitによるスコープ情報 | E-01, E-02 | ○ |
| C-35 | qa_constant_pkgによる設定一元管理 | E-07 | ○ |
| C-36 | バージョン定数（24.1） | E-07, E-11 | ○ |
| C-37 | Result Cache使用 | E-02 | ○ |
| C-38 | Deterministic関数使用 | E-04 | ○ |
| C-39 | テーブル・カラムコメント | E-05, E-06 | ○ |
| C-40 | CRONJOB_RUN_UNIT_TESTS定義 | E-08 | ○ |
| C-41 | QA_TEST_RUNSによる結果永続化 | E-06 | ○ |
| C-42 | ルールエクスポート機能 | E-12 | ○ |
| C-43 | ルールインポート機能 | E-12 | ○ |
| C-44 | install.sql一括インストール | E-11 | ○ |
| C-45 | リコンパイルスクリプト | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- **レスポンスタイム目標値（C-03）**: コード内に明示的なタイムアウト設定や性能目標の記述がない
  - 候補：運用実績データ / 性能テスト結果 / SLA文書
- **稼働率目標（C-06）**: 明示的な可用性要件の定義がない
  - 候補：SLA文書 / 運用要件定義書 / インフラ設計書
- **RTO/RPO目標（C-07）**: 災害復旧に関する明示的な要件定義がない
  - 候補：災害復旧計画書 / バックアップ運用手順書

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 性能要件の目標値は実測データに基づく検証が必要
- **1（中リスク）**: 可用性要件はインフラ構成に依存するため、実環境での確認が必要
- **0（低リスク）**: セキュリティ要件はコードから十分に確認可能
- **0（低リスク）**: 保守性要件はコード実装から確認済み
- **0（低リスク）**: 運用要件はスクリプト・テーブル定義から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件の目標値が実運用に即しているか確認
- [ ] 可用性要件がインフラ構成と整合しているか確認
- [ ] セキュリティ要件がセキュリティポリシーに準拠しているか確認
- [ ] ログ出力レベルが運用要件を満たしているか確認
- [ ] スケジューラジョブの実行間隔が適切か確認
- [ ] Oracle 19c以外のバージョンでの動作確認要否を判断
