# 非機能要件定義書

## 概要

本ドキュメントは、QUASTO（Quality Assurance Tool for Oracle databases）の非機能要件を定義するものです。QUASTOはOracleデータベース向けの品質保証ツールであり、データモデル、PL/SQLコード、データ自体のガイドラインと品質チェックを実施します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 単一ルール実行（tf_run_rule） | 10秒以内 | ルールの複雑さとスキーマサイズに依存 |
| 全ルール実行（tf_run_rules） | 60秒以内 | クライアント単位での全ルール実行時 |
| APEX画面表示 | 3秒以内 | Oracle APEXフロントエンド使用時 |
| ユニットテスト実行 | 120秒以内 | 全ユニットテストパッケージ実行時 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | Oracle APEX標準に準拠 | APEX認証機能による制御 |
| 秒間リクエスト数 | Oracle APEX標準に準拠 | APEX認証機能による制御 |
| ルール同時実行数 | 1 | ルールは順次実行（predecessor順序に従う） |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 99.5% | Oracleデータベースの可用性に依存 |
| 計画停止時間 | データベースメンテナンス時間に準ずる | Oracle 19c以上必須 |
| 障害復旧時間（RTO） | 2時間以内 | インストールスクリプトによる再構築可能 |
| 目標復旧時点（RPO） | QA_RULESテーブルのバックアップ時点 | JSONエクスポート機能でルール退避可能 |

## セキュリティ要件

### 認証・認可

- **認証方式**: Oracle APEX Accountsによるネイティブ認証（`NATIVE_APEX_ACCOUNTS`）
- **管理者権限**: APEX管理者ロール（`APEX_ADMINISTRATOR_ROLE`）による権限制御
- **スキーマ権限**: 以下の最小権限で動作
  - `CREATE PROCEDURE`
  - `CREATE SYNONYM`
  - `CREATE SEQUENCE`
  - `CREATE TABLE`
  - `CREATE TRIGGER`
  - `CREATE TYPE`
  - `CREATE VIEW`
  - `CREATE JOB`
  - `CREATE SESSION`

### アクセス制御

- **ブラックリストビュー**: `qa_scheme_names_for_testing_v`によるテスト対象スキーマの制御
- **Oracleシステムスキーマ除外**: SYS、SYSTEM、APEX_xxxxx等のシステムスキーマを自動除外
- **APEXアプリケーション除外**: `qa_apex_blacklisted_apps_v`によるAPEXアプリケーション除外機能
- **DEFINER権限**: `authid definer`によるパッケージ権限制御（qa_main_pkg、qa_logger_pkg、qa_constant_pkg）
- **CURRENT_USER権限**: `authid current_user`によるAPI権限制御（qa_api_pkg）

### 入力検証

- **NULLパラメータチェック**: 必須パラメータのNULLチェック実装
- **ループ検出**: 前提条件ルールの循環参照検出（`f_check_for_loop`）
- **例外処理**: カスタム例外による適切なエラーハンドリング

## 拡張性要件

### モジュール構成

- **utPLSQL統合**: フラグ（`gc_utplsql_flag`）によるutPLSQL機能の有効化/無効化
- **APEX統合**: フラグ（`gc_apex_flag`）によるAPEX機能の有効化/無効化
- **Logger統合**: フラグ（`gc_logger_flag`）によるLogger機能の有効化/無効化
- **条件付きコンパイル**: `$IF/$THEN/$ELSE/$END`ディレクティブによる機能切り替え

### データベース互換性

- **対象データベース**: Oracle 19c以上
- **APEX互換性**: Oracle APEX 24.1.5対応

### ルール拡張性

- **カスタムルール定義**: QA_RULESテーブルへのSQL定義による自由なルール追加
- **カテゴリ分類**: DDL、APEX、DATAの3カテゴリでルール分類
- **エラーレベル**: 1（Error）、2（Warning）、4（Info）の3段階
- **前提条件チェーン**: `qaru_predecessor_ids`によるルール実行順序制御

## 保守性要件

### ログ機能

- **Loggerフレームワーク統合**: OraOpenSource Logger（オプション）
- **ログテーブル**: `logger_logs`、`logger_logs_5_min`、`logger_logs_60_min`
- **パラメータログ**: `qa_logger_pkg`による詳細なパラメータトレース
- **日付フォーマット**: `DD-MON-YYYY HH24:MI:SS:FF`形式

### エラーハンドリング

- **例外ログ出力**: 全パッケージで`WHEN OTHERS`例外をログ出力後に再raise
- **スコープ情報**: `$$plsql_unit`による呼び出し元特定
- **パラメータダンプ**: エラー発生時の入力パラメータ値を記録

### バージョン管理

- **定数パッケージ**: `qa_constant_pkg`による設定値の一元管理
- **バージョン定数**: `gc_quasto_version`によるバージョン管理（現行: 24.1）
- **アップグレードスクリプト**: `install.sql`による自動バージョン検出とアップグレード

### コード品質

- **Result Cache**: `f_get_excluded_objects`等でOracle Result Cacheを活用
- **Deterministic関数**: ユーティリティ関数でdeterministic修飾子を使用
- **コメント**: テーブル・カラムへのコメント付与

## 運用・監視要件

### ジョブスケジューリング

| ジョブ名 | 実行タイミング | 処理内容 |
| --- | --- | --- |
| CRONJOB_RUN_UNIT_TESTS | 毎日実行（FREQ=DAILY） | 全ユニットテストの自動実行 |
| JOB_RUN_UNIT_TEST | 手動/オンデマンド | 単一ユニットテストの実行 |

### テスト結果管理

- **テスト実行履歴**: `QA_TEST_RUNS`テーブルに結果を永続化
- **実行エラー情報**: `QATR_RUNTIME_ERROR`カラムにバックトレース情報を保存
- **無効オブジェクト追跡**: `QA_TEST_RUN_INVALID_OBJECTS`テーブルで詳細を管理
- **XML出力**: JUnit互換XMLフォーマットでテスト結果をエクスポート可能

### エクスポート・インポート

- **ルールエクスポート**: `export_rules_to_file.sql`によるJSON形式でのルール出力
- **ルールインポート**: `import_file_to_rules.js`（SQLcl必須）によるJSONからのインポート
- **インポートステージング**: `QA_IMPORT_FILES`テーブルによる段階的インポート

### インストール・アンインストール

- **インストール**: `install.sql`による一括インストール（引数4つ必須）
- **アンインストール**: `uninstall.sql`による完全削除
- **部分インストール**: `install_quasto_objects.sql`、`install_utplsql_objects.sql`、`install_apex_objects.sql`による個別インストール
- **リコンパイル**: `recompile_quasto_objects.sql`等による再コンパイルスクリプト

## 備考

### 前提条件

- Oracle Database 19c以上が必要
- Oracle APEXを使用する場合は、APEX 24.1以上を推奨
- utPLSQL統合を使用する場合は、utPLSQL 3.1.11以上を推奨
- Logger機能を使用する場合は、OraOpenSource Loggerの事前インストールが必要

### 制約事項

- ルールSQL長は最大32767文字
- 除外オブジェクトリストはコロン区切りで最大4000文字
- ブラックリストスキーマの変更は`qa_scheme_names_for_testing_v`ビューの修正が必要
