# API設計書

## 概要

本ドキュメントは、QuickerSite CMSのAPIエンドポイントを定義します。QuickerSiteはClassic ASP（VBScript）で構築されたコンテンツ管理システムであり、フロントエンド向けのページリクエスト処理と管理画面向けのバックエンド処理の両方を提供します。

## 共通仕様

### ベースURL

```
{サイトルート}/
```

例: `https://example.com/` または `https://example.com/quickersite/`

### 認証方式

QuickerSiteでは複数の認証方式を使用しています：

1. **セッションベース認証**（イントラネット/ユーザー認証）
   - Cookie + セッションによる認証
   - CSRFトークンによる保護

2. **ページパスワード認証**
   - 個別ページに対するパスワード保護
   - Cookieベースのパスワード記憶機能

3. **管理者認証**
   - 管理画面へのアクセスに必要
   - SHA256ハッシュによるパスワード保護

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Content-Type | - | text/html; charset=utf-8 または application/x-www-form-urlencoded |
| Cookie | - | セッションID、認証Cookie |

### 共通パラメータ

| パラメータ名 | 説明 |
| --- | --- |
| iId | 暗号化されたページID |
| pageAction | 実行するアクション種別 |
| QSSEC | CSRFトークン |
| item | リストアイテムの暗号化ID |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 200 | 正常（エラーメッセージはページ内に表示） |
| 302 | リダイレクト - 認証失敗時やアクション完了時 |
| 404 | Not Found - ページが存在しない場合 |
| 500 | Internal Server Error - サーバーエラー |

## API一覧

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| ページ表示 | /default.asp | GET | ページコンテンツ表示 |
| ページ表示 | /default.asp?pageAction=sitemap | GET | サイトマップ表示 |
| ページ表示 | /default.asp?pageAction=search | POST | サイト内検索 |
| ページ表示 | /default.asp?pageAction=showitem | GET | カタログアイテム表示 |
| ページ表示 | /default.asp?pageAction=showpost | GET | 投稿表示 |
| ページ表示 | /default.asp?pageAction=showpopup | GET | ポップアップ表示 |
| 認証 | /default.asp?pageAction=login | POST | ページパスワード認証 |
| 認証 | /default.asp?pageAction=loginIntranet | POST | イントラネットログイン |
| 認証 | /default.asp?pageAction=logoff | GET | ログアウト |
| 認証 | /default.asp?pageAction=forgotPW | POST | パスワードリセット |
| ユーザー管理 | /default.asp?pageAction=register | POST | 新規ユーザー登録 |
| ユーザー管理 | /default.asp?pageAction=profile | POST | プロフィール更新 |
| ユーザー管理 | /default.asp?pageAction=avataredit | POST | アバター管理 |
| コンテンツ | /default.asp?pageAction=catalog | POST | カタログ検索 |
| コンテンツ | /default.asp?pageAction=itemform | POST | カタログアイテムフォーム送信 |
| フォーム | /default.asp?pageAction=send | POST | フォーム送信 |
| 投票 | /default.asp?pageAction=vote | POST | 投票実行 |
| 投票 | /default.asp?pageAction=voteshowresults | GET | 投票結果表示 |
| 投票 | /default.asp?pageAction=voteshowballot | GET | 投票フォーム表示 |
| ニュースレター | /default.asp?pageAction=nlcatshowfb | POST | ニュースレター購読登録 |
| ニュースレター | /default.asp?pageAction=unsubscribe | GET | ニュースレター購読解除 |
| ゲストブック | /default.asp?pageAction=gbedit&ac=approve | GET | ゲストブックエントリー承認 |
| ゲストブック | /default.asp?pageAction=gbedit&ac=delete | GET | ゲストブックエントリー削除 |
| ゲストブック | /default.asp?pageAction=gbedit&ac=edit | GET | ゲストブックエントリー編集 |
| ファイル | /default.asp?pageAction=fileupload | POST | ファイルアップロード |
| フィード | /rss.asp | GET | RSSフィード出力 |
| サイトマップ | /sitemap.asp | GET | XMLサイトマップ出力 |
| メール | /mailPage.asp | POST | ページをメールで送信 |
| 画像 | /showThumb.aspx | GET | サムネイル画像生成 |

## 各APIエンドポイント定義

### ページ表示

#### 1. ページコンテンツ表示

ページIDに基づいてコンテンツを表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp` |
| 認証 | 不要（保護ページは認証必要） |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| iId | string | - | ホームページID | 暗号化されたページID |
| sCode | string | - | - | ページコード |
| item | string | - | - | リストアイテムの暗号化ID |
| fpv | string | - | - | プレビューモード（1でプレビュー有効） |
| iPostID | string | - | - | 投稿ID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

HTMLページが返却されます。テンプレートに基づいてレンダリングされたコンテンツが含まれます。

---

#### 2. サイト内検索

サイト内のコンテンツを検索します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=search` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| svalue | string | ○ | max:100 | 検索キーワード |
| bIntranet | boolean | - | - | イントラネット検索フラグ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

検索結果を含むHTMLページが返却されます。

---

#### 3. サイトマップ表示

HTMLサイトマップを表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=sitemap` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

サイトマップを含むHTMLページが返却されます。

---

#### 4. カタログアイテム表示

カタログアイテムの詳細を表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=showitem` |
| 認証 | 不要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| iItemID | string | ○ | - | 暗号化されたアイテムID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

カタログアイテムの詳細を含むHTMLページが返却されます。

---

### 認証

#### 5. ページパスワード認証

パスワード保護されたページにアクセスするための認証を行います。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=login` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| iId | string | ○ | - | 暗号化されたページID |
| sPw | string | ○ | max:15 | パスワード |

**レスポンス（成功時）**

ステータスコード: `302 Found`

認証成功後、対象ページにリダイレクトします。

**レスポンス（エラー時）**

ステータスコード: `200 OK`

エラーメッセージ「err_login」を含むログインフォームが表示されます。

---

#### 6. イントラネットログイン

イントラネットユーザーとしてログインします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=loginIntranet` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sEmail | string | ○ | max:50 | メールアドレスまたはニックネーム |
| sPw | string | ○ | max:20 | パスワード |
| captcha | string | ○ | max:4 | CAPTCHAコード |
| mode | string | - | mode1/mode2/mode3 | ログインモード |
| iId | string | - | - | 暗号化されたページID |
| item | string | - | - | リストアイテムID |
| iPostID | string | - | - | 投稿ID |

**レスポンス（成功時）**

ステータスコード: `302 Found`

認証成功後、対象ページにリダイレクトします。

**レスポンス（エラー時）**

ステータスコード: `200 OK`

```
エラーメッセージ: err_captcha または err_login
```

---

#### 7. ログアウト

現在のセッションからログアウトします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=logoff` |
| 認証 | 必要 |
| 権限 | ログイン済みユーザー |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| QSSEC | string | ○ | - | CSRFトークン |
| iId | string | - | - | リダイレクト先ページID |

**レスポンス（成功時）**

ステータスコード: `302 Found`

ログアウト後、指定ページまたはホームページにリダイレクトします。

---

#### 8. パスワードリセット

パスワードを忘れた場合にリセットメールを送信します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=forgotPW` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sEmail | string | ○ | email形式 | 登録メールアドレス |
| captcha | string | ○ | max:4 | CAPTCHAコード |

**レスポンス（成功時）**

ステータスコード: `302 Found`

リセットメール送信後、ログインページにリダイレクトします。メッセージ: `fb_emailFound`

**レスポンス（エラー時）**

ステータスコード: `200 OK`

```
エラーメッセージ: err_captcha または err_emailNotFound
```

---

### ユーザー管理

#### 9. 新規ユーザー登録

新規ユーザーアカウントを登録します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=register` |
| 認証 | 不要 |
| 権限 | なし（新規登録が許可されている場合のみ） |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sEmail | string | ○ | max:100, email形式 | メールアドレス |
| captcha | string | ○ | max:4 | CAPTCHAコード |
| QSSEC | string | ○ | - | CSRFトークン |

**レスポンス（成功時）**

ステータスコード: `302 Found`

登録成功後、アクティベーションメールが送信され、ログインページにリダイレクトします。メッセージ: `fb_activationlink`

---

#### 10. プロフィール更新

ユーザープロフィールを更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=profile` |
| 認証 | 必要（アクティベーションリンク経由またはログイン済み） |
| 権限 | 自分のプロフィールのみ |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sEmail | string | ○ | max:50, email形式 | メールアドレス |
| sPw | string | ○ | max:20 | パスワード |
| sNickName | string | ○ | max:50 | ニックネーム |
| bGetEmailsFromSite | boolean | - | - | プライベートメッセージ許可 |
| ac | string | - | - | アクティベーションチケット |
| btnaction | string | ○ | - | 保存アクション |
| QSSEC | string | ○ | - | CSRFトークン |
| [カスタムフィールド] | varies | - | - | 動的に定義されるコンタクトフィールド |

**レスポンス（成功時）**

ステータスコード: `200 OK` または `302 Found`

メッセージ: `fb_saveOK`

---

#### 11. アバター管理

ユーザーアバターをアップロード・削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=avataredit` |
| 認証 | 必要 |
| 権限 | 自分のアバターのみ（管理者は他ユーザーも可） |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| avatar | file | ○ | jpg/gif, max:500KB | アバター画像ファイル |
| iContactID | string | - | - | 暗号化されたコンタクトID |
| QSSEC | string | ○ | - | CSRFトークン |

**クエリパラメータ（削除時）**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| delete | string | ○ | - | true で削除 |
| iContactID | string | - | - | 暗号化されたコンタクトID |
| QSSEC | string | ○ | - | CSRFトークン |

---

### コンテンツ

#### 12. カタログ検索

カタログアイテムを検索・フィルタリングします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=catalog` |
| 認証 | 不要（保護ページは認証必要） |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| iID | string | ○ | - | 暗号化されたページID |
| sTitle | string | - | - | タイトル検索キーワード |
| pageSize | number | - | - | 1ページあたりの表示件数 |
| absolutepage | number | - | - | 現在のページ番号 |
| [カタログフィールド] | varies | - | - | 動的に定義される検索フィールド |

**レスポンス（成功時）**

ステータスコード: `200 OK`

カタログ検索結果を含むHTMLページが返却されます。

---

#### 13. カタログアイテムフォーム送信

カタログアイテムに関連付けられたフォームを送信します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=itemform` |
| 認証 | 不要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| iPageID | string | ○ | - | 暗号化されたページID |
| iItemID | string | ○ | - | 暗号化されたアイテムID |

**リクエストボディ（フォームデータ）**

フォーム定義に基づく動的フィールド

---

### 投票

#### 14. 投票実行

投票を実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=vote` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

投票フォームに基づく動的フィールド

**レスポンス（成功時）**

ステータスコード: `200 OK`

投票完了後、レスポンスを出力して終了します。

---

#### 15. 投票結果表示

投票結果をAJAXで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=voteshowresults` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

投票結果のHTMLフラグメントが返却されます。

---

#### 16. 投票フォーム表示

投票フォームをAJAXで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=voteshowballot` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

投票フォームのHTMLフラグメントが返却されます。

---

### ニュースレター

#### 17. ニュースレター購読登録

ニュースレターカテゴリに購読登録します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=nlcatshowfb` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

名前とメールアドレスを含むフォームデータ

**レスポンス（成功時）**

ステータスコード: `200 OK`

登録完了メッセージが返却されます。

---

#### 18. ニュースレター購読解除

ニュースレターの購読を解除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=unsubscribe` |
| 認証 | 不要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| e | string | ○ | - | 購読解除キー（24文字） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

購読解除完了メッセージが表示されます。

---

### ゲストブック

#### 19. ゲストブックエントリー承認

ゲストブックエントリーを承認します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=gbedit&ac=approve` |
| 認証 | 必要（キーベース認証） |
| 権限 | エントリーの管理権限 |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| sKey | string | ○ | - | エントリーキー |
| redPage | string | ○ | - | リダイレクト先ページID |

**レスポンス（成功時）**

ステータスコード: `302 Found`

承認後、指定ページにリダイレクトします。メッセージ: `fb_saveOK`

---

#### 20. ゲストブックエントリー削除

ゲストブックエントリーを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /default.asp?pageAction=gbedit&ac=delete` |
| 認証 | 必要（キーベース認証） |
| 権限 | エントリーの管理権限 |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| sKey | string | ○ | - | エントリーキー |
| redPage | string | ○ | - | リダイレクト先ページID |

**レスポンス（成功時）**

ステータスコード: `302 Found`

削除後、指定ページにリダイレクトします。メッセージ: `fb_topicremoved`

---

### ファイル管理

#### 21. ファイルアップロード

フォーラム投稿にファイルを添付します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /default.asp?pageAction=fileupload` |
| 認証 | 必要（イントラネット認証） |
| 権限 | ファイルアップロード許可設定 |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| iPostID | string | ○ | - | 暗号化された投稿ID |
| iThemeID | string | - | - | テーマID |
| RP | number | - | - | 返信フラグ |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| fup | file | ○ | max:5MB, 許可拡張子のみ | アップロードファイル |
| sFileDesc | string | - | max:50 | ファイル説明 |
| QSSEC | string | ○ | - | CSRFトークン |

**許可される拡張子**

jpg, png, doc, zip, rar, pdf, txt, mp3, xls, docx, xlsx, gif, css, rtf, wmv, mp4

**レスポンス（成功時）**

ステータスコード: `200 OK`

アップロード完了を示すJavaScriptが返却されます。

---

### フィード

#### 22. RSSフィード出力

ページまたはサイト全体のRSSフィードを出力します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /rss.asp` |
| 認証 | 不要（保護ページは除外） |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| iId | string | - | - | 暗号化されたページID（指定なしでサイト全体） |
| viewtype | string | - | - | ビュータイプ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `application/xml`

```xml
<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0">
  <channel>
    <title>サイト名</title>
    <link>サイトURL</link>
    <description>サイト説明</description>
    <item>
      <title>ページタイトル</title>
      <link>ページURL</link>
      <description>ページ内容</description>
      <pubDate>RFC822形式日時</pubDate>
      <author>作成者メール</author>
      <guid>ページURL</guid>
    </item>
  </channel>
</rss>
```

---

### サイトマップ

#### 23. XMLサイトマップ出力

検索エンジン用のXMLサイトマップを出力します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /sitemap.asp` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `application/xml`

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc>https://example.com/default.asp?iId=xxx</loc>
  </url>
</urlset>
```

---

### メール

#### 24. ページをメールで送信

現在のページの内容をメールで送信します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /mailPage.asp` |
| 認証 | 不要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| iId | string | ○ | - | 暗号化されたページID |

**リクエストボディ（フォームデータ）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sEmail | string | ○ | email形式 | 送信先メールアドレス |
| CAPTCHA | string | ○ | max:4 | CAPTCHAコード |
| btnAction | string | ○ | sendPage | アクション種別 |
| QSSEC | string | ○ | - | CSRFトークン |

**レスポンス（成功時）**

ステータスコード: `200 OK`

送信完了メッセージが表示されます。

**レスポンス（エラー時）**

ステータスコード: `200 OK`

```
エラーメッセージ: err_captcha または err_email
```

---

### 画像処理

#### 25. サムネイル画像生成

指定された画像のサムネイルを生成・返却します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /showThumb.aspx` |
| 認証 | 不要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| img | string | ○ | - | 画像の相対パス |
| maxSize | number | - | 0 | 最大サイズ（ピクセル、最大2560） |
| FH | number | - | - | 固定高さ |
| FW | number | - | - | 固定幅 |
| FSR | string | - | 0 | 正方形リサイズフラグ（1で正方形） |
| SE | string | - | - | 特殊効果（1:白黒、2:グレースケール、3:セピア） |
| close | string | - | - | ポップアップモード |
| getWidthOnly | string | - | - | 幅のみ取得（true） |
| pictureResizeSecCode | string | - | - | リサイズセキュリティコード |
| resizePictureToPx | number | - | - | リサイズ先ピクセル数 |
| autoClose | number | - | - | 自動クローズ秒数（ポップアップ時） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `image/jpeg` または `image/png`

リサイズ・加工された画像バイナリが返却されます。

---

## 備考

### セキュリティ対策

1. **CSRF保護**: フォーム送信時に `QSSEC` トークンを検証
2. **CAPTCHA**: ログイン・登録・メール送信時にCAPTCHA検証
3. **入力サニタイズ**: `sanitize()`, `quotRep()`, `cleanup()` 関数による入力値の無害化
4. **暗号化ID**: ページID・アイテムIDは暗号化されて送受信
5. **ファイルアップロード制限**: 拡張子・サイズの検証

### 禁止される拡張子（URLアクセス時）

php, log, exe, jsp, jspx, jws, config, py, pyc, pyd, wsgi, xml, svg, cfm, cfml, cgi, pl, pm, phtml, php3, php4, php5, php6, php7, js, bat, cmd, hta, scr, inc, pht, asa, asax, aspx, vbs, vbe, wsf, docm, xlsm, pptm, swf, xap, scf, resx, ico

### キャッシュ

- RSSフィードはアプリケーションレベルでキャッシュ
- サムネイル画像は15分間キャッシュ（OutputCache）

### 多言語対応

- `l()` 関数によるラベル多言語化
- `langCode` によるRSS言語設定
