---
generated_at: 2026-01-23 21:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのClaimに根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process.asp` - メインルーティング・アクション処理
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/begin.asp` - 初期化・セキュリティ設定
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_login.asp` - ページパスワード認証
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_loginIntranet.asp` - イントラネットログイン
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_forgotPW.asp` - パスワードリセット
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_register.asp` - ユーザー登録
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_profile.asp` - プロフィール更新
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_avatar.asp` - アバター管理
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_search.asp` - サイト内検索
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_sitemap.asp` - サイトマップ表示
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_catalog.asp` - カタログ検索
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_showitem.asp` - カタログアイテム表示
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_showpost.asp` - 投稿表示
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_itemform.asp` - カタログアイテムフォーム
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_fileupload.asp` - ファイルアップロード
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_unsubscribe.asp` - ニュースレター購読解除
- E-17: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/rss.asp` - RSSフィード出力
- E-18: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/sitemap.asp` - XMLサイトマップ出力
- E-19: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/mailPage.asp` - ページメール送信
- E-20: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/showThumb.aspx` - サムネイル画像生成
- E-21: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/default.asp` - メインエントリーポイント
- E-22: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/README.md` - プロジェクト説明
- E-23: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_listpage.asp` - リストページ処理
- E-24: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_editsite.asp` - サイト編集処理
- E-25: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/uploader214.asp` - ファイルアップローダー

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはClassic ASP（VBScript）で構築されたCMS | E-02, E-22 | ○ |
| C-02 | ページ表示エンドポイント `/default.asp` が存在 | E-01, E-21 | ○ |
| C-03 | pageAction=searchで検索機能を提供 | E-01, E-09 | ○ |
| C-04 | pageAction=sitemapでサイトマップ表示 | E-01, E-10 | ○ |
| C-05 | pageAction=showitemでカタログアイテム表示 | E-01, E-12 | ○ |
| C-06 | pageAction=showpostで投稿表示 | E-01, E-13 | ○ |
| C-07 | pageAction=loginでページパスワード認証 | E-01, E-03 | ○ |
| C-08 | pageAction=loginIntranetでイントラネットログイン | E-01, E-04 | ○ |
| C-09 | pageAction=logoffでログアウト（CSRF保護付き） | E-01 | ○ |
| C-10 | pageAction=forgotPWでパスワードリセット（CAPTCHA付き） | E-01, E-05 | ○ |
| C-11 | pageAction=registerで新規ユーザー登録（CAPTCHA付き） | E-01, E-06 | ○ |
| C-12 | pageAction=profileでプロフィール更新 | E-01, E-07 | ○ |
| C-13 | pageAction=avatareditでアバター管理 | E-01, E-08 | ○ |
| C-14 | pageAction=catalogでカタログ検索 | E-01, E-11 | ○ |
| C-15 | pageAction=itemformでカタログアイテムフォーム送信 | E-01, E-14 | ○ |
| C-16 | pageAction=voteで投票実行 | E-01 | ○ |
| C-17 | pageAction=voteshowresultsで投票結果表示 | E-01 | ○ |
| C-18 | pageAction=voteshowballotで投票フォーム表示 | E-01 | ○ |
| C-19 | pageAction=nlcatshowfbでニュースレター購読登録 | E-01 | ○ |
| C-20 | pageAction=unsubscribeでニュースレター購読解除 | E-01, E-16 | ○ |
| C-21 | pageAction=gbeditでゲストブック管理 | E-01 | ○ |
| C-22 | pageAction=fileuploadでファイルアップロード | E-01, E-15 | ○ |
| C-23 | /rss.aspでRSSフィード出力 | E-17 | ○ |
| C-24 | /sitemap.aspでXMLサイトマップ出力 | E-18 | ○ |
| C-25 | /showThumb.aspxでサムネイル画像生成 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）

- すべてのClaimに対して根拠が確認されたため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: すべてのAPIエンドポイントがソースコードから直接確認されており、信頼性が高い
- 以下の点については運用環境での確認を推奨：
  - 実際のベースURL設定（環境依存）
  - 管理画面（backsite）のAPIエンドポイント（本ドキュメントでは詳細を省略）

## 6) レビュアーチェックリスト（最小）

- [ ] pageAction一覧がprocess.aspのswitch文と一致しているか確認
- [ ] 各エンドポイントのパラメータ名がソースコードと一致しているか確認
- [ ] CSRF保護が必要なエンドポイントでQSSECトークンが記載されているか確認
- [ ] CAPTCHA保護が必要なエンドポイント（ログイン、登録、メール送信）が正しく記載されているか確認
- [ ] ファイルアップロードの許可拡張子リストがprocess_fileupload.aspと一致しているか確認
- [ ] showThumb.aspxの特殊効果オプション（SE=1,2,3）が正しく記載されているか確認
- [ ] 禁止拡張子リストがbegin.aspと一致しているか確認
