# QuickerSite

## 概要

QuickerSiteは、Windows Server（IIS）向けに構築されたオールインワンのCMS（コンテンツ管理システム）です。ASP/VBScriptで実装されており、IIS 5以降のWindows Serverおよび、IIS Express（Visual Studio Code、Visual Studio、WebMatrix等）を通じてほとんどのWindows OSバージョンで動作します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ページ管理 | コンテンツページの作成・編集・削除、階層構造メニュー管理 |
| テンプレートエンジン | カスタマイズ可能なHTMLテンプレート、テーマ機能、Artisteer対応 |
| メディア管理 | 画像アップロード、ギャラリー機能、サムネイル自動生成（ASPX利用） |
| フォーム管理 | カスタムフォーム作成、フォーム送信管理、エクセルエクスポート |
| カタログ/商品管理 | 商品カタログ、カスタムフィールド、ファイル添付 |
| ショッピングカート | Eコマース機能、カート管理、商品画像アップロード |
| ニュースレター | 購読者管理、メール配信、カテゴリ管理 |
| ユーザー管理 | 管理者認証、イントラネット機能、顧客管理 |
| ゲストブック | コメント・投稿機能 |
| ポール/投票 | アンケート作成・結果管理 |
| ポップアップ管理 | ポップアップウィンドウ作成・制御 |
| RSS/フィード | RSSフィード生成・管理 |
| 検索機能 | サイト内全文検索 |
| 多言語対応 | 多言語ラベル管理、言語切り替え |
| Cookie警告 | EU Cookie指令対応 |
| サイトマップ | 自動サイトマップ生成 |
| 統計機能 | アクセス統計、訪問者ログ |

## 技術スタック

### コア

- フレームワーク: Classic ASP
- 言語: VBScript
- Webサーバー: IIS 5以降 / IIS Express
- ランタイム: ASP.NET 2.0（サムネイル生成機能用）
- データベース: Microsoft Access (.mdb)
- 文字コード: UTF-8

### 主要ライブラリ

- jQuery 1.8.3: DOM操作、イベント処理
- jQuery UI: UIコンポーネント
- CKEditor 4.4.5: WYSIWYGエディタ
- CodeMirror 4.6.0: コードエディタ（HTML/CSS編集用）
- Colorbox: 画像Lightbox表示
- Nivo Slider: 画像スライダー
- Supersized: フルスクリーン背景スライドショー
- Uploadify 2.1.4: ファイルアップロード
- Date Picker: 日付選択UI
- SortTable: テーブルソート機能

## ディレクトリ構成

```
QuickerSite-master/
├── asp/                          # ASPソースファイル（メインロジック）
│   ├── includes/                 # 共通インクルードファイル
│   │   ├── functions.asp         # ユーティリティ関数
│   │   ├── database.asp          # データベース接続
│   │   ├── page.asp              # ページ管理クラス
│   │   ├── customer.asp          # 顧客管理
│   │   ├── form.asp              # フォーム処理
│   │   ├── catalog.asp           # カタログ管理
│   │   ├── newsletter.asp        # ニュースレター機能
│   │   └── ...                   # その他機能モジュール
│   ├── config/                   # 設定ファイル
│   │   ├── web_config.asp        # Web設定
│   │   └── rebrand.asp           # ブランディング設定
│   ├── codemirror/               # CodeMirrorライブラリ
│   ├── assetmanager/             # アセット管理
│   ├── bs_*.asp                  # バックエンド管理画面
│   ├── fs_*.asp                  # フロントエンド編集画面
│   ├── ad_*.asp                  # 管理者専用画面
│   ├── process_*.asp             # フォーム処理
│   └── begin.asp                 # 初期化・共通処理
├── backsite/                     # バックサイト用
├── backsiteTemplate31/           # 管理画面テンプレート
├── backsiteTemplateLogin31/      # ログインテンプレート
├── ckeditor445/                  # CKEditorライブラリ
├── common/                       # 共通リソース
├── cookiepolicy/                 # Cookie同意機能
├── css/                          # スタイルシート
├── db/                           # データベースファイル
│   ├── QuickerSite.mdb           # メインデータベース
│   └── QuickerLabels.mdb         # 多言語ラベルDB
├── fixedImages/                  # 固定画像
├── js/                           # JavaScriptライブラリ
│   ├── JQuery183.js              # jQuery
│   ├── JQueryUI.js               # jQuery UI
│   ├── ajax.js                   # AJAX処理
│   └── ...                       # その他JS
├── modules/                      # 拡張モジュール
├── templates/                    # ページテンプレート
├── UserFiles/                    # ユーザーアップロードファイル
├── default.asp                   # メインエントリーポイント
├── index.asp                     # インデックス（リダイレクト）
├── mailPage.asp                  # メール送信機能
├── printPage.asp                 # 印刷用ページ
├── rss.asp                       # RSSフィード
├── showThumb.aspx                # サムネイル生成
├── sitemap.asp                   # サイトマップ生成
└── web.config                    # IIS設定
```

## セットアップ

### 必要条件

- Windows Server（IIS 5以降）またはWindows OS（IIS Express）
- ASP.NET 2.0以降（サムネイル機能用）
- Microsoft Access Databaseエンジン（32bit版）

### インストール手順

1. プロジェクトファイルをIISウェブサイトのルートに配置
2. IUSRユーザーにフォルダ全体へのフルアクセス権限を付与
3. IISの既定ドキュメントに「default.asp」を設定
4. IISアプリケーションプールで32bit対応を有効化（Access DB使用のため）
5. ブラウザでサイトにアクセス
6. 初回アクセス時にパスワード入力を求められる（デフォルト: "admin"）
7. パスワードを変更して設定完了

### 設定ファイル

- `/asp/config/web_config.asp`: データベース接続、SMTP設定等
- `/asp/config/rebrand.asp`: ブランディング設定
- `/web.config`: IIS設定（404エラーハンドリング等）

## 開発

### コード規約

- VBScript: Option Explicit使用、明示的な変数宣言
- 文字コード: UTF-8（CODEPAGE="65001"）
- インクルードファイル: `<!-- #include file="..." -->` 形式

### 主要設定

```vbscript
' バージョン
const C_QS_VERSION = "4.4"

' 文字コード
const QS_CHARSET = "utf-8"

' エディタ
QS_EDITOR = 4  ' 4: CKEditor

' ASPX機能（サムネイル等）
QS_ASPX = true
```

### テスト

手動テスト環境:
1. IIS Expressで開発環境を構築
2. ブラウザで各機能を確認

### デモサイト

公式デモサイト: https://demo.quickersite.com/

### テンプレート作成

jstemplates.com (https://jstemplates.com/) を使用してレスポンシブWebデザインを生成し、QuickerSiteで利用可能です。

## ライセンス

MIT License

Copyright (c) 2020 Pieter Cooreman
