---
generated_at: 2026-01-23 21:35:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **ASP.NET 2.0必要条件**：公式文書からの明示的な根拠なし
  2. **32bit対応の理由**：Access DBとの関連性の明示的記述なし
  3. **デフォルトパスワード "admin"**：コード上での確認が困難
  4. **jstemplates.comとの連携**：オリジナルREADMEからの情報のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/README.md`（オリジナルREADME）
- E-02: `/LICENSE`（MIT License）
- E-03: `/asp/begin.asp`（バージョン情報、設定定数）
- E-04: `/default.asp`（エントリーポイント）
- E-05: `/web.config`（IIS設定）
- E-06: `/asp/includes/database.asp`（データベース処理）
- E-07: `/db/QuickerSite.mdb`（メインDB存在確認）
- E-08: `/db/QuickerLabels.mdb`（ラベルDB存在確認）
- E-09: `/asp/codemirror/package.json`（CodeMirrorバージョン）
- E-10: `/js/JQuery183.js`（jQueryライブラリ存在）
- E-11: `/ckeditor445/`（CKEditorディレクトリ存在）
- E-12: ディレクトリ構造（ls -la結果）
- E-13: `/asp/includes/`配下のインクルードファイル群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはASP/VBScript製CMS | E-01, E-03 | ○ |
| C-02 | IIS 5以降で動作 | E-01 | ○ |
| C-03 | IIS Expressで動作 | E-01 | ○ |
| C-04 | バージョン4.4 | E-03 (C_QS_VERSION) | ○ |
| C-05 | UTF-8文字コード | E-03 (QS_CHARSET) | ○ |
| C-06 | ページ管理機能あり | E-13 (page.asp) | ○ |
| C-07 | フォーム管理機能あり | E-13 (form.asp, formfield.asp) | ○ |
| C-08 | カタログ管理機能あり | E-13 (catalog.asp, catalogItem.asp) | ○ |
| C-09 | ニュースレター機能あり | E-13 (newsletter.asp) | ○ |
| C-10 | ゲストブック機能あり | E-13 (guestbook.asp) | ○ |
| C-11 | ポール機能あり | E-13 (poll.asp) | ○ |
| C-12 | ポップアップ機能あり | E-13 (popup.asp) | ○ |
| C-13 | ショッピングカート機能あり | E-13 (shopProduct.asp, shopCategory.asp) | ○ |
| C-14 | ギャラリー機能あり | E-13 (gallery.asp) | ○ |
| C-15 | Access DB使用 | E-07, E-08, E-01 | ○ |
| C-16 | jQuery 1.8.3使用 | E-10 (JQuery183.js) | ○ |
| C-17 | CKEditor 4.4.5使用 | E-03, E-11 | ○ |
| C-18 | CodeMirror 4.6.0使用 | E-09 | ○ |
| C-19 | MITライセンス | E-02 | ○ |
| C-20 | Pieter Cooreman著作権 | E-02 | ○ |
| C-21 | 2020年著作権 | E-02 | ○ |
| C-22 | web.configで404処理 | E-05 | ○ |
| C-23 | ASPX機能でサムネイル生成 | E-03 (QS_ASPX変数) | ○ |
| C-24 | ディレクトリ構造 | E-12 | ○ |
| C-25 | bs_*.aspは管理画面 | E-12, ファイル名パターン | ○ |
| C-26 | includes配下に機能モジュール | E-13 | ○ |
| C-27 | 多言語ラベル管理 | E-08, E-13 (label.asp, language.asp) | ○ |
| C-28 | 検索機能あり | E-13 (search.asp, fullsearch.asp) | ○ |
| C-29 | ASP.NET 2.0が必要 | E-01（明示記述） | △ |
| C-30 | 32bit対応必要（Access DB用） | E-01（推測） | △ |
| C-31 | デフォルトパスワードはadmin | E-01（明示記述のみ） | △ |
| C-32 | jstemplates.comでテンプレート生成可能 | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **ASP.NET 2.0要件**: オリジナルREADMEに記述はあるが、showThumb.aspx以外での使用箇所の詳細確認が必要
  - 候補：showThumb.aspxのコード詳細確認 / 管理画面での動作確認
- **32bit対応の必要性**: Access ODBCドライバの32bit制約に関する明示的なドキュメントなし
  - 候補：Microsoftドキュメント / IIS設定ガイド
- **デフォルトパスワード**: 初期セットアップ処理（bs_initialsetup.asp等）でのパスワード検証ロジック確認が必要
  - 候補：bs_initialsetup.asp / bs_login.asp のコード確認
- **外部テンプレートサービス連携**: jstemplates.comとの連携方法の詳細が不明
  - 候補：テンプレートインポート機能のコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 技術スタック情報（ライブラリバージョン等）は明確な根拠あり
- 1: 中リスク - セットアップ手順の一部（パスワード、権限設定）は実機確認推奨
- 1: 中リスク - 機能一覧の網羅性は主要機能のみ、マイナー機能の漏れ可能性あり
- 0: 低リスク - ディレクトリ構成は実際のファイルシステムから取得

## 6) レビュアーチェックリスト（最小）
- [ ] オリジナルREADME（/README.md）と生成READMEの内容整合性確認
- [ ] セットアップ手順を実機で検証（特にIIS権限設定）
- [ ] デフォルトパスワードの変更フローが正しく機能するか確認
- [ ] 記載した機能がすべて動作することをデモサイトで確認
- [ ] 技術スタック（jQuery、CKEditor等）のバージョンが最新の実装と一致するか確認
