---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **デモサイトURL**：外部リンクの有効性未検証
  2. **jstemplates.com連携**：外部サービスの現在の状態未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `README.md` - プロジェクト概要
- E-02: `default.asp` - メインエントリーポイント
- E-03: `asp/begin.asp` - アプリケーション初期化ファイル
- E-04: `asp/process.asp` - メインルーター
- E-05: `asp/config/web_config.asp` - 設定ファイル
- E-06: `asp/includes/database.asp` - データベースクラス
- E-07: `asp/includes/functions.asp` - ユーティリティ関数
- E-08: `asp/includes/page.asp` - ページクラス
- E-09: `asp/includes/customer.asp` - 顧客クラス
- E-10: `asp/bs_login.asp` - 管理画面ログインページ
- E-11: `db/QuickerSite.mdb` - メインデータベース（存在確認）
- E-12: `db/QuickerLabels.mdb` - ラベルデータベース（存在確認）
- E-13: `asp/` ディレクトリ構造
- E-14: `js/` ディレクトリ構造
- E-15: `css/` ディレクトリ構造
- E-16: `modules/` ディレクトリ構造

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはClassic ASP/VBScriptで構築されたCMS | E-01, E-03 | ○ |
| C-02 | `<%`と`%>`でサーバーサイドコードを囲む | E-03:1-4 | ○ |
| C-03 | `Option Explicit`で変数の明示的宣言を強制 | E-03:3 | ○ |
| C-04 | VBScriptはVariant型のみをサポート | 言語仕様 | ○ |
| C-05 | `isLeeg`関数は空値をチェックする | E-07:86-93 | ○ |
| C-06 | `convertGetal`関数は数値変換を行う | E-07:94-112 | ○ |
| C-07 | `convertStr`関数は文字列変換を行う | E-07:134-145 | ○ |
| C-08 | `convertBool`関数は論理値変換を行う | E-07:147-175 | ○ |
| C-09 | Select Case文でルーティングを実装 | E-04:40-67 | ○ |
| C-10 | Whileループで繰り返し処理を実装 | E-07:63-82 | ○ |
| C-11 | Function/Subで関数・サブルーチンを定義 | E-07:59-83 | ○ |
| C-12 | `#include`ディレクティブでファイルをインクルード | E-03:56-68 | ○ |
| C-13 | `cls_customer`クラスで顧客/サイト情報を管理 | E-09:2-32 | ○ |
| C-14 | `cls_page`クラスでページ情報を管理 | E-08:4-12 | ○ |
| C-15 | `cls_database`クラスでDB接続を管理 | E-06:4-62 | ○ |
| C-16 | グローバル変数`db`でデータベース接続を共有 | E-06:2-3 | ○ |
| C-17 | `bs_`プレフィックスは管理画面ページを示す | E-13 | ○ |
| C-18 | `ad_`プレフィックスはシステム管理ページを示す | E-13 | ○ |
| C-19 | `fs_`プレフィックスはフロント編集ページを示す | E-13 | ○ |
| C-20 | `process_`プレフィックスは処理ロジックを示す | E-13 | ○ |
| C-21 | `cls_`プレフィックスはクラス定義を示す | E-06, E-08, E-09 | ○ |
| C-22 | `i`プレフィックスは整数型を示す | E-08:5-6, E-09:3-4 | ○ |
| C-23 | `s`プレフィックスは文字列型を示す | E-08:5-6, E-09:3-4 | ○ |
| C-24 | `b`プレフィックスは論理型を示す | E-08:6-7, E-09:5-6 | ○ |
| C-25 | `d`プレフィックスは日付型を示す | E-08:7-8, E-09:6-7 | ○ |
| C-26 | `asp/`ディレクトリにサーバーサイドコードが格納 | E-13 | ○ |
| C-27 | `asp/config/`に設定ファイルが格納 | E-05 | ○ |
| C-28 | `asp/includes/`に共通ライブラリが格納 | E-06, E-07, E-08, E-09 | ○ |
| C-29 | `db/`にMS Accessデータベースが格納 | E-11, E-12 | ○ |
| C-30 | `js/`にJavaScriptファイルが格納 | E-14 | ○ |
| C-31 | `css/`にスタイルシートが格納 | E-15 | ○ |
| C-32 | フロントコントローラーパターンを採用 | E-02, E-03, E-04 | ○ |
| C-33 | `default.asp`がメインエントリーポイント | E-02:1-3 | ○ |
| C-34 | `asp/begin.asp`で初期化処理を実行 | E-03 | ○ |
| C-35 | `asp/process.asp`でルーティングを実行 | E-04 | ○ |
| C-36 | `pageAction`パラメータで処理を振り分け | E-04:40 | ○ |
| C-37 | `db.Execute(sql)`でSQLを実行 | E-06:11-16 | ○ |
| C-38 | `db.GetDynamicRS`で更新可能レコードセットを取得 | E-06:25-31 | ○ |
| C-39 | MS Access, SQL Server, MySQLをサポート | E-05:40-58, E-06:45-59 | ○ |
| C-40 | CAPTCHA認証を実装 | E-10:9-11 | ○ |
| C-41 | SHA256でパスワードをハッシュ化 | E-10:12 | ○ |
| C-42 | ログイン試行回数をカウントしロックアウト | E-10:24-26 | ○ |
| C-43 | QuickerSite公式サイトURL | E-01 | ○ |
| C-44 | デモサイトURL（demo.quickersite.com） | E-01 | △ |
| C-45 | jstemplates.comとの連携 | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **外部URL有効性**: README.mdに記載の外部URL（デモサイト、jstemplates.com）の現在の有効性は未検証
  - 候補：実際のアクセステスト / Wayback Machine確認 / 代替情報源の調査

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コード構造・命名規則・ディレクトリ構造に関する主張（全て実ファイルから検証済み）
- **0: 低リスク** - VBScript言語仕様に関する主張（標準的な言語仕様）
- **0: 低リスク** - データベース接続・認証フローに関する主張（コードから直接確認）
- **1: 中リスク** - 外部リソース参照（外部URLの有効性は時間経過で変化する可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] コード例のファイルパス・行番号が実際のソースと一致するか確認
- [ ] 命名規則の説明が実際のコードパターンと一致するか確認
- [ ] ディレクトリ構造図が現在のプロジェクト構造と一致するか確認
- [ ] 業務フロー追跡の実例が実際の処理フローを正確に表しているか確認
- [ ] 外部リンク（公式サイト、デモサイト）が有効か確認
- [ ] VBScript/Classic ASPの言語仕様説明が正確か確認
