---
generated_at: 2026-01-24 00:14:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **C-39 MySQL接続オプション**：コード内でコメントアウトされているため実使用可否不明
  2. **C-40 マルチサイト運用の詳細**：コード上は可能だが実運用例は不明
  3. **C-41 パフォーマンスチューニング制約**：コード分析に基づく推測
  4. **C-42 32bit互換モードの要件**：README記載あるが環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、技術スタック記述
- E-02: `asp/begin.asp` - 初期化処理、SSIインクルード構造
- E-03: `asp/config/web_config.asp` - DB設定、SMTP設定、各種パラメータ
- E-04: `asp/includes/database.asp` - DB接続クラス定義
- E-05: `asp/includes/functions.asp` - ユーティリティ関数群
- E-06: `asp/includes/page.asp` - ページクラス定義
- E-07: `asp/includes/customer.asp` - 顧客/サイトクラス定義
- E-08: `asp/includes/template.asp` - テンプレートクラス定義
- E-09: `asp/includes/encryption.asp` - 暗号化関数
- E-10: `asp/process.asp` - リクエスト処理フロー
- E-11: `asp/bs_login.asp` - ログイン処理、認証フロー
- E-12: `default.asp` - メインエントリポイント
- E-13: `web.config` - IIS設定、404エラーハンドリング
- E-14: `showThumb.aspx` - ASP.NET画像処理
- E-15: `asp/includes/logvisit.asp` - アクセスログ記録
- E-16: `asp/includes/mail_message.asp` - メール送信処理
- E-17: `db/` - データベースファイル（Access MDB）
- E-18: `asp/includes/` - ディレクトリ構造（116ファイル）
- E-19: `asp/bs_*.asp` - バックサイトファイル群
- E-20: `asp/ad_*.asp` - 管理者機能ファイル群
- E-21: `asp/includes/LogonEdit.asp` - 認証クラス
- E-22: `asp/includes/secondAdmin.asp` - セカンドアドミン機能

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはASP/VBScript製CMS | E-01, E-02 | ○ |
| C-02 | Windows Server/IIS上で動作 | E-01, E-03 | ○ |
| C-03 | Microsoft Access/SQL Serverをデータストアとして使用 | E-03, E-04 | ○ |
| C-04 | SMTP経由でメール送信（CDO/Persits/JMail対応） | E-03, E-16 | ○ |
| C-05 | Google Analytics連携 | E-07（googleAnalytics属性） | ○ |
| C-06 | YouTube iframe埋め込み対応 | E-05（QS_iFrameYT関数） | ○ |
| C-07 | モノリシック・プロシージャルアーキテクチャ | E-02, E-12, E-18 | ○ |
| C-08 | SSIによるコード分割 | E-02 | ○ |
| C-09 | エントリポイントはdefault.asp | E-12 | ○ |
| C-10 | begin.aspで初期化処理 | E-02, E-12 | ○ |
| C-11 | レイヤー間はSSIで結合 | E-02 | ○ |
| C-12 | cls_pageでページ管理 | E-06 | ○ |
| C-13 | cls_customerでサイト管理 | E-07 | ○ |
| C-14 | cls_templateでテンプレート管理 | E-08 | ○ |
| C-15 | cls_databaseでDB接続管理 | E-04 | ○ |
| C-16 | Access DB接続はJet OLEDB 4.0 | E-04 | ○ |
| C-17 | SQL Server接続はSQLOLEDB | E-04 | ○ |
| C-18 | MySQL接続はODBC 3.51 | E-04 | ○ |
| C-19 | パッケージ構造（asp/, db/, js/, etc.） | E-17, E-18, ファイルシステム | ○ |
| C-20 | バックサイトはbs_プレフィックス | E-19 | ○ |
| C-21 | 管理機能はad_プレフィックス | E-20 | ○ |
| C-22 | ASP Applicationオブジェクトでキャッシュ | E-02, E-06 | ○ |
| C-23 | セッションタイムアウト30分 | E-02 | ○ |
| C-24 | サイト内検索機能あり | E-18（fullsearch.asp） | ○ |
| C-25 | リクエスト処理フロー（9ステップ） | E-10, E-12 | ○ |
| C-26 | 非同期処理は未使用 | E-10（process.asp全体） | ○ |
| C-27 | パスワードはSHA256ハッシュ | E-11, E-21 | ○ |
| C-28 | CAPTCHA認証あり | E-11 | ○ |
| C-29 | ブルートフォース対策（5回制限） | E-03, E-11 | ○ |
| C-30 | アクセスログをDBに記録 | E-15 | ○ |
| C-31 | ニュースレター開封追跡あり | E-10 | ○ |
| C-32 | On Error Resume Nextでエラーハンドリング | E-04, E-05, E-06 | ○ |
| C-33 | 404カスタムエラーページ対応 | E-13 | ○ |
| C-34 | トランザクション管理未実装 | E-04, E-06 | ○ |
| C-35 | encrypt/decrypt関数でID難読化 | E-09 | ○ |
| C-36 | UTF-8エンコーディング | E-02 | ○ |
| C-37 | cleanup関数でSQLインジェクション対策 | E-05 | ○ |
| C-38 | showThumb.aspxはASP.NET | E-14 | ○ |
| C-39 | MySQL接続オプション | E-04 | △ |
| C-40 | マルチサイト対応（iCustomerID分離） | E-03, E-07 | △ |
| C-41 | パフォーマンスチューニング制約 | **根拠なし** | △ |
| C-42 | 32bit互換モードが必要 | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-39**: MySQLサポートはコード上存在するがコメントアウト状態。実際に動作するか検証未実施
  - 候補：本番環境での実行テスト / MySQL実環境での検証
- **C-40**: マルチサイト運用の具体的な設定方法・制約の詳細ドキュメント不足
  - 候補：運用マニュアル / 導入ガイド / 実運用サイトの設定例
- **C-41**: パフォーマンス制約はコード構造から推測したもの。定量的なベンチマーク結果なし
  - 候補：パフォーマンステスト結果 / 本番環境メトリクス
- **C-42**: 32bit互換モード要件はREADME記載だが、環境依存の詳細不明
  - 候補：IIS設定ガイド / サポートOSバージョン一覧

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: C-01〜C-38 - ソースコードから直接確認可能
- **1（中リスク）**: C-39, C-40, C-42 - コード/ドキュメント記載あるが検証不十分
- **2（高リスク）**: C-41 - 推測ベースの記述、実測データなし

## 6) レビュアーチェックリスト（最小）
- [ ] アーキテクチャスタイルの記述がプロジェクトの実態と一致しているか確認
- [ ] レイヤー構成・モジュール構成が実際のディレクトリ構造と整合しているか確認
- [ ] DB接続設定（特にMySQL）の実運用可否を確認
- [ ] 認証フローがセキュリティ要件を満たしているか確認
- [ ] トランザクション未実装によるデータ整合性リスクを評価
- [ ] パフォーマンス制約が実運用上許容可能か評価
- [ ] 32bit互換モード要件が対象環境で問題ないか確認
