# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "クライアント"
        Browser[Web Browser]
    end

    subgraph "Webサーバー (IIS)"
        direction TB
        subgraph "ASP/ASP.NET アプリケーション"
            Entry[エントリポイント<br/>default.asp]
            Init[初期化<br/>asp/begin.asp]
            Process[プロセス<br/>asp/process.asp]
            BackSite[バックサイト<br/>asp/bs_*.asp]
            Admin[管理機能<br/>asp/ad_*.asp]
            Thumb[サムネイル生成<br/>showThumb.aspx<br/>ASP.NET]
        end

        subgraph "静的リソース"
            CSS[CSS<br/>css/]
            JS[JavaScript<br/>js/]
            Templates[テンプレート<br/>templates/]
            UserFiles[アップロードファイル<br/>UserFiles/]
        end
    end

    subgraph "データ層"
        AccessDB[(Access DB<br/>QuickerSite.mdb)]
        LabelsDB[(Labels DB<br/>QuickerLabels.mdb)]
        SQLDB[(SQL Server<br/>オプション)]
    end

    subgraph "外部サービス"
        SMTP[SMTP Server]
        GA[Google Analytics]
        YT[YouTube]
        GMaps[Google Maps]
        ExtTemplates[外部テンプレート<br/>templates31.quickersite.com]
    end

    Browser --> Entry
    Entry --> Init
    Init --> Process
    Process --> BackSite
    Process --> Admin
    Browser --> Thumb
    Browser --> CSS
    Browser --> JS

    Init --> AccessDB
    Init --> LabelsDB
    Init -.-> SQLDB
    BackSite --> AccessDB
    Admin --> AccessDB

    Process --> SMTP
    Browser --> GA
    Browser --> YT
    Browser --> GMaps
    BackSite --> ExtTemplates
```

## レイヤー構成図

```mermaid
graph TB
    subgraph "プレゼンテーション層"
        FrontPages[フロントエンドページ<br/>default.asp, printPage.asp, etc.]
        BackPages[バックサイトページ<br/>bs_*.asp]
        AdminPages[管理ページ<br/>ad_*.asp]
        ProcessPages[処理ページ<br/>process_*.asp]
    end

    subgraph "初期化/設定層"
        Begin[begin.asp<br/>初期化処理]
        Config[web_config.asp<br/>設定]
        Rebrand[rebrand.asp<br/>ブランド設定]
    end

    subgraph "ビジネスロジック/ドメイン層"
        PageClass[cls_page<br/>ページ管理]
        CustomerClass[cls_customer<br/>サイト/顧客管理]
        TemplateClass[cls_template<br/>テンプレート管理]
        ContactClass[cls_contact<br/>コンタクト管理]
        CatalogClass[cls_catalog<br/>カタログ管理]
        FormClass[cls_form<br/>フォーム管理]
        OtherClasses[その他クラス<br/>gallery, poll, etc.]
    end

    subgraph "ユーティリティ層"
        Functions[functions.asp<br/>共通関数]
        Encryption[encryption.asp<br/>暗号化]
        Messages[messages.asp<br/>メッセージ]
        Mail[mail_message.asp<br/>メール送信]
    end

    subgraph "データアクセス層"
        Database[cls_database<br/>DB接続管理]
        ADODB[ADODB<br/>レコードセット操作]
    end

    subgraph "データストア"
        MainDB[(メインDB)]
        LabelDB[(ラベルDB)]
    end

    FrontPages --> Begin
    BackPages --> Begin
    AdminPages --> Begin
    ProcessPages --> Begin

    Begin --> Config
    Begin --> Rebrand

    Begin --> PageClass
    Begin --> CustomerClass
    Begin --> TemplateClass
    Begin --> Functions

    PageClass --> Database
    CustomerClass --> Database
    TemplateClass --> Database
    ContactClass --> Database
    CatalogClass --> Database
    FormClass --> Database
    OtherClasses --> Database

    PageClass --> Functions
    CustomerClass --> Functions
    TemplateClass --> Functions

    Database --> ADODB
    ADODB --> MainDB
    ADODB --> LabelDB
```

## リクエストフロー図

```mermaid
sequenceDiagram
    participant B as Browser
    participant D as default.asp
    participant I as begin.asp
    participant P as process.asp
    participant C as cls_page
    participant T as cls_template
    participant DB as Database

    B->>D: HTTP Request
    D->>I: Include begin.asp
    I->>I: 初期化処理
    I->>DB: DB接続確立
    I->>DB: 顧客情報取得
    DB-->>I: 顧客データ
    I-->>D: 初期化完了
    D->>P: Include process.asp
    P->>P: pageAction判定
    P->>C: ページ取得
    C->>DB: SELECT FROM tblPage
    DB-->>C: ページデータ
    C-->>P: ページオブジェクト
    P->>T: テンプレート適用
    T->>DB: SELECT FROM tblTemplate
    DB-->>T: テンプレートデータ
    T->>T: コンテンツ埋め込み
    T-->>P: HTML生成
    P-->>D: レスポンス
    D-->>B: HTML Response
```

## モジュール依存関係図

```mermaid
graph LR
    subgraph "エントリポイント"
        default[default.asp]
        backsite[backsite/default.asp]
    end

    subgraph "コア"
        begin[begin.asp]
        process[process.asp]
    end

    subgraph "設定"
        webconfig[web_config.asp]
        rebrand[rebrand.asp]
    end

    subgraph "ドメインクラス"
        page[page.asp]
        customer[customer.asp]
        template[template.asp]
        contact[contact.asp]
        catalog[catalog.asp]
        form[form.asp]
        gallery[gallery.asp]
        newsletter[newsletter.asp]
    end

    subgraph "インフラ"
        database[database.asp]
        functions[functions.asp]
        encryption[encryption.asp]
        mail[mail_message.asp]
    end

    default --> begin
    backsite --> begin
    begin --> webconfig
    begin --> rebrand
    begin --> database
    begin --> functions
    begin --> encryption
    begin --> page
    begin --> customer
    begin --> template
    begin --> contact
    begin --> catalog
    begin --> form
    begin --> gallery
    begin --> newsletter
    begin --> mail
    default --> process

    page --> database
    page --> functions
    customer --> database
    customer --> functions
    template --> database
    template --> functions
    contact --> database
    catalog --> database
    form --> database
    gallery --> database
    newsletter --> database
    newsletter --> mail
```

## ファイル構成図

```mermaid
graph TB
    subgraph "ルート"
        Root[QuickerSite-master/]
    end

    subgraph "メインディレクトリ"
        asp[asp/]
        db[db/]
        js[js/]
        css[css/]
        templates[templates/]
        userfiles[UserFiles/]
        modules[modules/]
        ckeditor[ckeditor445/]
    end

    subgraph "asp/ サブディレクトリ"
        config[config/]
        includes[includes/]
        assetmanager[assetmanager/]
        codemirror[codemirror/]
    end

    subgraph "主要ファイル"
        defaultasp[default.asp]
        indexasp[index.asp]
        showthumb[showThumb.aspx]
        webconfig[web.config]
    end

    Root --> asp
    Root --> db
    Root --> js
    Root --> css
    Root --> templates
    Root --> userfiles
    Root --> modules
    Root --> ckeditor
    Root --> defaultasp
    Root --> indexasp
    Root --> showthumb
    Root --> webconfig

    asp --> config
    asp --> includes
    asp --> assetmanager
    asp --> codemirror
```

## データベース接続フロー

```mermaid
flowchart TB
    subgraph "接続設定 (web_config.asp)"
        QS_DBS{DB種別<br/>QS_DBS}
        C_DATABASE[Access DB パス]
        SQL_PARAMS[SQL Server パラメータ]
        MYSQL_PARAMS[MySQL パラメータ]
    end

    subgraph "DB接続クラス (database.asp)"
        cls_database[cls_database]
        getConn[getConn]
        getConnLabels[getConnLabels]
    end

    subgraph "接続文字列"
        AccessConn[Provider=Microsoft.Jet.OLEDB.4.0]
        SQLConn[Provider=SQLOLEDB]
        MySQLConn[Driver=MySQL ODBC 3.51]
    end

    subgraph "データベース"
        AccessDB[(Access<br/>QuickerSite.mdb)]
        SQLDB[(SQL Server)]
        MySQL[(MySQL)]
        LabelsDB[(Access<br/>QuickerLabels.mdb)]
    end

    QS_DBS -->|1| AccessConn
    QS_DBS -->|2| SQLConn
    QS_DBS -->|3| MySQLConn

    cls_database --> getConn
    cls_database --> getConnLabels

    getConn --> QS_DBS
    getConnLabels --> LabelsDB

    AccessConn --> AccessDB
    SQLConn --> SQLDB
    MySQLConn --> MySQL
```

## 認証フロー図

```mermaid
sequenceDiagram
    participant U as User
    participant L as bs_login.asp
    participant LO as LogonEdit.asp
    participant S as Session
    participant DB as Database

    U->>L: アクセス
    L->>U: ログインフォーム表示<br/>(CAPTCHA付き)
    U->>L: パスワード + CAPTCHA入力
    L->>L: CAPTCHA検証
    alt CAPTCHA不正
        L->>U: エラー表示
    end
    L->>LO: ログオン処理
    LO->>DB: パスワードハッシュ照合<br/>(SHA256)
    alt 認証成功
        LO->>S: セッション設定
        S-->>LO: OK
        LO->>U: bs_default.aspへリダイレクト
    else 認証失敗
        LO->>LO: 試行回数カウント
        alt 5回超過
            LO->>U: アカウントロック
        else 5回以内
            LO->>U: エラー表示
        end
    end
```
