# アーキテクチャ設計書

## 概要

本ドキュメントは、QuickerSite CMSのアーキテクチャ設計を記述したものである。QuickerSiteはWindows Server（IIS）上で動作するASP/VBScript製のコンテンツ管理システム（CMS）であり、Microsoft AccessまたはSQL Serverをデータストアとして使用する従来型のサーバーサイドレンダリングWebアプリケーションである。

## システム全体構成

### アーキテクチャ概要図

[アーキテクチャ構成図.md](./アーキテクチャ構成図.md) を参照

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| SMTP Server | SMTP (CDO/Persits/JMail) | メール送信（コンタクトフォーム、ニュースレター等） |
| Google Analytics | JavaScript埋め込み | アクセス解析 |
| YouTube | iframe埋め込み | 動画コンテンツ表示 |
| Google Maps | JavaScript API | 地図表示 |
| 外部テンプレートサーバー (templates31.quickersite.com) | HTTP | オンラインテンプレートの取得 |

## レイヤー構成

### アーキテクチャスタイル

**モノリシック・プロシージャルアーキテクチャ（従来型ASPスタイル）**

QuickerSiteは、MVCパターン以前の従来型ASPアーキテクチャを採用している。Server-Side Includesによるコード分割、クラスベースのデータアクセス、テンプレートエンジンによるビュー生成を組み合わせた構造となっている。

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| エントリポイント | リクエスト受付、ルーティング | `default.asp`, `index.asp`, `rss.asp`, `sitemap.asp` |
| 初期化/設定 | アプリケーション設定、セッション管理 | `asp/begin.asp`, `asp/config/web_config.asp` |
| プレゼンテーション | UI生成、フォーム処理 | `asp/bs_*.asp`（バックサイト）, `asp/process*.asp`（フロント処理） |
| ビジネスロジック/ドメイン | ドメインモデル、ビジネスルール | `asp/includes/*.asp`（クラス定義） |
| データアクセス | DB接続、CRUD操作 | `asp/includes/database.asp`, 各クラスのpick/save/removeメソッド |
| テンプレート | ページ表示テンプレート | `asp/includes/template.asp`, `templates/` |
| ユーティリティ | 共通関数群 | `asp/includes/functions.asp`, `asp/includes/encryption.asp` |

### レイヤー間の依存関係ルール

```
[エントリポイント]
    ↓
[初期化/設定] → 全レイヤーで参照される設定値を提供
    ↓
[プレゼンテーション] ← SSI (Server-Side Include) による結合
    ↓
[ビジネスロジック] ← クラスインスタンス経由でアクセス
    ↓
[データアクセス] → グローバルなdbオブジェクト経由
```

- 依存の方向性：上位レイヤーから下位レイヤーへの一方向
- SSI（`<!-- #include file="..." -->`）により、ファイル単位でコードが結合される
- グローバル変数・オブジェクトを多用した密結合な構造

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| ページ管理 | CMSコンテンツページの管理 | `page.asp`, `bs_editItem.asp`, `bs_listPage.asp` |
| テンプレート | サイトテンプレート・テーマ管理 | `template.asp`, `theme.asp`, `bs_template*.asp` |
| カタログ | カタログ・商品管理 | `catalog.asp`, `catalogItem.asp`, `catalogField.asp` |
| フォーム | カスタムフォーム・サブミッション管理 | `form.asp`, `formfield.asp`, `submission.asp` |
| コンタクト/イントラネット | 顧客・ユーザー管理 | `contact.asp`, `contactField.asp`, `customer.asp` |
| ニュースレター | ニュースレター配信管理 | `newsletter.asp`, `newsletterMailing.asp` |
| ギャラリー | 画像ギャラリー管理 | `gallery.asp`, `bs_gallery*.asp` |
| ゲストブック | ゲストブック機能 | `guestbook.asp`, `guestbookitem.asp` |
| ポール | 投票機能 | `poll.asp`, `bs_poll*.asp` |
| ショップ | ECショップ機能 | `shopProduct.asp`, `shopCategory.asp`, `bs_shop*.asp` |
| フィード | RSS/Atomフィード管理 | `feed.asp`, `rss_writer.asp` |
| 認証・セキュリティ | ログイン・アクセス制御 | `LogonEdit.asp`, `secondAdmin.asp`, `encryption.asp` |

### パッケージ構造

```
QuickerSite-master/
├── asp/                          # ASPアプリケーションコア
│   ├── begin.asp                 # 初期化・設定読み込み
│   ├── config/                   # 設定ファイル
│   │   ├── web_config.asp        # メイン設定
│   │   └── rebrand.asp           # ブランド設定
│   ├── includes/                 # 共有ライブラリ・クラス定義
│   │   ├── database.asp          # DB接続クラス
│   │   ├── functions.asp         # ユーティリティ関数群
│   │   ├── page.asp              # ページクラス
│   │   ├── customer.asp          # 顧客（サイト）クラス
│   │   ├── template.asp          # テンプレートクラス
│   │   ├── encryption.asp        # 暗号化関数
│   │   └── ...                   # その他ドメインクラス
│   ├── bs_*.asp                  # バックサイト（管理画面）
│   ├── ad_*.asp                  # 管理者機能
│   ├── fs_*.asp                  # フロントサイト編集機能
│   ├── process_*.asp             # フロント処理
│   ├── assetmanager/             # ファイルマネージャー
│   ├── codemirror/               # コードエディタ
│   ├── iismanager/               # IIS管理
│   └── uploadify214/             # ファイルアップロード
├── backsite/                     # バックサイトエントリ
├── backsiteTemplate31/           # バックサイトテンプレート
├── ckeditor445/                  # WYSIWYGエディタ
├── common/                       # カスタム共通コード
├── css/                          # スタイルシート
├── db/                           # データベースファイル
│   ├── QuickerSite.mdb           # メインDB（Access）
│   └── QuickerLabels.mdb         # ラベルDB（多言語）
├── js/                           # JavaScriptライブラリ
├── modules/                      # 拡張モジュール
├── templates/                    # サイトテンプレート
├── UserFiles/                    # ユーザーアップロードファイル
├── default.asp                   # メインエントリポイント
├── showThumb.aspx                # 画像サムネイル生成（ASP.NET）
├── web.config                    # IIS設定
└── *.asp                         # その他フロントエンドASP
```

### コンポーネント依存関係

```
default.asp
  └── asp/begin.asp（初期化）
        ├── config/web_config.asp（設定）
        ├── includes/database.asp（DB接続）
        ├── includes/functions.asp（ユーティリティ）
        ├── includes/customer.asp（サイト情報）
        ├── includes/page.asp（ページ管理）
        ├── includes/template.asp（テンプレート）
        └── ...（その他includes）
  └── asp/process.asp（リクエスト処理）
        └── process_*.asp（各種処理）
```

## ミドルウェア構成

### データベース

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| RDB | Microsoft Access | Jet OLEDB 4.0 | デフォルトのデータストア |
| RDB | Microsoft SQL Server | 2000/2005以降 | 大規模環境向けオプション |
| RDB | MySQL | ODBC 3.51 | 代替オプション |

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| ASP Application オブジェクト | IIS依存 | ページキャッシュ、設定キャッシュ | アプリケーションライフサイクル |
| ASP Session オブジェクト | IIS依存 | ユーザーセッション | 30分（デフォルト） |

### メッセージキュー

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| 該当なし | - | 非同期処理は使用していない |

### 検索エンジン

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| 内蔵検索（SQL） | - | サイト内検索（`fullsearch.asp`） |

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| CDO.Message | Windows組み込み | メール送信（デフォルト） |
| Persits.MailSender | 外部ライブラリ | メール送信（オプション） |
| JMail.Message | 外部ライブラリ | メール送信（オプション） |
| ADODB | Windows組み込み | データベース接続 |
| Scripting.FileSystemObject | Windows組み込み | ファイル操作 |
| MSXML2.DOMDocument | Windows組み込み | XML処理、Base64エンコード |
| ASP.NET (System.Drawing) | .NET 2.0以降 | 画像リサイズ処理 |

## データフロー

### リクエスト処理の流れ

1. **リクエスト受信**: IISが`default.asp`にリクエストをルーティング
2. **初期化**: `asp/begin.asp`で設定読み込み、DB接続確立、セッション初期化
3. **顧客(サイト)情報取得**: `cls_customer`クラスでサイト設定をDBから取得
4. **ページ特定**: URLパラメータまたはユーザーフレンドリーURLからページを特定
5. **ページアクション判定**: `asp/process.asp`で`pageAction`パラメータに基づく処理分岐
6. **コンテンツ取得**: `cls_page`クラスでページコンテンツをDBから取得
7. **テンプレート適用**: `cls_template`クラスでテンプレートにコンテンツを埋め込み
8. **定数置換**: `insertConstants.asp`でカスタム定数を置換
9. **レスポンス出力**: HTMLをクライアントに返却

### 非同期処理の流れ

本システムでは非同期処理は使用していない。全てのリクエストは同期処理で完結する。ニュースレター送信など時間のかかる処理も同期的に実行される。

### データ永続化の流れ

1. **入力受付**: フォームPOSTデータを`Request.Form`で取得
2. **バリデーション**: 各クラスの`validate`メソッドまたは個別チェック
3. **データ変換**: `convertStr`、`convertGetal`、`cleanup`関数で型変換・サニタイズ
4. **SQL構築**: 動的SQLクエリを文字列連結で構築
5. **実行**: `db.execute`または動的レコードセットの`update`メソッドで実行
6. **結果確認**: エラーチェック後、リダイレクトまたはメッセージ表示

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| パスワード認証（SHA256ハッシュ） | `asp/bs_login.asp`, `LogonEdit.asp` | 管理画面アクセス |
| セカンドアドミン認証 | `secondAdmin.asp` | 追加管理者 |
| イントラネット認証 | `process_loginIntranet.asp` | 会員エリア |
| CAPTCHA | `includes/captcha.asp` | ログインフォーム |
| ブルートフォース対策 | `logon.lockBSAdmin()` | ログイン試行制限（5回） |
| セッション認証 | `Session`オブジェクト | 認証状態保持 |

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| アクセスログ | `logvisit.asp` | tblPageHits（DB） |
| リファラー追跡 | `bScanReferer`設定 | tblReferer（DB） |
| ニュースレター開封追跡 | 1x1ピクセル画像 | tblNewsletterLog（DB） |
| エラーログ | メール送信（`dumperror`関数） | 管理者メール |

### エラーハンドリング

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| VBScriptランタイムエラー | `On Error Resume Next` + `Err`オブジェクトチェック | 継続処理またはエラーメール |
| 404 Not Found | `web.config`カスタムエラー | カスタム404ページまたは`default.asp`リダイレクト |
| データベースエラー | エラーチェックなし（`On Error Resume Next`で無視） | 不完全な表示 |
| バリデーションエラー | `cls_messages`クラス | エラーメッセージ表示 |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| 単一SQL文 | 自動コミット | デフォルト（Read Committed） |
| 複数テーブル更新 | トランザクション未使用 | - |

注：本システムでは明示的なトランザクション管理は実装されていない。複数テーブルへの更新処理は個別のSQL文として順次実行される。

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| コードの再利用（Include） | 全体 | SSIによるファイル分割 |
| クラスベース設計 | ドメインモデル | `cls_page`, `cls_customer`等 |
| 設定の外部化 | 設定ファイル | `web_config.asp` |
| テンプレート分離 | ビュー | `template.asp`, テンプレートファイル |
| 暗号化 | ID難読化 | `encryption.asp`の`encrypt`/`decrypt`関数 |

### コーディング規約

- **命名規則**
  - クラス名：`cls_`プレフィックス（例：`cls_page`）
  - 定数：`C_`プレフィックス（例：`C_DATABASE`）
  - ファイル名：
    - バックサイト：`bs_`プレフィックス
    - 管理者機能：`ad_`プレフィックス
    - フロント処理：`process_`プレフィックス
    - フロント編集：`fs_`プレフィックス

- **エラーハンドリング**
  - `On Error Resume Next`と`On Error Goto 0`の対で囲む
  - `Err.Number`でエラーチェック

- **文字エンコーディング**
  - UTF-8（`CODEPAGE="65001"`）

- **セキュリティ**
  - `cleanup`関数でSQLインジェクション対策
  - `sanitize`関数でXSS対策
  - パスワードはSHA256ハッシュで保存

## 備考

### アーキテクチャ上の特徴

1. **レガシー技術スタック**: Classic ASP/VBScriptという2000年代初期の技術を使用
2. **モノリシック構造**: すべての機能が単一のコードベースに統合
3. **ファイルベースDB対応**: Microsoft Accessを使用可能で、小規模サイトの導入が容易
4. **ASP.NET混在**: 画像処理（`showThumb.aspx`）のみASP.NETを使用
5. **多言語対応**: ラベルDB（`QuickerLabels.mdb`）による多言語サポート
6. **マルチサイト対応**: 単一DBで複数サイトを運用可能（`iCustomerID`による分離）

### 制約・考慮事項

- Windows Server + IIS環境でのみ動作
- 32bit互換モードが必要（Access DB使用時）
- ASP.NET 2.0以上が必要（画像リサイズ機能使用時）
- 明示的なトランザクション管理がない
- パフォーマンスチューニングの余地が限定的
