---
generated_at: 2026-01-24 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **サーバースペック推奨値**：コードから特定不可、一般的推奨値を記載
  2. **バックアップ頻度・保持期間**：設定ファイルに記載なし、運用設計として推奨値を記載
  3. **監視閾値**：コードに監視機能なし、一般的推奨値を記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/config/web_config.asp` - データベース設定、SMTP設定、バージョン情報
- E-02: `asp/begin.asp` - アプリケーション初期化、バージョン定数、インクルードファイル一覧
- E-03: `web.config` - IIS設定、HTTPエラー処理
- E-04: `asp/includes/database.asp` - データベース接続クラス、対応DB種類
- E-05: `asp/includes/mail_message.asp` - メールコンポーネント対応一覧
- E-06: `asp/config/rebrand.asp` - ブランディング設定、テンプレート設定
- E-07: `README.md` - インストール手順、動作環境
- E-08: `showThumb.aspx` - ASP.NET画像処理機能
- E-09: `/db/` ディレクトリ - Access データベースファイル確認
- E-10: `/UserFiles/` ディレクトリ - ユーザーファイルストレージ構造

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはClassic ASP/VBScriptで構築されている | E-01, E-02 | ○ |
| C-02 | IIS 5以上で動作する | E-07 | ○ |
| C-03 | ASP.NET 2.0が必要（画像処理用） | E-07, E-08 | ○ |
| C-04 | Access、SQL Server、MySQLの3種類のDBに対応 | E-01, E-04 | ○ |
| C-05 | CDO、Persits、JMail等の複数メールコンポーネントに対応 | E-01, E-05 | ○ |
| C-06 | SMTPサーバー設定はweb_config.aspで構成 | E-01 | ○ |
| C-07 | デフォルトSMTPポートは25 | E-01 | ○ |
| C-08 | SMTP SSL対応オプションあり | E-01, E-05 | ○ |
| C-09 | QuickerSiteバージョンは4.4 | E-02 | ○ |
| C-10 | セッションタイムアウトは30分 | E-02 | ○ |
| C-11 | サーバースクリプトタイムアウトは800秒 | E-02 | ○ |
| C-12 | 32bitアプリケーションプールが必要（Access使用時） | E-07 | ○ |
| C-13 | IUSRにフルアクセス権限が必要 | E-01, E-07 | ○ |
| C-14 | 危険なファイル拡張子をブロック | E-02 | ○ |
| C-15 | データベースファイル名は自動変更される（セキュリティ対策） | E-04 | ○ |
| C-16 | CKEditor 4.4.5を使用 | E-02 | ○ |
| C-17 | 404エラーはdefault.aspにリダイレクト | E-03 | ○ |
| C-18 | オンラインテンプレート機能あり | E-01, E-02 | ○ |
| C-19 | テンプレートギャラリーURLはtemplates31.quickersite.com | E-02 | ○ |
| C-20 | C_DEV定数でオフラインモード制御 | E-01, E-02 | ○ |
| C-21 | デフォルト管理者パスワードは"admin" | E-07 | ○ |
| C-22 | ログイン試行回数は5回制限 | E-01 | ○ |
| C-23 | サーバースペック推奨値（CPU、メモリ、ディスク） | **根拠なし** | △ |
| C-24 | バックアップ頻度・保持期間 | **根拠なし** | △ |
| C-25 | 監視閾値（CPU 80%、メモリ 85%等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **サーバースペック推奨値**
  - コードベースにはサーバースペックに関する記載なし
  - 候補：README.md / 公式ドキュメント / 運用実績からの推測
- **バックアップ設計**
  - アプリケーションにバックアップ機能が組み込まれていない
  - 候補：運用マニュアル / 別途バックアップスクリプト / 運用チーム確認
- **監視設計**
  - アプリケーション内に監視・アラート機能なし
  - 候補：IIS標準機能 / Windows Performance Monitor / 外部監視ツール

## 5) リスクフラグ（レビュー観点）
- **リスク 0（低リスク）**: 技術スタック、データベース対応、メールコンポーネント対応
  - コードから直接確認可能であり、信頼性が高い
- **リスク 1（中リスク）**: ディレクトリ構成、権限設定
  - 実際のデプロイ環境により異なる可能性あり
- **リスク 2（高リスク）**: サーバースペック推奨値、バックアップ設計、監視設計
  - コードベースに根拠がなく、運用環境・要件に依存する内容

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の運用サーバースペックが推奨値を満たしているか確認
- [ ] Access使用時の32bitアプリケーションプール設定が正しいか確認
- [ ] IUSRの権限設定が適切か確認
- [ ] バックアップ運用が実際に設計通りに行われているか確認
- [ ] 監視設定が実運用環境で有効か確認
- [ ] SSL/TLS設定が本番環境で適用されているか確認
- [ ] SMTPサーバー設定（ホスト、ポート、認証）が本番環境と一致しているか確認
- [ ] データベース接続文字列（SQL Server/MySQL使用時）が正しいか確認
