# インフラ構成図

## 概要

本ドキュメントは、QuickerSite CMSのインフラストラクチャ構成を視覚的に表現した図を提供します。

---

## 1. システム全体構成図

```mermaid
graph TB
    subgraph Internet["インターネット"]
        Client[("クライアント<br/>（ブラウザ）")]
    end

    subgraph Firewall["ファイアウォール"]
        FW{ファイアウォール<br/>80/443}
    end

    subgraph WebServer["Webサーバー層"]
        IIS["IIS Web Server<br/>（Windows Server）"]
        ASP["Classic ASP<br/>VBScript"]
        ASPNET["ASP.NET 2.0<br/>（showThumb.aspx）"]
    end

    subgraph Database["データベース層"]
        Access["Microsoft Access<br/>（.mdb）"]
        SQLServer["SQL Server<br/>（オプション）"]
        MySQL["MySQL<br/>（オプション）"]
    end

    subgraph External["外部サービス"]
        SMTP["SMTPサーバー<br/>（メール送信）"]
        Templates["テンプレート<br/>ギャラリー"]
    end

    Client --> FW
    FW --> IIS
    IIS --> ASP
    IIS --> ASPNET
    ASP --> Access
    ASP -.-> SQLServer
    ASP -.-> MySQL
    ASP --> SMTP
    ASP -.-> Templates

    style Client fill:#e1f5fe
    style IIS fill:#c8e6c9
    style ASP fill:#fff9c4
    style ASPNET fill:#fff9c4
    style Access fill:#ffecb3
    style SQLServer fill:#f5f5f5
    style MySQL fill:#f5f5f5
    style SMTP fill:#fce4ec
    style Templates fill:#fce4ec
```

---

## 2. 単一サーバー構成（基本構成）

```mermaid
graph TB
    subgraph Server["Windows Server"]
        subgraph IISLayer["IIS"]
            AppPool["アプリケーションプール<br/>（32bit有効）"]
            WebSite["Webサイト<br/>QuickerSite"]
        end

        subgraph AppLayer["アプリケーション"]
            ASPFiles["ASPファイル<br/>（/asp/）"]
            UserFiles["ユーザーファイル<br/>（/UserFiles/）"]
            StaticFiles["静的ファイル<br/>（/js/, /css/）"]
        end

        subgraph DataLayer["データ"]
            MainDB["QuickerSite.mdb<br/>（メインDB）"]
            LabelDB["QuickerLabels.mdb<br/>（ラベルDB）"]
        end
    end

    AppPool --> WebSite
    WebSite --> ASPFiles
    WebSite --> UserFiles
    WebSite --> StaticFiles
    ASPFiles --> MainDB
    ASPFiles --> LabelDB

    style AppPool fill:#c8e6c9
    style WebSite fill:#c8e6c9
    style ASPFiles fill:#fff9c4
    style UserFiles fill:#bbdefb
    style StaticFiles fill:#bbdefb
    style MainDB fill:#ffecb3
    style LabelDB fill:#ffecb3
```

---

## 3. 推奨構成（Web + DBサーバー分離）

```mermaid
graph TB
    subgraph WebTier["Webサーバー層"]
        LB["ロードバランサー<br/>（オプション）"]

        subgraph Web1["Webサーバー #1"]
            IIS1["IIS + ASP"]
        end

        subgraph Web2["Webサーバー #2"]
            IIS2["IIS + ASP<br/>（オプション）"]
        end
    end

    subgraph DBTier["データベース層"]
        subgraph Primary["プライマリDB"]
            SQLP["SQL Server<br/>（Primary）"]
        end

        subgraph Secondary["セカンダリDB"]
            SQLS["SQL Server<br/>（Standby）"]
        end
    end

    subgraph Storage["共有ストレージ"]
        NAS["NAS/SAN<br/>UserFiles"]
    end

    LB --> IIS1
    LB -.-> IIS2
    IIS1 --> SQLP
    IIS2 -.-> SQLP
    SQLP -.-> SQLS
    IIS1 --> NAS
    IIS2 -.-> NAS

    style LB fill:#e1bee7
    style IIS1 fill:#c8e6c9
    style IIS2 fill:#f5f5f5
    style SQLP fill:#ffecb3
    style SQLS fill:#f5f5f5
    style NAS fill:#bbdefb
```

---

## 4. ネットワーク構成図

```mermaid
graph LR
    subgraph Internet["インターネット"]
        Users[("ユーザー")]
    end

    subgraph DMZ["DMZ"]
        FW1["ファイアウォール<br/>（外部）"]
        WAF["WAF<br/>（オプション）"]
        WebSrv["Webサーバー<br/>IIS"]
    end

    subgraph Internal["内部ネットワーク"]
        FW2["ファイアウォール<br/>（内部）"]
        DBSrv["DBサーバー<br/>SQL Server"]
        SMTP["SMTPサーバー"]
        Backup["バックアップ<br/>サーバー"]
    end

    Users -->|80/443| FW1
    FW1 --> WAF
    WAF --> WebSrv
    WebSrv -->|1433| FW2
    FW2 --> DBSrv
    FW2 --> SMTP
    FW2 --> Backup

    style Users fill:#e1f5fe
    style FW1 fill:#ffcdd2
    style FW2 fill:#ffcdd2
    style WAF fill:#f8bbd9
    style WebSrv fill:#c8e6c9
    style DBSrv fill:#ffecb3
    style SMTP fill:#fce4ec
    style Backup fill:#d7ccc8
```

---

## 5. アプリケーションアーキテクチャ図

```mermaid
graph TB
    subgraph Presentation["プレゼンテーション層"]
        Browser["Webブラウザ"]
        Admin["管理画面<br/>（backsite）"]
        Public["公開サイト<br/>（frontsite）"]
    end

    subgraph Application["アプリケーション層"]
        Begin["begin.asp<br/>（初期化）"]
        Process["process.asp<br/>（ページ処理）"]

        subgraph Modules["モジュール"]
            CMS["CMSコア"]
            Gallery["ギャラリー"]
            Form["フォーム"]
            Newsletter["ニュースレター"]
            Shop["ショップ"]
            Catalog["カタログ"]
        end

        subgraph Services["サービス"]
            Mail["メールサービス"]
            Upload["ファイルアップロード"]
            ImageProc["画像処理"]
        end
    end

    subgraph Data["データ層"]
        Database["データベース<br/>（Access/SQL Server）"]
        FileSystem["ファイルシステム<br/>（UserFiles）"]
    end

    Browser --> Admin
    Browser --> Public
    Admin --> Begin
    Public --> Begin
    Begin --> Process
    Process --> Modules
    Modules --> Services
    Modules --> Database
    Services --> Database
    Services --> FileSystem

    style Browser fill:#e1f5fe
    style Admin fill:#c8e6c9
    style Public fill:#c8e6c9
    style Begin fill:#fff9c4
    style Process fill:#fff9c4
    style CMS fill:#ffe0b2
    style Database fill:#ffecb3
    style FileSystem fill:#bbdefb
```

---

## 6. データフロー図

```mermaid
sequenceDiagram
    participant Client as クライアント
    participant IIS as IIS
    participant ASP as ASP Engine
    participant DB as データベース
    participant SMTP as SMTPサーバー

    Client->>IIS: HTTP Request
    IIS->>ASP: *.asp実行
    ASP->>ASP: begin.asp (初期化)
    ASP->>DB: データ取得
    DB-->>ASP: レコードセット
    ASP->>ASP: ページ生成
    ASP-->>IIS: HTML Response
    IIS-->>Client: HTTP Response

    Note over ASP,SMTP: フォーム送信時
    Client->>IIS: POST Request
    IIS->>ASP: フォーム処理
    ASP->>DB: データ保存
    ASP->>SMTP: メール送信
    SMTP-->>Client: メール通知
```

---

## 7. ディレクトリ構成図

```mermaid
graph TD
    Root["/QuickerSite"]

    Root --> asp["/asp"]
    Root --> db["/db"]
    Root --> UserFiles["/UserFiles"]
    Root --> css["/css"]
    Root --> js["/js"]
    Root --> templates["/templates"]
    Root --> ckeditor["/ckeditor445"]
    Root --> backsite["/backsite"]
    Root --> modules["/modules"]
    Root --> common["/common"]

    asp --> config["/config"]
    asp --> includes["/includes"]

    config --> webconfig["web_config.asp"]
    config --> rebrand["rebrand.asp"]

    db --> maindb["QuickerSite.mdb"]
    db --> labeldb["QuickerLabels.mdb"]

    UserFiles --> catalogfiles["/catalogfiles"]
    UserFiles --> pagemedia["/pagemedia"]
    UserFiles --> pg["/PG"]
    UserFiles --> usertemplates["/templates"]

    style Root fill:#c8e6c9
    style asp fill:#fff9c4
    style db fill:#ffecb3
    style UserFiles fill:#bbdefb
    style config fill:#ffe0b2
```

---

## 8. 監視構成図

```mermaid
graph TB
    subgraph Monitoring["監視システム"]
        Monitor["監視サーバー"]
        Alerts["アラート通知"]
    end

    subgraph Targets["監視対象"]
        subgraph Server["Webサーバー"]
            CPU["CPU使用率"]
            Memory["メモリ使用率"]
            Disk["ディスク使用率"]
            IISState["IIS状態"]
        end

        subgraph Application["アプリケーション"]
            HTTP["HTTP応答"]
            Error["エラーログ"]
            Response["応答時間"]
        end

        subgraph DB["データベース"]
            DBConn["接続数"]
            DBSize["DB容量"]
        end
    end

    Monitor --> CPU
    Monitor --> Memory
    Monitor --> Disk
    Monitor --> IISState
    Monitor --> HTTP
    Monitor --> Error
    Monitor --> Response
    Monitor --> DBConn
    Monitor --> DBSize

    CPU -->|閾値超過| Alerts
    Memory -->|閾値超過| Alerts
    Error -->|発生時| Alerts

    style Monitor fill:#e1bee7
    style Alerts fill:#ffcdd2
    style CPU fill:#c8e6c9
    style Memory fill:#c8e6c9
    style Disk fill:#c8e6c9
    style HTTP fill:#fff9c4
    style DBConn fill:#ffecb3
```

---

## 9. バックアップ構成図

```mermaid
graph LR
    subgraph Production["本番環境"]
        WebSrv["Webサーバー"]
        DBSrv["DBサーバー"]
    end

    subgraph Backup["バックアップ"]
        Daily["日次バックアップ"]
        Weekly["週次バックアップ"]
        Archive["アーカイブ"]
    end

    subgraph Storage["ストレージ"]
        Local["ローカル<br/>ストレージ"]
        Remote["リモート<br/>ストレージ"]
        Cloud["クラウド<br/>（オプション）"]
    end

    WebSrv -->|UserFiles| Daily
    DBSrv -->|データベース| Daily
    Daily --> Local
    Daily -->|同期| Remote
    Weekly --> Archive
    Archive -.-> Cloud

    style WebSrv fill:#c8e6c9
    style DBSrv fill:#ffecb3
    style Daily fill:#bbdefb
    style Weekly fill:#bbdefb
    style Local fill:#d7ccc8
    style Remote fill:#d7ccc8
    style Cloud fill:#f5f5f5
```

---

## 10. デプロイメントフロー図

```mermaid
flowchart TB
    Start([開始]) --> Backup[バックアップ取得]
    Backup --> Offline[オフラインモード<br/>C_DEV=true]
    Offline --> Upload[ファイル<br/>アップロード]
    Upload --> Schema{DBスキーマ<br/>更新必要?}
    Schema -->|Yes| UpdateDB[DBスキーマ更新]
    Schema -->|No| Online
    UpdateDB --> Online[オンラインモード<br/>C_DEV=false]
    Online --> Recycle[アプリプール<br/>リサイクル]
    Recycle --> Test[動作確認]
    Test --> Success{成功?}
    Success -->|Yes| End([完了])
    Success -->|No| Rollback[ロールバック]
    Rollback --> Test

    style Start fill:#c8e6c9
    style End fill:#c8e6c9
    style Backup fill:#bbdefb
    style Offline fill:#ffcdd2
    style Online fill:#c8e6c9
    style Rollback fill:#ffcdd2
```

---

## 付録: 凡例

| 色 | 意味 |
|---|-----|
| 緑色 | アクティブなコンポーネント |
| 黄色 | アプリケーション層 |
| オレンジ | データベース層 |
| 青色 | ストレージ/ファイルシステム |
| ピンク | 外部サービス |
| 赤色 | セキュリティ/注意が必要な箇所 |
| グレー | オプション/非アクティブ |

---

## 更新履歴

| 日付 | バージョン | 変更内容 |
|-----|----------|---------|
| 2026-01-24 | 1.0 | 初版作成 |
