# インフラ設計書

## 概要

本ドキュメントは、QuickerSite CMS（Content Management System）のインフラストラクチャ設計について記述します。QuickerSiteは、Classic ASP/VBScriptで構築されたWindows Server向けCMSであり、IIS（Internet Information Services）上で動作します。

## システム構成

### 全体構成

QuickerSiteは、クラシックな2層/3層アーキテクチャを採用したWebアプリケーションです。

```
[クライアント] ←→ [IIS Webサーバー (ASP/VBScript)] ←→ [データベース (Access/SQL Server/MySQL)]
                            ↓
                    [SMTPサーバー (メール送信)]
```

#### 主要コンポーネント

| コンポーネント | 技術スタック | 説明 |
|--------------|------------|------|
| Webサーバー | IIS 5以上 | ASP/VBScriptアプリケーションのホスティング |
| アプリケーション層 | Classic ASP, VBScript | CMSロジック、ページレンダリング |
| 画像処理 | ASP.NET 2.0 | サムネイル生成（showThumb.aspx） |
| データベース | Access/SQL Server/MySQL | コンテンツ、設定、ラベルの永続化 |
| メールサービス | CDO/Persits/JMail | メール通知機能 |

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Webサーバー | IIS Webサーバー、ASPアプリケーション実行 | Windows Server 2012以上、IIS 7.5以上推奨 | 1台以上 |
| DBサーバー | データ永続化（SQL Server使用時） | Windows Server、SQL Server 2005以上 | 0〜1台 |
| メールサーバー | SMTP経由のメール送信 | SMTPサービス対応サーバー | 1台（外部サービス利用可） |

#### 最小構成

- 単一サーバー構成（Web + DB on Access）
- IISが稼働するWindows Server/Windows OS
- 32bit アプリケーションプール（Access使用時）

#### 推奨構成

- Webサーバー: IIS 10（Windows Server 2016/2019/2022）
- DBサーバー: SQL Server 2019以上（別サーバー）
- メールサーバー: 外部SMTPサービス

### ネットワーク構成

#### ポート要件

| プロトコル | ポート | 用途 |
|----------|-------|------|
| HTTP | 80 | Webアクセス（非SSL） |
| HTTPS | 443 | Webアクセス（SSL推奨） |
| SMTP | 25 | メール送信（デフォルト） |
| SMTP over SSL | 465/587 | メール送信（SSL対応） |
| SQL Server | 1433 | データベース接続（SQL Server使用時） |
| MySQL | 3306 | データベース接続（MySQL使用時） |

#### ネットワークセグメント

```
[インターネット]
       |
   [ファイアウォール]
       |
[DMZ/Webサーバー] --- [内部ネットワーク/DBサーバー]
       |
   [SMTPサーバー]
```

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| IIS | 5.0以上（推奨: 7.5以上） | Webサーバー、ASPホスティング |
| ASP.NET Framework | 2.0 | 画像サムネイル処理（showThumb.aspx） |
| Microsoft Jet OLEDB | 4.0 | Accessデータベース接続 |
| Microsoft SQLOLEDB | - | SQL Serverデータベース接続 |
| MySQL ODBC | 3.51 | MySQLデータベース接続 |
| CKEditor | 4.4.5 | リッチテキストエディタ |
| jQuery | 1.x | フロントエンドJavaScript |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| SMTPサーバー | メール送信（フォーム送信通知、ニュースレター等） | SMTP/SMTPS |
| テンプレートギャラリー | オンラインテンプレートダウンロード | HTTPS（templates31.quickersite.com） |
| jstemplates.com | テンプレート生成サービス | HTTPS（外部Webサービス） |

### メールコンポーネント対応

| コンポーネント | 設定値 | 説明 |
|--------------|-------|------|
| CDO.Message | cdo.message | Windows標準のCDOコンポーネント |
| Persits ASPEmail | persits.mailsender | サードパーティ製メールコンポーネント |
| JMail | jmail.message | サードパーティ製メールコンポーネント |
| CDONTS | cdonts.newmail | 旧式メールコンポーネント |
| SMTPsvg | smtpsvg.mailer | サードパーティ製メールコンポーネント |

## ストレージ構成

### ディレクトリ構成

```
/QuickerSite/
├── asp/                    # ASPソースコード
│   ├── config/            # 設定ファイル
│   │   ├── web_config.asp # メイン設定
│   │   └── rebrand.asp    # ブランディング設定
│   └── includes/          # 共通インクルードファイル
├── db/                     # データベースファイル（Access）
│   ├── QuickerSite.mdb    # メインデータベース
│   └── QuickerLabels.mdb  # ラベルデータベース
├── UserFiles/             # ユーザーアップロードファイル
│   ├── catalogfiles/      # カタログファイル
│   ├── pagemedia/         # ページメディア
│   ├── PG/                # ページギャラリー
│   └── templates/         # カスタムテンプレート
├── templates/             # システムテンプレート
├── ckeditor445/           # CKEditorリソース
├── js/                    # JavaScriptファイル
├── css/                   # CSSファイル
├── fixedImages/           # 固定画像リソース
└── web.config             # IIS設定ファイル
```

### 必要なディスク容量

| 項目 | 推奨容量 | 説明 |
|-----|---------|------|
| システムファイル | 100MB | ASPコード、CSS、JS、画像等 |
| データベース | 50MB〜1GB | コンテンツ量に依存 |
| ユーザーファイル | 1GB〜10GB | アップロードファイル量に依存 |
| ログファイル | 500MB | IISログ、アプリケーションログ |
| **合計** | **2GB〜12GB** | 運用規模に応じて調整 |

### ファイルシステム権限

| パス | 必要な権限 | 対象ユーザー |
|-----|----------|------------|
| /db/ | 読み取り/書き込み | IUSR, IIS_IUSRS |
| /UserFiles/ | 読み取り/書き込み | IUSR, IIS_IUSRS |
| /asp/config/ | 読み取り/書き込み | IUSR, IIS_IUSRS |
| その他 | 読み取り | IUSR, IIS_IUSRS |

## スケーリング設計

### 水平スケーリング

現行アーキテクチャでは、以下の制約により水平スケーリングに制限があります：

- **Access使用時**: ファイルベースDBのため、単一サーバー構成のみ
- **SQL Server使用時**: 複数Webサーバー構成が可能（セッション外部化が必要）

### 垂直スケーリング

| リソース | 推奨スペック（小規模） | 推奨スペック（中規模） |
|---------|---------------------|---------------------|
| CPU | 2コア | 4コア以上 |
| メモリ | 4GB | 8GB以上 |
| ストレージ | 50GB SSD | 200GB SSD |

### スケーリング戦略

1. **データベース移行**: Access → SQL Server への移行により、より大きな負荷に対応
2. **静的コンテンツCDN**: 画像、CSS、JSファイルをCDN経由で配信
3. **キャッシング**: IIS Output Cachingの活用

## 可用性設計

### 現行の可用性対策

| 項目 | 対策 |
|-----|------|
| アプリケーション可用性 | IIS Application Pool自動リサイクル |
| データベース可用性 | SQL Server使用時のみフェイルオーバー可能 |
| 404エラー処理 | web.configによるカスタムエラーページ |

### 推奨される可用性対策

1. **ロードバランサー導入**: 複数Webサーバー構成時
2. **SQL Server Always On**: データベースの高可用性
3. **Windows Server Failover Clustering**: サーバーレベルの冗長性

### セッション管理

- デフォルト: ASPセッション（メモリ内）
- タイムアウト: 30分
- Cookie対応: `QS_enableCookieMode=true` でCookieベースセッションに対応

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| データベース（Access） | ファイルコピー | 日次 | 30日 |
| データベース（SQL Server） | SQL Serverバックアップ | 日次（フル）、1時間毎（差分） | 30日 |
| UserFiles | ファイルコピー/rsync | 日次 | 30日 |
| 設定ファイル | ファイルコピー | 変更時 | 永続 |
| システム全体 | イメージバックアップ | 週次 | 4世代 |

### リストア手順

1. **データベースリストア**: .mdbファイルの置換またはSQL Serverリストア
2. **ファイルリストア**: UserFilesディレクトリの復元
3. **設定復元**: web_config.aspの復元
4. **IISリセット**: アプリケーションプールのリサイクル

## 監視設計

### 監視項目

| 監視カテゴリ | 監視項目 | 閾値/条件 |
|------------|---------|----------|
| サーバーリソース | CPU使用率 | 80%以上でアラート |
| サーバーリソース | メモリ使用率 | 85%以上でアラート |
| サーバーリソース | ディスク使用率 | 90%以上でアラート |
| アプリケーション | IIS Application Pool状態 | 停止時アラート |
| アプリケーション | HTTPレスポンス | 5xx エラー発生時 |
| データベース | 接続数 | 最大接続数の80%でアラート |
| データベース | データベースサイズ | 制限値の80%でアラート |

### 推奨監視ツール

- Windows Performance Monitor
- IIS Manager
- SQL Server Management Studio（SQL Server使用時）
- サードパーティ監視ツール（Zabbix、Nagios等）

## セキュリティ設計

### 認証・認可

| 機能 | 実装方式 |
|-----|---------|
| 管理者認証 | パスワード認証（SHA-256ハッシュ） |
| ログイン試行制限 | 5回失敗でロックアウト |
| セッション管理 | ASPセッション + Cookie |

### セキュリティ対策

| 対策項目 | 実装内容 |
|---------|---------|
| ファイルタイプ制限 | 危険な拡張子（.php, .exe, .jsp等）のブロック |
| データベースファイル保護 | 初回起動時に.mdbファイル名を自動変更 |
| 入力検証 | SQL文のパラメータ化（一部） |
| HTTPエラー処理 | 404エラーのカスタム処理 |

### 推奨セキュリティ強化策

1. **HTTPS強制**: SSL/TLS証明書の導入
2. **WAF導入**: Webアプリケーションファイアウォール
3. **定期的なパスワード変更**: 管理者パスワードのローテーション
4. **IPアドレス制限**: 管理画面へのアクセス制限
5. **セキュリティヘッダー**: X-Frame-Options、Content-Security-Policy等の設定

## デプロイメント設計

### 初期インストール手順

1. IIS Webサイトのルートにファイルを配置
2. IUSRにフォルダ全体のフルアクセス権限を付与
3. デフォルトドキュメントを「default.asp」に設定
4. アプリケーションプールで32bitアプリケーションを有効化（Access使用時）
5. ブラウザでサイトにアクセスし、初期パスワード（admin）を変更

### 更新デプロイメント

1. サイトをオフラインモードに設定（`C_DEV=true`）
2. ファイルのバックアップを取得
3. 新しいファイルを上書き
4. データベーススキーマの更新（必要な場合）
5. オフラインモードを解除（`C_DEV=false`）
6. 動作確認

### IIS設定（web.config）

```xml
<?xml version="1.0" encoding="UTF-8"?>
<configuration>
  <system.webServer>
    <httpErrors>
      <remove statusCode="404" subStatusCode="-1" />
      <error statusCode="404" path="/default.asp" responseMode="ExecuteURL" />
    </httpErrors>
    <modules runAllManagedModulesForAllRequests="true" />
  </system.webServer>
</configuration>
```

## 備考

### 動作確認済み環境

- Windows Server 2012 R2 + IIS 8.5
- Windows Server 2016 + IIS 10
- Windows Server 2019 + IIS 10
- Windows 10/11 + IIS Express（開発環境）

### 既知の制限事項

1. **Access使用時の同時接続制限**: 同時接続数に制限あり（推奨: 10接続以下）
2. **32bitアプリケーションプール**: Access使用時は32bitモードが必須
3. **セッションの永続性**: アプリケーションプールリサイクル時にセッションが失われる

### 関連ドキュメント

- QuickerSite公式サポート: https://quickersite.com/support
- IIS管理ガイド: Microsoft公式ドキュメント
- SQL Server接続設定: asp/config/web_config.asp参照

### バージョン情報

- QuickerSite バージョン: 4.4
- 本ドキュメント作成日: 2026-01-24
