---
generated_at: 2026-01-24 15:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **HTTPS/HSTS設定**：サーバー設定に依存するため、実際の設定確認が必要
  2. **ログ保持期間**：コードからは保持期間の設定を確認できず
  3. **CSRF対策の適用範囲**：全フォームでの実装状況の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/LogonEdit.asp` - 認証クラス（cls_LogonEdit）
- E-02: `asp/includes/sha256.asp` - SHA-256ハッシュ実装
- E-03: `asp/includes/md5.asp` - MD5ハッシュ実装
- E-04: `asp/includes/encryption.asp` - 暗号化関数（encrypt/decrypt）
- E-05: `asp/bs_security.asp` - バックサイトセキュリティチェック
- E-06: `asp/ad_security.asp` - 管理者セキュリティチェック
- E-07: `asp/assetmanager/security.asp` - アセットマネージャーセキュリティ
- E-08: `asp/includes/secondAdmin.asp` - セカンドアドミン権限クラス
- E-09: `asp/includes/functions.asp` - ユーティリティ関数（sanitize, cleanUp, filterJS等）
- E-10: `asp/begin.asp` - アプリケーション初期化・ファイルタイプ制限
- E-11: `asp/config/web_config.asp` - 設定ファイル
- E-12: `asp/includes/captcha.asp` - CAPTCHA実装
- E-13: `asp/bs_login.asp` - バックサイトログイン処理
- E-14: `asp/process_login.asp` - フロントログイン処理
- E-15: `modules/ajax.asp` - Ajax処理（sanitize関数定義含む）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SHA-256によるパスワードハッシュ化 | E-02, E-13 | ○ |
| C-02 | MD5ハッシュ実装の存在 | E-03 | ○ |
| C-03 | ROT13変形による簡易暗号化 | E-04 | ○ |
| C-04 | セッションタイムアウト30分 | E-10 | ○ |
| C-05 | ログイン試行回数制限（5回） | E-01, E-11 | ○ |
| C-06 | IPアドレスベースのロックアウト | E-01 | ○ |
| C-07 | CAPTCHA実装 | E-12, E-13 | ○ |
| C-08 | セカンドアドミン権限体系（約50項目） | E-08 | ○ |
| C-09 | sanitize関数によるXSS対策 | E-09, E-15 | ○ |
| C-10 | cleanUp関数によるSQLインジェクション対策 | E-09 | ○ |
| C-11 | filterJS関数によるJSイベント無効化 | E-09 | ○ |
| C-12 | removeCRB関数によるコードインジェクション対策 | E-09 | ○ |
| C-13 | ファイルアップロード拡張子制限 | E-10 | ○ |
| C-14 | キャッシュ制御ヘッダーの設定 | E-10, E-07 | ○ |
| C-15 | セッション変数によるアクセス制御 | E-05, E-06, E-07 | ○ |
| C-16 | デフォルトパスワードブロック機能 | E-05, E-10 | ○ |
| C-17 | エラーメール通知機能 | E-09 | ○ |
| C-18 | 訪問者ログ機能 | E-10 | ○ |
| C-19 | ユーザー最終ログイン記録 | E-01 | ○ |
| C-20 | Cookie認証モード | E-01, E-11 | ○ |
| C-21 | 管理者認証とバックサイト認証の分離 | E-05, E-06 | ○ |
| C-22 | イントラネットユーザー認証 | E-01 | ○ |
| C-23 | ページ単位のパスワード保護 | E-01 | ○ |
| C-24 | Server.HTMLEncodeの使用 | E-15 | ○ |
| C-25 | データベース設定の平文保存 | E-11 | ○ |
| C-26 | SMTP認証情報の平文保存 | E-11 | ○ |
| C-27 | 許可ファイルタイプの定義 | E-09 | ○ |
| C-28 | 禁止拡張子のブロック処理 | E-10 | ○ |
| C-29 | quotRep関数の実装 | E-09 | ○ |
| C-30 | パスワード変更強制機能 | E-05 | ○ |
| C-31 | プライマリ/セカンドアドミンパスワード重複禁止 | E-08 | ○ |
| C-32 | ログイン試行メール通知 | E-01 | ○ |
| C-33 | HTTPS強制設定 | **根拠なし** | △ |
| C-34 | HSTS設定 | **根拠なし** | △ |
| C-35 | 監査ログの保持期間設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **HTTPS/HSTS設定**：アプリケーションコード内でHTTPS強制やHSTSヘッダー設定の実装が確認できなかった。IIS設定ファイル（web.config）やサーバー設定に依存している可能性がある。
  - 候補：IIS設定 / web.config / インフラ設計書
- **監査ログ保持期間**：ログのデータベーステーブル構造やログローテーション設定が確認できなかった。
  - 候補：データベーススキーマ / 運用マニュアル / インフラ設計書
- **CSRF対策の網羅性**：`QS_secCodeHidden`の使用箇所を網羅的に確認できていない。全フォームでの実装状況の確認が必要。
  - 候補：全ASPファイルの詳細調査 / テスト結果

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: HTTPS/HSTS設定 - Webサーバー設定の確認が必要
- **1（中リスク）**: CSRF対策の網羅性 - 全フォームでの実装確認が必要
- **0（低リスク）**: 監査ログ保持期間 - 運用要件との照合が必要
- **1（中リスク）**: パラメータ化クエリ未使用 - cleanUp関数のみでのSQLインジェクション対策
- **1（中リスク）**: ROT13暗号化の使用 - セキュリティ目的には不適切な暗号化方式

## 6) レビュアーチェックリスト（最小）
- [ ] IISまたはWebサーバーでHTTPS強制設定が行われているか確認
- [ ] データベースファイル（/db/）への直接アクセスがブロックされているか確認
- [ ] web_config.aspへの直接アクセスがブロックされているか確認
- [ ] 本番環境でデフォルトパスワード（admin）が使用されていないか確認
- [ ] CSRF対策（QS_secCodeHidden）が全ての重要フォームに実装されているか確認
- [ ] SQLインジェクション対策（cleanUp関数）が全てのユーザー入力に適用されているか確認
- [ ] ファイルアップロード機能で許可拡張子以外がアップロードできないか確認
- [ ] セッションタイムアウトが運用要件に適合しているか確認
- [ ] エラーメール通知先（C_ADMINEMAIL）が適切に設定されているか確認
