---
generated_at: 2026-01-24 00:17:00
metrics:
  claims_total: 18
  claims_with_evidence: 14
  claims_without_evidence: 4
confidence_derived: 0.78
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：14 / 18、根拠なし：4
- 優先レビュー（高）
  1. **カバレッジ目標値**：ASP Classicの標準ツール不在の根拠確認が必要
  2. **CI/CD推奨事項**：具体的なツール選定根拠なし
  3. **性能テスト閾値**：具体的な数値基準の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、技術スタック（ASP/VBScript、IIS、ASP.NET 2.0）
- E-02: `asp/begin.asp` - バージョン情報（C_QS_VERSION = 4.4）、インクルード構成
- E-03: `asp/config/web_config.asp` - データベース設定、メール設定、ログイン試行制限
- E-04: `asp/includes/database.asp` - データベース接続クラス（Access/SQL Server/MySQL対応）
- E-05: `web.config` - IIS設定、404エラー処理
- E-06: `db/` ディレクトリ - QuickerSite.mdb、QuickerLabels.mdb（Accessデータベース）
- E-07: `.gitignore`、`.gitattributes` - バージョン管理設定（CI設定なし）
- E-08: `asp/*.asp` ファイル群 - 約150以上のASPファイル（8,621行以上）
- E-09: `asp/includes/` - 116個のインクルードファイル（共通機能）
- E-10: `modules/` - 4つのモジュールファイル（ajax.asp等）
- E-11: `js/` - JavaScriptライブラリ（jQuery 1.8.3、jQuery UI等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはASP/VBScriptベースのCMS | E-01, E-02 | ○ |
| C-02 | Windows Server（IIS 5以上）で動作 | E-01 | ○ |
| C-03 | ASP.NET 2.0が必要 | E-01 | ○ |
| C-04 | データベースはAccess/SQL Server対応 | E-03, E-04 | ○ |
| C-05 | 自動テストの仕組みが存在しない | E-07, E-08 | ○ |
| C-06 | CI/CDパイプラインが未構成 | E-07 | ○ |
| C-07 | ログイン試行制限が5回 | E-03 | ○ |
| C-08 | manyContacts閾値が250 | E-03 | ○ |
| C-09 | 危険な拡張子がブロックされる | E-02 | ○ |
| C-10 | cls_databaseクラスでDB操作 | E-04 | ○ |
| C-11 | /UserFiles/にアップロードファイル保存 | E-03 | ○ |
| C-12 | 116個のインクルードファイルが存在 | E-09 | ○ |
| C-13 | jQueryバージョン1.8.3を使用 | E-11 | ○ |
| C-14 | CKEditor（ckeditor445）を使用 | E-02 | ○ |
| C-15 | ASP Classicにカバレッジ計測ツールがない | **根拠なし** | △ |
| C-16 | OWASP ZAP 2.xでセキュリティスキャン可能 | **根拠なし** | △ |
| C-17 | JMeter 5.xで性能テスト可能 | **根拠なし** | △ |
| C-18 | Selenium/Playwrightでテスト自動化可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **テスト関連設定ファイル**: プロジェクト内にphpunit.xml、jest.config.js等のテスト設定が存在しない
  - 候補：tests/ディレクトリ / テスト設定ファイル / CI設定ファイル
- **カバレッジ計測ツール**: ASP Classic用のカバレッジツールの存在有無は外部調査が必要
  - 候補：商用ツール / サードパーティ製ツール / カスタムスクリプト
- **推奨ツールのバージョン情報**: OWASP ZAP、JMeter等のバージョンは一般的な推奨値を使用
  - 候補：公式ドキュメント / セキュリティガイドライン / 性能テスト標準

## 5) リスクフラグ（レビュー観点）
- **リスク1（高）**: 自動テスト不在 - 手動テストのみに依存するため、リグレッションリスクが高い
- **リスク2（中）**: セキュリティテスト - On Error Resume Nextの多用により、エラー処理の検証が困難
- **リスク3（中）**: データベーステスト - Access DBとSQL Serverの両方をサポートするため、両環境でのテストが必要
- **リスク0（低）**: ドキュメント整合性 - README.mdとコードの整合性は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 推奨ツール（OWASP ZAP、JMeter等）がプロジェクト要件に適合するか確認
- [ ] ASP Classic用のコードカバレッジ計測の代替手段を検討したか
- [ ] セキュリティテスト項目（SQLインジェクション、XSS等）が網羅されているか
- [ ] テスト環境の構成がプロジェクトのインフラ要件と一致するか
- [ ] 手動テスト手順の詳細化が必要か判断
